/*
 * Decompiled with CFR 0.152.
 */
package javakara;

import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.Application;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.abstractscriptide.AbstractScriptInterpreter;
import ch.karatojava.kapps.abstractscriptide.ScriptException;
import ch.karatojava.kapps.abstractscriptide.ScriptTools;
import ch.karatojava.kapps.javakaraide.JavaKaraApplication;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraException;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.karaide.worldobjects.MUSHROOM;
import ch.karatojava.kapps.karaide.worldobjects.TREE;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldInternalException;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import java.awt.Point;
import java.io.File;

public class JavaKaraProgram {
    public static int MIN_SLEEP_TIME = 20;
    public JavaKara kara;
    public JavaKara redKara;
    public JavaKara greenKara;
    public JavaKara yellowKara;
    public JavaKara violetKara;
    public JavaKaraWorld world;
    public ScriptTools tools;
    private RunnableInterface thread;

    protected void init() {
        String string = Configuration.getInstance().getCurrentValue("karamodel");
        this.kara = string.equalsIgnoreCase("javakara") || string.equalsIgnoreCase("javascriptkara") || string.equalsIgnoreCase("rubykara") || string.equalsIgnoreCase("pythonkara") ? new JavaKara("Kara") : new JavaKara("Xara");
        this.redKara = new JavaKara("Xara");
        this.greenKara = new JavaKara("Tara");
        this.yellowKara = new JavaKara("Dara");
        this.violetKara = new JavaKara("Lara");
        this.world = new JavaKaraWorld();
        this.tools = new ScriptTools();
    }

    public void setInterpreter(RunnableInterface runnableInterface) {
        assert (runnableInterface != null);
        this.thread = runnableInterface;
        if (this.tools == null) {
            this.tools = new ScriptTools();
        }
        this.tools.setInterpreter(runnableInterface);
    }

    public void setWorld(World world) {
        this.init();
        assert (world != null) : "JavaKaraProgram.setWorld: world == null";
        this.world.world = world;
        this.kara.kara = null;
    }

    public boolean isStopException(Exception exception) {
        return exception instanceof AbstractScriptInterpreter.StopException;
    }

    private void checkThreadState() {
        if (this.thread != null) {
            this.thread.checkThreadState();
        } else {
            try {
                Thread.sleep(MIN_SLEEP_TIME);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void myProgram() throws ScriptException {
    }

    protected void checkCanPutObject(WorldObjectInterface worldObjectInterface, int n, int n2) {
        this.world.world.checkCoordinate(n, n2);
        if (!this.world.world.canPutObjectAt(worldObjectInterface, n, n2)) {
            throw new RuntimeException(Configuration.getInstance().getFormatString("language/$language/kawomodel/karaexception/illegalobjectaddition", new String[]{"" + n, "" + n2}));
        }
    }

    public final void run(String string) {
        JavaKaraApplication javaKaraApplication = new JavaKaraApplication();
        javaKaraApplication.startApplication(new String[0]);
        this.init();
        WorldEditorFacadeInterface worldEditorFacadeInterface = Application.getInstance().getWorldEditorFacade();
        if (string != null) {
            try {
                worldEditorFacadeInterface.getWorldEditorIoToolbar().loadFile(new File(string));
                this.setWorld((World)worldEditorFacadeInterface.getWorldEditor().getContent());
                this.kara.kara = Kara.findKaraInWorld(this.world.world, "Kara");
            }
            catch (Exception exception) {
                ExceptionActionListener.reportException(worldEditorFacadeInterface.getWorldEditorGui(), "", new Exception(Configuration.getInstance().getFormatString("language/$language/iomessages/error", new String[]{exception.getMessage()})));
            }
        }
        if (this.world.world == null) {
            this.setWorld((World)worldEditorFacadeInterface.getWorldEditor().getContent());
        }
        if (this.kara.kara == null) {
            this.kara.kara = new Kara("Kara");
        }
        try {
            this.myMainProgram();
        }
        catch (Exception exception) {
            ExceptionActionListener.reportException(worldEditorFacadeInterface.getWorldEditorGui(), "", exception);
        }
    }

    public final void run() {
        this.run(null);
    }

    protected void myMainProgram() {
    }

    public class JavaKaraWorld {
        private World world;
        public static final int NORTH = 0;
        public static final int WEST = 1;
        public static final int SOUTH = 2;
        public static final int EAST = 3;

        public final void setMushroom(int n, int n2, boolean bl) {
            this.world.checkCoordinate(n, n2);
            if (bl && !this.world.isObjectOfTypeAt(MUSHROOM.getInstance(), n, n2)) {
                JavaKaraProgram.this.checkCanPutObject(MUSHROOM.getInstance(), n, n2);
                this.world.putObjectAt(MUSHROOM.getInstance(), n, n2);
            } else if (!bl && this.world.isObjectOfTypeAt(MUSHROOM.getInstance(), n, n2)) {
                this.world.removeObjectAt(MUSHROOM.getInstance(), n, n2);
            }
        }

        public final void setLeaf(int n, int n2, boolean bl) {
            this.world.checkCoordinate(n, n2);
            if (bl && !this.world.isObjectOfTypeAt(LEAF.getInstance(), n, n2)) {
                JavaKaraProgram.this.checkCanPutObject(LEAF.getInstance(), n, n2);
                this.world.putObjectAt(LEAF.getInstance(), n, n2);
            } else if (!bl && this.world.isObjectOfTypeAt(LEAF.getInstance(), n, n2)) {
                this.world.removeObjectAt(LEAF.getInstance(), n, n2);
            }
        }

        public final void setTree(int n, int n2, boolean bl) {
            this.world.checkCoordinate(n, n2);
            if (bl && !this.world.isObjectOfTypeAt(TREE.getInstance(), n, n2)) {
                JavaKaraProgram.this.checkCanPutObject(TREE.getInstance(), n, n2);
                this.world.putObjectAt(TREE.getInstance(), n, n2);
            } else if (!bl && this.world.isObjectOfTypeAt(TREE.getInstance(), n, n2)) {
                this.world.removeObjectAt(TREE.getInstance(), n, n2);
            }
        }

        public final void setSize(int n, int n2) {
            this.world.checkSize(n, n2);
            this.world.setSize(n, n2);
        }

        public final int getSizeX() {
            return this.world.getSizeX();
        }

        public final int getSizeY() {
            return this.world.getSizeY();
        }

        public final boolean isEmpty(int n, int n2) {
            this.world.checkCoordinate(n, n2);
            return this.world.isNoObjectAt(n, n2);
        }

        public final boolean isTree(int n, int n2) {
            this.world.checkCoordinate(n, n2);
            return this.world.isObjectOfTypeAt(TREE.getInstance(), n, n2);
        }

        public final boolean isMushroom(int n, int n2) {
            this.world.checkCoordinate(n, n2);
            return this.world.isObjectOfTypeAt(MUSHROOM.getInstance(), n, n2);
        }

        public final boolean isLeaf(int n, int n2) {
            this.world.checkCoordinate(n, n2);
            return this.world.isObjectOfTypeAt(LEAF.getInstance(), n, n2);
        }

        public final void clearAll() {
            this.world.clearAll();
        }
    }

    public class JavaKara {
        private Kara kara;
        private String karaName;

        public JavaKara(String string) {
            this.karaName = string;
        }

        public final void setPosition(int n, int n2) {
            if (Kara.findKaraInWorld(JavaKaraProgram.this.world.world, this.karaName) != null) {
                this.checkKaraInWorld();
                JavaKaraProgram.this.checkCanPutObject(this.kara, n, n2);
                this.kara.setPosition(n, n2);
            } else {
                this.kara = (Kara)Kara.getKara(this.karaName).cloneWorldObject();
                JavaKaraProgram.this.checkCanPutObject(this.kara, n, n2);
                JavaKaraProgram.this.world.world.putObjectAt(this.kara, n, n2);
            }
            JavaKaraProgram.this.checkThreadState();
        }

        public void setDirection(int n) {
            this.checkKaraInWorld();
            if (n < 0 || n > 3) {
                throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/setillegaldirection", new String[]{"" + n});
            }
            this.kara.setDirection(n);
            JavaKaraProgram.this.checkThreadState();
        }

        public Point getPosition() {
            this.checkKaraInWorld();
            JavaKaraProgram.this.checkThreadState();
            return this.kara.getPosition();
        }

        public final boolean move() {
            this.checkKaraInWorld();
            try {
                this.kara.move();
            }
            catch (KaraException karaException) {
                throw new RuntimeException(karaException.getMessage());
            }
            JavaKaraProgram.this.checkThreadState();
            return true;
        }

        public final boolean turnRight() {
            this.checkKaraInWorld();
            this.kara.turnRight();
            JavaKaraProgram.this.checkThreadState();
            return true;
        }

        public final boolean turnLeft() {
            this.checkKaraInWorld();
            this.kara.turnLeft();
            JavaKaraProgram.this.checkThreadState();
            return true;
        }

        public final boolean putLeaf() {
            this.checkKaraInWorld();
            try {
                this.kara.putLeaf();
            }
            catch (KaraException karaException) {
                throw new RuntimeException(karaException.getMessage());
            }
            JavaKaraProgram.this.checkThreadState();
            return true;
        }

        public final boolean removeLeaf() {
            this.checkKaraInWorld();
            try {
                this.kara.removeLeaf();
            }
            catch (KaraException karaException) {
                throw new RuntimeException(karaException.getMessage());
            }
            JavaKaraProgram.this.checkThreadState();
            return true;
        }

        public final boolean treeFront() {
            this.checkKaraInWorld();
            JavaKaraProgram.this.checkThreadState();
            return this.kara.treeFront();
        }

        public final boolean treeLeft() {
            this.checkKaraInWorld();
            JavaKaraProgram.this.checkThreadState();
            return this.kara.treeLeft();
        }

        public final boolean treeRight() {
            this.checkKaraInWorld();
            JavaKaraProgram.this.checkThreadState();
            return this.kara.treeRight();
        }

        public final boolean mushroomFront() {
            this.checkKaraInWorld();
            JavaKaraProgram.this.checkThreadState();
            return this.kara.mushroomFront();
        }

        public final boolean onLeaf() {
            this.checkKaraInWorld();
            JavaKaraProgram.this.checkThreadState();
            return this.kara.onLeaf();
        }

        protected void checkKaraInWorld() {
            if (this.kara == null) {
                assert (JavaKaraProgram.this.world.world != null);
                this.kara = Kara.findKaraInWorld(JavaKaraProgram.this.world.world, this.karaName);
                if (this.kara == null) {
                    throw new RuntimeException(Configuration.getInstance().getString("language/$language/kawomodel/karaexception/nokarainworld"));
                }
            }
        }
    }
}

