/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.rieditor;

import ch.karatojava.util.gui.dndpanel.DndPanel;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import ch.karatojava.util.gui.rieditor.DefaultRow;
import ch.karatojava.util.gui.rieditor.ItemInterface;
import ch.karatojava.util.gui.rieditor.ItemUiInterface;
import ch.karatojava.util.gui.rieditor.RowInterface;
import ch.karatojava.util.gui.rieditor.RowItemModelInterface;
import ch.karatojava.util.gui.rieditor.RowItemUiFactoryInterface;
import ch.karatojava.util.gui.rieditor.RowUiInterface;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class RowItemEditor
extends JPanel
implements LightweightDragDrop {
    private static final long serialVersionUID = 1L;
    private static final int DRAG_IMAGE_MAX_WIDTH = 125;
    private List<RowUiInterface> rowUiList;
    private RowUiInterface dropTargetRowUi;
    private ItemUiInterface dropTargetItemUi;
    private boolean dropTargetItemInsert;
    private boolean deleteWhenMoving = true;
    private DummyRowUi dummyRowUi;
    private JComponent headerRow;
    private JComponent newRowComponent;
    private RowItemModelInterface model;
    private RowItemUiFactoryInterface factory;
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            RowItemEditor.this.resetDropTargets();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            RowItemEditor.this.resetDropTargets();
            int n = mouseEvent.getModifiers();
            if ((n & 4) > 0 || (n & 0x10) > 0 && (n & 2) > 0) {
                Object object;
                Point point = mouseEvent.getPoint();
                RowInterface rowInterface = null;
                ItemInterface itemInterface = null;
                int n2 = RowItemEditor.this.getRowUiIndex(point);
                if (0 <= n2 && n2 < RowItemEditor.this.model.size()) {
                    object = (RowUiInterface)RowItemEditor.this.rowUiList.get(n2);
                    rowInterface = object.getRow();
                    int n3 = RowItemEditor.this.getItemUiIndex((RowUiInterface)object, point);
                    if (0 <= n3 && n3 < rowInterface.size()) {
                        itemInterface = rowInterface.get(n3);
                    }
                }
                if ((object = RowItemEditor.this.factory.getPopupMenu(rowInterface, itemInterface)) != null) {
                    ((JPopupMenu)object).show(RowItemEditor.this, point.x, point.y);
                }
            }
        }
    };

    public RowItemEditor(RowItemUiFactoryInterface rowItemUiFactoryInterface) {
        this.factory = rowItemUiFactoryInterface;
        rowItemUiFactoryInterface.setRowItemEditor(this);
        this.setLayout(new BoxLayout(this, 1));
        this.rowUiList = new ArrayList<RowUiInterface>();
        this.addMouseListener(this.mouseListener);
    }

    public void setRowItemModel(RowItemModelInterface rowItemModelInterface) {
        int n;
        RowInterface[] rowInterfaceArray = rowItemModelInterface.getRows();
        JComponent[] jComponentArray = new JComponent[rowInterfaceArray.length];
        for (n = 0; n < rowInterfaceArray.length; ++n) {
            RowUiInterface rowUiInterface = this.factory.createRowUi(rowInterfaceArray[n]);
            jComponentArray[n] = rowUiInterface.getUiComponent();
            this.addItemUisToRowUi(rowInterfaceArray[n], rowUiInterface);
        }
        this.model = rowItemModelInterface;
        rowItemModelInterface.setRowItemEditor(this);
        this.rowUiList.clear();
        this.removeAll();
        this.headerRow = this.factory.createHeader();
        this.add(this.headerRow);
        for (n = 0; n < rowInterfaceArray.length; ++n) {
            jComponentArray[n].setBorder(this.factory.getRowEmptyBorder());
            this.add(jComponentArray[n]);
            this.rowUiList.add((RowUiInterface)((Object)jComponentArray[n]));
        }
        this.dummyRowUi = new DummyRowUi();
        this.dummyRowUi.setBorder(this.factory.getRowEmptyBorder());
        this.newRowComponent = this.factory.createAddRowComponent();
        if (this.newRowComponent != null) {
            this.newRowComponent.setBorder(this.factory.getRowEmptyBorder());
            this.add(this.newRowComponent);
        } else {
            this.newRowComponent = this.dummyRowUi;
        }
        this.add(this.dummyRowUi);
    }

    public void setDeleteWhenMoving(boolean bl) {
        this.deleteWhenMoving = bl;
    }

    public boolean getDeleteWhenMoving() {
        return this.deleteWhenMoving;
    }

    public RowItemModelInterface getRowItemModel() {
        return this.model;
    }

    @Override
    public BufferedImage getDragImage(Object object) {
        Component component = (Component)object;
        int n = Math.min(125, component.getWidth());
        int n2 = component.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setClip(0, 0, n, n2);
        component.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public RowUiInterface getRowUi(int n) {
        return this.rowUiList.get(n);
    }

    public JComponent getHeaderRow() {
        return this.headerRow;
    }

    @Override
    public Object acceptsDrag(MouseEvent mouseEvent) {
        return this.determineDragSource(mouseEvent.getPoint());
    }

    @Override
    public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
        this.determineDropTarget(mouseEvent.getPoint(), object);
        return this.dropTargetRowUi != null && (object instanceof RowUiInterface || object instanceof ItemUiInterface);
    }

    @Override
    public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
    }

    @Override
    public void dropTransferObject(MouseEvent mouseEvent, Object object) {
        if (object instanceof RowUiInterface) {
            this.dropTransferRow((RowUiInterface)object);
        } else if (object instanceof ItemUiInterface) {
            this.dropTransferItem((ItemUiInterface)object);
        }
        this.resetDropTargets();
    }

    public void modelRowRemoved(RowInterface rowInterface, int n) {
        this.rowUiList.remove(n);
        this.remove(n + 1);
        this.updateRowIndices();
        this.revalidate();
        this.repaint();
    }

    public void modelRowAdded(int n) {
        RowInterface rowInterface = this.model.get(n);
        RowUiInterface rowUiInterface = this.factory.createRowUi(rowInterface);
        this.addItemUisToRowUi(rowInterface, rowUiInterface);
        JComponent jComponent = rowUiInterface.getUiComponent();
        DndPanel.findDndPanel(this).addThisMouseInputListenerToChildren(jComponent);
        jComponent.setBorder(this.factory.getRowEmptyBorder());
        this.add((Component)jComponent, n + 1);
        this.rowUiList.add(n, rowUiInterface);
        this.updateRowIndices();
        this.revalidate();
        this.repaint();
    }

    public void modelItemAdded(RowInterface rowInterface, int n) {
        int n2 = this.model.indexOf(rowInterface);
        if (n2 >= 0) {
            RowUiInterface rowUiInterface = this.rowUiList.get(n2);
            ItemUiInterface itemUiInterface = this.factory.createItemUi(rowInterface.get(n));
            rowUiInterface.addItemUi(itemUiInterface, n);
            JComponent jComponent = itemUiInterface.getUiComponent();
            jComponent.setBorder(this.factory.getItemEmptyBorder());
            this.revalidate();
            this.repaint();
        }
    }

    public void modelItemRemoved(RowInterface rowInterface, ItemInterface itemInterface, int n) {
        int n2 = this.model.indexOf(rowInterface);
        if (n2 >= 0) {
            RowUiInterface rowUiInterface = this.rowUiList.get(n2);
            rowUiInterface.removeUiItem(n);
            this.revalidate();
            this.repaint();
        }
    }

    public int rowCount() {
        return this.model.size();
    }

    private int getRowUiIndex(Point point) {
        Component[] componentArray = this.getComponents();
        Rectangle rectangle = new Rectangle();
        for (int i = 1; i < componentArray.length; ++i) {
            componentArray[i].getBounds(rectangle);
            if (rectangle.y > point.y || point.y > rectangle.y + rectangle.height) continue;
            return i - 1;
        }
        return -1;
    }

    private int getItemUiIndex(RowUiInterface rowUiInterface, Point point) {
        JComponent jComponent = (JComponent)((Object)rowUiInterface);
        Point point2 = new Point(point.x - jComponent.getX(), point.y - jComponent.getY());
        return rowUiInterface.getItemUiIndex(point2);
    }

    private void updateRowIndices() {
        int n = this.model.size();
        for (int i = 0; i < n; ++i) {
            this.rowUiList.get(i).updateIndexDisplay();
        }
    }

    private void addItemUisToRowUi(RowInterface rowInterface, RowUiInterface rowUiInterface) {
        ItemInterface[] itemInterfaceArray = rowInterface.getItems();
        for (int i = 0; i < itemInterfaceArray.length; ++i) {
            ItemUiInterface itemUiInterface = this.factory.createItemUi(itemInterfaceArray[i]);
            rowUiInterface.addItemUi(itemUiInterface, i);
            JComponent jComponent = itemUiInterface.getUiComponent();
            jComponent.setBorder(this.factory.getItemEmptyBorder());
        }
    }

    private void highlightDropTargets(Object object) {
        if (this.dropTargetItemUi != null && object instanceof ItemUiInterface) {
            this.dropTargetItemUi.getUiComponent().setBorder(this.factory.getItemDropBorder(this.dropTargetItemInsert));
        } else if (this.dropTargetRowUi != null && object instanceof RowUiInterface) {
            if (this.dropTargetRowUi == this.dummyRowUi) {
                this.newRowComponent.setBorder(this.factory.getRowDropBorder());
            } else {
                this.dropTargetRowUi.getUiComponent().setBorder(this.factory.getRowDropBorder());
            }
        }
    }

    private void resetDropTargets() {
        if (this.dropTargetRowUi != null) {
            if (this.dropTargetRowUi == this.dummyRowUi) {
                this.newRowComponent.setBorder(this.factory.getRowEmptyBorder());
            } else {
                this.dropTargetRowUi.getUiComponent().setBorder(this.factory.getRowEmptyBorder());
            }
            this.dropTargetRowUi = null;
        }
        if (this.dropTargetItemUi != null) {
            this.dropTargetItemUi.getUiComponent().setBorder(this.factory.getItemEmptyBorder());
            this.dropTargetItemUi = null;
        }
    }

    private void determineDropTarget(Point point, Object object) {
        this.resetDropTargets();
        int n = this.getRowUiIndex(point);
        if (0 <= n && n < this.model.size()) {
            this.dropTargetRowUi = this.rowUiList.get(n);
            RowInterface rowInterface = this.dropTargetRowUi.getRow();
            int n2 = this.getItemUiIndex(this.dropTargetRowUi, point);
            if (0 <= n2 && n2 < rowInterface.size()) {
                this.dropTargetItemUi = this.dropTargetRowUi.getItemUi(n2);
                this.dropTargetItemInsert = true;
            } else if (n2 == rowInterface.size()) {
                this.dropTargetItemUi = n2 > 0 ? this.dropTargetRowUi.getItemUi(rowInterface.size() - 1) : null;
                this.dropTargetItemInsert = false;
            } else {
                this.dropTargetRowUi = null;
            }
        } else {
            this.dropTargetRowUi = n != -1 ? this.dummyRowUi : null;
        }
        this.highlightDropTargets(object);
    }

    private Object determineDragSource(Point point) {
        Object object = null;
        int n = this.getRowUiIndex(point);
        if (0 <= n && n < this.model.size()) {
            RowUiInterface rowUiInterface = this.rowUiList.get(n);
            int n2 = this.getItemUiIndex(rowUiInterface, point);
            object = 0 <= n2 && n2 < rowUiInterface.getRow().size() ? rowUiInterface.getItemUi(n2) : rowUiInterface;
        }
        return object;
    }

    private void dropTransferRow(RowUiInterface rowUiInterface) {
        RowInterface rowInterface = rowUiInterface.getRow();
        if (this.dropTargetRowUi != this.dummyRowUi) {
            int n = this.model.indexOf(this.dropTargetRowUi.getRow());
            this.model.addRow(rowInterface.createCopy(this.model), n);
        } else {
            this.model.addRow(rowInterface.createCopy(this.model));
        }
        if (this.deleteWhenMoving && this.model.indexOf(rowInterface) >= 0) {
            this.model.removeRow(rowInterface);
        }
    }

    private void dropTransferItem(ItemUiInterface itemUiInterface) {
        RowInterface rowInterface;
        ItemInterface itemInterface = itemUiInterface.getItem();
        if (this.dropTargetRowUi != this.dummyRowUi) {
            rowInterface = this.dropTargetRowUi.getRow();
            if (this.dropTargetItemUi != null && this.dropTargetItemInsert) {
                int n = rowInterface.indexOf(this.dropTargetItemUi.getItem());
                rowInterface.addItem(itemInterface.createCopy(rowInterface), n);
            } else {
                rowInterface.addItem(itemInterface.createCopy(rowInterface));
            }
        } else {
            rowInterface = this.model.createRow();
            rowInterface.addItem(itemInterface.createCopy(rowInterface));
            this.model.addRow(rowInterface);
        }
        if (this.deleteWhenMoving && this.model.indexOf(rowInterface = itemInterface.getRow()) >= 0) {
            rowInterface.removeItem(itemInterface);
        }
    }

    private class DummyRowUi
    extends JComponent
    implements RowUiInterface {
        private static final long serialVersionUID = 1L;
        private DefaultRow dummyRow;

        public DummyRowUi() {
            this.add(Box.createVerticalGlue());
            this.dummyRow = new DefaultRow(RowItemEditor.this.model);
        }

        @Override
        public JComponent getUiComponent() {
            return this;
        }

        @Override
        public RowInterface getRow() {
            return this.dummyRow;
        }

        @Override
        public ItemUiInterface getItemUi(int n) {
            return null;
        }

        @Override
        public int getItemUiIndex(Point point) {
            return 0;
        }

        @Override
        public void addItemUi(ItemUiInterface itemUiInterface, int n) {
        }

        @Override
        public void removeUiItem(int n) {
        }

        @Override
        public void updateIndexDisplay() {
        }
    }
}

