/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.rieditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import javax.swing.border.EmptyBorder;

public class DynamicLineBorder
extends EmptyBorder {
    private static final long serialVersionUID = 1L;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGTH = 4;
    public static final int BOTTOM = 8;
    private Color color;
    private Stroke vLineStroke;
    private Stroke hLineStroke;
    private Line2D line;
    private int borders;
    private int offsetFromLeft;
    private int offsetFromRight;
    private int offsetFromTop;
    private int offsetFromBottom;

    public DynamicLineBorder(Color color, int n, int n2, int n3) {
        this(color, n, n, n2, n3);
    }

    public DynamicLineBorder(Color color, int n, int n2, int n3, int n4) {
        super(n3, n3, n3, n3);
        this.color = color;
        this.borders = n4;
        this.vLineStroke = new BasicStroke(n2, 1, 1);
        this.hLineStroke = new BasicStroke(n, 1, 1);
        this.line = new Line2D.Double();
        this.offsetFromLeft = n2 / 2;
        this.offsetFromRight = n2 - n2 / 2;
        this.offsetFromTop = n / 2;
        this.offsetFromBottom = n - n / 2;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(this.color);
        if ((this.borders & 1) != 0) {
            graphics2D.setStroke(this.vLineStroke);
            this.line.setLine(n + this.offsetFromLeft, n2, n + this.offsetFromLeft, n2 + n4);
            graphics2D.draw(this.line);
        }
        if ((this.borders & 2) != 0) {
            graphics2D.setStroke(this.hLineStroke);
            this.line.setLine(n, n2 + this.offsetFromTop, n + n3, n2 + this.offsetFromTop);
            graphics2D.draw(this.line);
        }
        if ((this.borders & 4) != 0) {
            graphics2D.setStroke(this.vLineStroke);
            this.line.setLine(n + n3 - this.offsetFromRight, n2, n + n3 - this.offsetFromRight, n2 + n4);
            graphics2D.draw(this.line);
        }
        if ((this.borders & 8) != 0) {
            graphics2D.setStroke(this.hLineStroke);
            this.line.setLine(n, n2 + n4 - this.offsetFromBottom, n + n3, n2 + n4 - this.offsetFromBottom);
            graphics2D.draw(this.line);
        }
    }
}

