/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.rieditor;

import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.gui.rieditor.ItemInterface;
import ch.karatojava.util.gui.rieditor.LeftLineBorder;
import ch.karatojava.util.gui.rieditor.RightLineBorder;
import ch.karatojava.util.gui.rieditor.RoundRectBorder;
import ch.karatojava.util.gui.rieditor.RowInterface;
import ch.karatojava.util.gui.rieditor.RowItemEditor;
import ch.karatojava.util.gui.rieditor.RowItemModelInterface;
import ch.karatojava.util.gui.rieditor.RowItemUiFactoryInterface;
import ch.karatojava.util.gui.rieditor.TopLineBorder;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public abstract class AbstractRowItemUiFactory
implements RowItemUiFactoryInterface {
    protected static final String ACTION_REMOVE_ITEM = "removeItem";
    protected static final String ACTION_INSERT_ROW = "insertRow";
    protected static final String ACTION_REMOVE_ROW = "removeRow";
    protected static final String ACTION_COPY_ROW = "copyRow";
    protected static final String ACTION_PASTE_ROW = "pasteRow";
    protected ActionListener addRowListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractRowItemUiFactory.this.editor.getRowItemModel().addRow(AbstractRowItemUiFactory.this.editor.getRowItemModel().createRow());
        }
    };
    private MenuListener menuListener;
    private RowItemEditor editor;
    protected JPopupMenu onItemMenu;
    protected JPopupMenu onRowMenu;
    protected JPopupMenu defaultMenu;
    private JMenuItem defaultMenuPasteItem;
    private JMenuItem rowMenuPasteItem;
    private JMenuItem itemMenuPasteItem;
    private boolean offerRemoveMenuItems;
    private boolean offerInsertMenuItems;
    private RowInterface currentRow;
    private ItemInterface currentItem;
    private Clipboard clipboard;
    private static final Color CURSOR_COLOR = new Color(160, 160, 255);
    private static final Color BORDER_COLOR = new Color(180, 180, 255);
    private static final int ITEM_BORDER_WIDTH = 1;
    private static final Border ITEM_DROP_BORDER = new LeftLineBorder(CURSOR_COLOR, 1, 1);
    private static final Border ITEM_DROP_BORDER_RIGHT = new RightLineBorder(CURSOR_COLOR, 1, 1);
    private static final Border ITEM_EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final int ROW_BORDER_WIDTH = 2;
    private static final int ROW_BORDER_THICKNESS = 1;
    private static final Border ROW_DROP_BORDER = new CompoundBorder(new TopLineBorder(CURSOR_COLOR, 1, 1), new RoundRectBorder(BORDER_COLOR, 1, 2, false));
    private static final Border ROW_EMPTY_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new RoundRectBorder(BORDER_COLOR, 1, 2, false));

    public AbstractRowItemUiFactory() {
        this(null);
    }

    public AbstractRowItemUiFactory(Clipboard clipboard) {
        this(clipboard, true, true);
    }

    public AbstractRowItemUiFactory(Clipboard clipboard, boolean bl, boolean bl2) {
        this.clipboard = clipboard;
        this.offerInsertMenuItems = bl2;
        this.offerRemoveMenuItems = bl;
        this.menuListener = this.createMenuListener();
        this.defaultMenu = this.createDefaultMenu();
        this.onRowMenu = this.createOnRowMenu();
        this.onItemMenu = this.createOnItemMenu();
    }

    protected MenuListener createMenuListener() {
        return new MenuListener();
    }

    @Override
    public void setRowItemEditor(RowItemEditor rowItemEditor) {
        this.editor = rowItemEditor;
    }

    protected JButton createAddRowButton() {
        return new JButton("add new row");
    }

    @Override
    public JComponent createAddRowComponent() {
        JButton jButton = this.createAddRowButton();
        jButton.addActionListener(this.addRowListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    @Override
    public Border getItemEmptyBorder() {
        return ITEM_EMPTY_BORDER;
    }

    @Override
    public Border getItemDropBorder(boolean bl) {
        return bl ? ITEM_DROP_BORDER : ITEM_DROP_BORDER_RIGHT;
    }

    @Override
    public Border getRowEmptyBorder() {
        return ROW_EMPTY_BORDER;
    }

    @Override
    public Border getRowDropBorder() {
        return ROW_DROP_BORDER;
    }

    @Override
    public JPopupMenu getPopupMenu(RowInterface rowInterface, ItemInterface itemInterface) {
        this.currentRow = rowInterface;
        this.currentItem = itemInterface;
        if (this.clipboard != null) {
            if (this.clipboard.getClipboardRow() != null) {
                this.defaultMenuPasteItem.setEnabled(true);
                this.rowMenuPasteItem.setEnabled(true);
                this.itemMenuPasteItem.setEnabled(true);
            } else {
                this.defaultMenuPasteItem.setEnabled(false);
                this.rowMenuPasteItem.setEnabled(false);
                this.itemMenuPasteItem.setEnabled(false);
            }
        }
        if (rowInterface != null) {
            if (itemInterface != null) {
                return this.onItemMenu;
            }
            return this.onRowMenu;
        }
        return this.defaultMenu;
    }

    protected JPopupMenu createDefaultMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.clipboard != null) {
            this.defaultMenuPasteItem = this.createPasteRowMenuItem();
            jPopupMenu.add(this.defaultMenuPasteItem);
        }
        if (this.offerInsertMenuItems) {
            jPopupMenu.add(this.createInsertRowMenuItem());
        }
        return jPopupMenu.getComponentCount() > 0 ? jPopupMenu : null;
    }

    protected JPopupMenu createOnRowMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.clipboard != null) {
            jPopupMenu.add(this.createCopyRowMenuItem());
            this.rowMenuPasteItem = this.createPasteRowMenuItem();
            jPopupMenu.add(this.rowMenuPasteItem);
        }
        if (this.offerInsertMenuItems) {
            jPopupMenu.add(this.createInsertRowMenuItem());
        }
        if (this.offerRemoveMenuItems) {
            jPopupMenu.add(this.createRemoveRowMenuItem());
        }
        return jPopupMenu.getComponentCount() > 0 ? jPopupMenu : null;
    }

    protected JPopupMenu createOnItemMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.offerRemoveMenuItems) {
            jPopupMenu.add(this.createRemoveItemMenuItem());
        }
        if (this.clipboard != null) {
            jPopupMenu.add(this.createCopyRowMenuItem());
            this.itemMenuPasteItem = this.createPasteRowMenuItem();
            jPopupMenu.add(this.itemMenuPasteItem);
        }
        if (this.offerInsertMenuItems) {
            jPopupMenu.add(this.createInsertRowMenuItem());
        }
        if (this.offerRemoveMenuItems) {
            jPopupMenu.add(this.createRemoveRowMenuItem());
        }
        return jPopupMenu.getComponentCount() > 0 ? jPopupMenu : null;
    }

    protected JMenuItem createRemoveItemMenuItemUi() {
        return new JMenuItem("remove this item");
    }

    private JMenuItem createRemoveItemMenuItem() {
        JMenuItem jMenuItem = this.createRemoveItemMenuItemUi();
        jMenuItem.setActionCommand(ACTION_REMOVE_ITEM);
        jMenuItem.addActionListener(this.menuListener);
        return jMenuItem;
    }

    protected JMenuItem createInsertRowMenuItemUi() {
        return new JMenuItem("insert new row");
    }

    private JMenuItem createInsertRowMenuItem() {
        JMenuItem jMenuItem = this.createInsertRowMenuItemUi();
        jMenuItem.setActionCommand(ACTION_INSERT_ROW);
        jMenuItem.addActionListener(this.menuListener);
        return jMenuItem;
    }

    protected JMenuItem createRemoveRowMenuItemUi() {
        return new JMenuItem("remove this row");
    }

    private JMenuItem createRemoveRowMenuItem() {
        JMenuItem jMenuItem = this.createRemoveRowMenuItemUi();
        jMenuItem.setActionCommand(ACTION_REMOVE_ROW);
        jMenuItem.addActionListener(this.menuListener);
        return jMenuItem;
    }

    protected JMenuItem createCopyRowMenuItemUi() {
        return new JMenuItem("copy this row");
    }

    private JMenuItem createCopyRowMenuItem() {
        JMenuItem jMenuItem = this.createCopyRowMenuItemUi();
        jMenuItem.setActionCommand(ACTION_COPY_ROW);
        jMenuItem.addActionListener(this.menuListener);
        return jMenuItem;
    }

    protected JMenuItem createPasteRowMenuItemUi() {
        return new JMenuItem("paste row");
    }

    private JMenuItem createPasteRowMenuItem() {
        JMenuItem jMenuItem = this.createPasteRowMenuItemUi();
        jMenuItem.setActionCommand(ACTION_PASTE_ROW);
        jMenuItem.addActionListener(this.menuListener);
        return jMenuItem;
    }

    protected class MenuListener
    extends ExceptionActionListener {
        public void removeItem(ActionEvent actionEvent) {
            AbstractRowItemUiFactory.this.currentRow.removeItem(AbstractRowItemUiFactory.this.currentItem);
        }

        public void insertRow(ActionEvent actionEvent) {
            RowItemModelInterface rowItemModelInterface = AbstractRowItemUiFactory.this.editor.getRowItemModel();
            if (AbstractRowItemUiFactory.this.currentRow != null) {
                rowItemModelInterface.addRow(rowItemModelInterface.createRow(), rowItemModelInterface.indexOf(AbstractRowItemUiFactory.this.currentRow));
            } else {
                rowItemModelInterface.addRow(rowItemModelInterface.createRow());
            }
        }

        public void removeRow(ActionEvent actionEvent) {
            RowItemModelInterface rowItemModelInterface = AbstractRowItemUiFactory.this.editor.getRowItemModel();
            rowItemModelInterface.removeRow(AbstractRowItemUiFactory.this.currentRow);
        }

        public void copyRow(ActionEvent actionEvent) {
            AbstractRowItemUiFactory.this.clipboard.setClipboardRow(AbstractRowItemUiFactory.this.currentRow.createCopy(AbstractRowItemUiFactory.this.editor.getRowItemModel()));
        }

        public void pasteRow(ActionEvent actionEvent) {
            RowInterface rowInterface = AbstractRowItemUiFactory.this.clipboard.getClipboardRow();
            if (rowInterface != null) {
                RowItemModelInterface rowItemModelInterface = AbstractRowItemUiFactory.this.editor.getRowItemModel();
                if (AbstractRowItemUiFactory.this.currentRow != null) {
                    rowItemModelInterface.addRow(rowInterface.createCopy(rowItemModelInterface), rowItemModelInterface.indexOf(AbstractRowItemUiFactory.this.currentRow));
                } else {
                    rowItemModelInterface.addRow(rowInterface.createCopy(rowItemModelInterface));
                }
            }
        }
    }

    public static class Clipboard {
        private RowInterface clipboardRow;

        public void setClipboardRow(RowInterface rowInterface) {
            this.clipboardRow = rowInterface;
        }

        public RowInterface getClipboardRow() {
            return this.clipboardRow;
        }
    }
}

