/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.jedit;

import ch.karatojava.util.gui.jedit.KeywordMap;
import ch.karatojava.util.gui.jedit.TokenMarker;
import javax.swing.text.Segment;

public class JavaScriptTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords;
    private boolean cpp;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public JavaScriptTokenMarker() {
        this(true, JavaScriptTokenMarker.getKeywords());
    }

    public JavaScriptTokenMarker(boolean bl, KeywordMap keywordMap) {
        this.cpp = bl;
        this.keywords = keywordMap;
    }

    @Override
    public byte markTokensImpl(byte by, Segment segment, int n) {
        int n2;
        char[] cArray = segment.array;
        this.lastOffset = n2 = segment.offset;
        this.lastKeyword = n2;
        int n3 = segment.count + n2;
        boolean bl = false;
        block21: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            if (!this.cpp) continue block21;
                            if (this.doKeyword(segment, i, c)) break;
                            this.addToken(i - this.lastOffset, by);
                            this.addToken(n3 - i, (byte)7);
                            this.lastOffset = this.lastKeyword = n3;
                            break block21;
                        }
                        case '\"': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == n2) {
                                if (this.doKeyword(segment, i, c)) break;
                                bl = false;
                                this.addToken(n4 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            if (!this.doKeyword(segment, i, c)) continue block21;
                            break;
                        }
                        case '/': {
                            bl = false;
                            this.doKeyword(segment, i, c);
                            if (n3 - i <= 1) continue block21;
                            switch (cArray[n4]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (n3 - i > 2 && cArray[i + 2] == '*') {
                                        by = (byte)2;
                                        break;
                                    }
                                    by = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.addToken(n3 - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = n3;
                                    break block21;
                                }
                            }
                            continue block21;
                        }
                        default: {
                            bl = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block21;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: 
                case 2: {
                    bl = false;
                    if (c != '*' || n3 - i <= 1 || cArray[n4] != '/') continue block21;
                    this.addToken(++i + 1 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block21;
                    }
                    if (c != '\"') continue block21;
                    this.addToken(n4 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block21;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block21;
                    }
                    if (c != '\'') continue block21;
                    this.addToken(n4 - this.lastOffset, (byte)3);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        if (by == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (by) {
            case 3: 
            case 4: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                by = 0;
                break;
            }
            case 7: {
                this.addToken(n3 - this.lastOffset, by);
                if (!bl) {
                    by = 0;
                }
            }
            default: {
                this.addToken(n3 - this.lastOffset, by);
            }
        }
        return by;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            cKeywords.add("abstract", (byte)6);
            cKeywords.add("boolean", (byte)8);
            cKeywords.add("break", (byte)6);
            cKeywords.add("byte", (byte)8);
            cKeywords.add("case", (byte)6);
            cKeywords.add("catch", (byte)6);
            cKeywords.add("char", (byte)8);
            cKeywords.add("class", (byte)6);
            cKeywords.add("const", (byte)6);
            cKeywords.add("continue", (byte)6);
            cKeywords.add("debugger", (byte)6);
            cKeywords.add("default", (byte)6);
            cKeywords.add("delete", (byte)6);
            cKeywords.add("do", (byte)6);
            cKeywords.add("double", (byte)8);
            cKeywords.add("else", (byte)6);
            cKeywords.add("enum", (byte)8);
            cKeywords.add("export", (byte)6);
            cKeywords.add("extends", (byte)6);
            cKeywords.add("false", (byte)8);
            cKeywords.add("final", (byte)6);
            cKeywords.add("finally", (byte)6);
            cKeywords.add("float", (byte)8);
            cKeywords.add("for", (byte)6);
            cKeywords.add("function", (byte)6);
            cKeywords.add("goto", (byte)6);
            cKeywords.add("if", (byte)6);
            cKeywords.add("implements", (byte)6);
            cKeywords.add("import", (byte)6);
            cKeywords.add("in", (byte)6);
            cKeywords.add("instanceof", (byte)6);
            cKeywords.add("int", (byte)6);
            cKeywords.add("interface", (byte)6);
            cKeywords.add("long", (byte)8);
            cKeywords.add("native", (byte)6);
            cKeywords.add("new", (byte)6);
            cKeywords.add("null", (byte)8);
            cKeywords.add("package", (byte)6);
            cKeywords.add("private", (byte)6);
            cKeywords.add("protected", (byte)6);
            cKeywords.add("public", (byte)6);
            cKeywords.add("return", (byte)6);
            cKeywords.add("short", (byte)8);
            cKeywords.add("static", (byte)6);
            cKeywords.add("super", (byte)6);
            cKeywords.add("switch", (byte)6);
            cKeywords.add("synchronized", (byte)6);
            cKeywords.add("this", (byte)6);
            cKeywords.add("throw", (byte)6);
            cKeywords.add("throws", (byte)6);
            cKeywords.add("transient", (byte)6);
            cKeywords.add("true", (byte)8);
            cKeywords.add("try", (byte)6);
            cKeywords.add("typeof", (byte)6);
            cKeywords.add("var", (byte)6);
            cKeywords.add("void", (byte)6);
            cKeywords.add("volatile", (byte)6);
            cKeywords.add("while", (byte)6);
            cKeywords.add("with", (byte)6);
        }
        return cKeywords;
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
        return false;
    }
}

