/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.event.MouseInputAdapter;

public class ImageMapLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    protected Rectangle[] imageMapCoordinates;
    protected Hashtable<Rectangle, String> imageMapStrings;
    protected Cursor defaultCursor;
    protected Cursor handCursor;
    protected Icon icon;
    protected MouseInputAdapter mouseListener = new MouseInputAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - (ImageMapLabel.this.getWidth() - ImageMapLabel.this.icon.getIconWidth()) / 2;
            int n2 = mouseEvent.getY() - (ImageMapLabel.this.getHeight() - ImageMapLabel.this.icon.getIconHeight()) / 2;
            boolean bl = false;
            for (int i = 0; i < ImageMapLabel.this.imageMapCoordinates.length && !bl; ++i) {
                bl = ImageMapLabel.this.imageMapCoordinates[i].contains(n, n2);
            }
            if (bl) {
                ImageMapLabel.this.setCursor(ImageMapLabel.this.handCursor);
            } else {
                ImageMapLabel.this.setCursor(ImageMapLabel.this.defaultCursor);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ImageMapLabel.this.setCursor(ImageMapLabel.this.defaultCursor);
        }
    };

    public ImageMapLabel(Icon icon) {
        super(icon);
        this.icon = icon;
        this.imageMapCoordinates = new Rectangle[0];
        this.imageMapStrings = new Hashtable();
        this.defaultCursor = Cursor.getPredefinedCursor(0);
        this.handCursor = Cursor.getPredefinedCursor(12);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
    }

    public void addArea(Rectangle rectangle, String string) {
        rectangle = new Rectangle(rectangle);
        this.imageMapStrings.put(rectangle, string);
        Rectangle[] rectangleArray = new Rectangle[this.imageMapCoordinates.length + 1];
        System.arraycopy(this.imageMapCoordinates, 0, rectangleArray, 0, this.imageMapCoordinates.length);
        rectangleArray[this.imageMapCoordinates.length] = rectangle;
        this.imageMapCoordinates = rectangleArray;
    }

    public String getAreaName(int n, int n2) {
        n -= (this.getWidth() - this.icon.getIconWidth()) / 2;
        n2 -= (this.getHeight() - this.icon.getIconHeight()) / 2;
        Rectangle rectangle = null;
        for (int i = 0; i < this.imageMapCoordinates.length && rectangle == null; ++i) {
            if (!this.imageMapCoordinates[i].contains(n, n2)) continue;
            rectangle = this.imageMapCoordinates[i];
        }
        return rectangle != null ? this.imageMapStrings.get(rectangle) : null;
    }
}

