/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui;

import ch.karatojava.util.Configuration;
import ch.karatojava.util.gui.MyHTMLEditorKit;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;

    public HTMLEditorPane() {
        super("text/html", "<html><body></body></html>");
        this.addHyperlinkListener(new Hyperactive());
        this.setEditable(false);
        this.setEditorKit(new MyHTMLEditorKit());
    }

    public HTMLEditorPane(String string) {
        this();
        this.showFile(string);
    }

    public void showFile(String string) {
        try {
            this.setPage(HTMLEditorPane.class.getResource(Configuration.getInstance().getString(string)));
        }
        catch (IOException iOException) {
            throw new RuntimeException("HTMLEditorPane.HTMLEditorPane: Could not find html file: " + Configuration.getInstance().getString(string));
        }
    }

    protected class Hyperactive
    implements HyperlinkListener {
        protected Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        jEditorPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException("HTMLEditorPane.Hyperactive.hyperlinkUpdate: Could not follow link: " + throwable.getMessage());
                    }
                }
            }
        }
    }
}

