/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util;

import ch.karatojava.util.Configuration;
import ch.karatojava.util.ResourceAccessInterface;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XmlResourceAccess
implements ResourceAccessInterface {
    private Class resourceClass;
    private Element properties;

    public XmlResourceAccess(String string, Class clazz) {
        assert (string != null) : "XmlResourceAccess.constructor: configFileName == null";
        assert (clazz != null) : "XmlResourceAccess.constructor: resourceClass == null";
        this.resourceClass = clazz;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setXIncludeAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new RelativeResolver());
            Document document = documentBuilder.parse(clazz.getResourceAsStream(string));
            this.properties = document.getDocumentElement();
        }
        catch (Exception exception) {
            System.out.println("XmlResourceAccess.constructor: could not read config file\n can not execute without - exiting." + exception);
            exception.printStackTrace(System.out);
            System.exit(-1);
        }
    }

    @Override
    public String getString(String string) {
        assert (string != null) : "XmlResourceAccess.getString: key == null";
        List<String> list = Configuration.split(string, "/");
        Element element = this.properties;
        int n = list.size();
        block0: for (int i = 0; i < n && element != null; ++i) {
            NodeList nodeList = element.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                if (!list.get(i).equals(nodeList.item(j).getNodeName())) continue;
                element = (Element)nodeList.item(j);
                continue block0;
            }
        }
        if (element != null) {
            if (element.getFirstChild() != null && element.getFirstChild().getNodeType() == 4) {
                return element.getTextContent();
            }
            return this.trimLeadingSpaces(element.getTextContent());
        }
        throw new RuntimeException("XmlResourceAccess.getString: key not found, key == " + string);
    }

    @Override
    public URL getResource(String string) {
        assert (string != null) : "XmlResourceAccess.getResource: key == null";
        return this.resourceClass.getResource(string);
    }

    private String trimLeadingSpaces(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        StringBuffer stringBuffer = new StringBuffer();
        if (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken().trim());
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("\n");
                stringBuffer.append(stringTokenizer.nextToken().trim());
            }
        }
        return stringBuffer.toString();
    }

    public class RelativeResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String string, String string2) {
            String string3 = string2.substring(string2.lastIndexOf("/"));
            string3 = "/kappsresources" + string3;
            InputSource inputSource = new InputSource(XmlResourceAccess.class.getResourceAsStream(string3));
            inputSource.setSystemId(string3);
            return inputSource;
        }
    }
}

