/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Hashtable;

public class WeakRefPropertyChangeSupport {
    private transient ArrayList<WeakReference> listeners;
    private Hashtable<String, WeakRefPropertyChangeSupport> children;
    private Object source;

    public WeakRefPropertyChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WeakReference weakReference;
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        WeakReference weakReference2 = weakReference = new WeakReference(propertyChangeListener);
        this.listeners.add(weakReference2);
        int n = 0;
        while (n < this.listeners.size()) {
            weakReference2 = this.listeners.get(n);
            PropertyChangeListener propertyChangeListener2 = (PropertyChangeListener)weakReference2.get();
            if (propertyChangeListener2 == null) {
                this.listeners.remove(weakReference2);
                weakReference2 = null;
                continue;
            }
            ++n;
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            WeakReference weakReference = this.listeners.get(n);
            PropertyChangeListener propertyChangeListener2 = (PropertyChangeListener)weakReference.get();
            if (propertyChangeListener2 == null) {
                this.listeners.remove(weakReference);
                continue;
            }
            if (propertyChangeListener2 == propertyChangeListener) {
                this.listeners.remove(weakReference);
            }
            ++n;
        }
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        WeakRefPropertyChangeSupport weakRefPropertyChangeSupport;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((weakRefPropertyChangeSupport = this.children.get(string)) == null) {
            weakRefPropertyChangeSupport = new WeakRefPropertyChangeSupport(this.source);
            this.children.put(string, weakRefPropertyChangeSupport);
        }
        weakRefPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.children == null) {
            return;
        }
        WeakRefPropertyChangeSupport weakRefPropertyChangeSupport = this.children.get(string);
        if (weakRefPropertyChangeSupport == null) {
            return;
        }
        weakRefPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        ArrayList arrayList = null;
        WeakRefPropertyChangeSupport weakRefPropertyChangeSupport = null;
        Object object3 = this;
        synchronized (object3) {
            if (this.listeners != null) {
                arrayList = (ArrayList)this.listeners.clone();
            }
            if (this.children != null && string != null) {
                weakRefPropertyChangeSupport = this.children.get(string);
            }
        }
        object3 = new PropertyChangeEvent(this.source, string, object, object2);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                WeakReference weakReference = (WeakReference)arrayList.get(i);
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)weakReference.get();
                if (propertyChangeListener == null) continue;
                propertyChangeListener.propertyChange((PropertyChangeEvent)object3);
            }
        }
        if (weakRefPropertyChangeSupport != null) {
            weakRefPropertyChangeSupport.firePropertyChange((PropertyChangeEvent)object3);
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (n == n2) {
            return;
        }
        this.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl == bl2) {
            return;
        }
        this.firePropertyChange(string, new Boolean(bl), new Boolean(bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        ArrayList arrayList = null;
        WeakRefPropertyChangeSupport weakRefPropertyChangeSupport = null;
        WeakRefPropertyChangeSupport weakRefPropertyChangeSupport2 = this;
        synchronized (weakRefPropertyChangeSupport2) {
            if (this.listeners != null) {
                arrayList = (ArrayList)this.listeners.clone();
            }
            if (this.children != null && string != null) {
                weakRefPropertyChangeSupport = this.children.get(string);
            }
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                WeakReference weakReference = (WeakReference)arrayList.get(i);
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)weakReference.get();
                if (propertyChangeListener == null) continue;
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
        if (weakRefPropertyChangeSupport != null) {
            weakRefPropertyChangeSupport.firePropertyChange(propertyChangeEvent);
        }
    }

    public synchronized boolean hasListeners(String string) {
        WeakRefPropertyChangeSupport weakRefPropertyChangeSupport;
        if (this.listeners != null) {
            int n = 0;
            while (n < this.listeners.size()) {
                WeakReference weakReference = this.listeners.get(n);
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)weakReference.get();
                if (propertyChangeListener == null) {
                    this.listeners.remove(weakReference);
                    continue;
                }
                ++n;
            }
            return !this.listeners.isEmpty();
        }
        if (this.children != null && (weakRefPropertyChangeSupport = this.children.get(string)) != null && weakRefPropertyChangeSupport.listeners != null) {
            return !weakRefPropertyChangeSupport.listeners.isEmpty();
        }
        return false;
    }
}

