/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util;

import ch.karatojava.util.Configuration;
import ch.karatojava.util.gui.UISwitchListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class GuiFactory {
    public static final Insets BUTTON_MARGIN = new Insets(4, 4, 4, 4);
    private static final String LOOK_AND_FEEL_PROPERTY = "lookAndFeel";
    private WeakHashMap<Component, UISwitchListener> weakUiSwitchListeners;
    public static final MouseAdapter ROLLOVER_LISTENER = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ((AbstractButton)mouseEvent.getSource()).setBorderPainted(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ((AbstractButton)mouseEvent.getSource()).setBorderPainted(false);
        }
    };
    private static final String MENU_TEXT = "/text";
    private static final String ACTION_COMMAND = "/action";
    private static final String MENU_ICON = "/icon";
    private static final String MENU_ITEMS = "/items";
    protected static GuiFactory instance;
    private Configuration configuration;
    private PropertyChangeListener uiSwitchListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(GuiFactory.LOOK_AND_FEEL_PROPERTY)) {
                String string2 = Configuration.getInstance().getCurrentValue(GuiFactory.LOOK_AND_FEEL_PROPERTY);
                if (string2.equals("dummy1")) {
                    GuiFactory.this.configuration.setCurrentValue(GuiFactory.LOOK_AND_FEEL_PROPERTY, "dummy2");
                } else {
                    GuiFactory.this.configuration.setCurrentValue(GuiFactory.LOOK_AND_FEEL_PROPERTY, "dummy1");
                }
            }
        }
    };

    protected GuiFactory() {
        this.configuration = Configuration.getInstance();
        this.weakUiSwitchListeners = new WeakHashMap();
        UIManager.addPropertyChangeListener(this.uiSwitchListener);
    }

    public void addUiSwitchListener(Component component) {
        UISwitchListener uISwitchListener = new UISwitchListener(component);
        this.configuration.addPropertyChangeListener(uISwitchListener, false);
        this.weakUiSwitchListeners.put(component, uISwitchListener);
    }

    public TitledBorder createTitledBorder(String string) {
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor"), 1));
        if (string != null) {
            titledBorder.setTitle(this.configuration.getString(string));
        }
        return titledBorder;
    }

    public ImageIcon createImageIcon(String string) {
        ImageIcon imageIcon = new ImageIcon(this.configuration.getImage(string));
        return imageIcon;
    }

    public void createButtonUI(AbstractButton abstractButton) {
        this.createButtonUI(abstractButton, 4, 4, 4, 4, false);
    }

    public void createButtonUI(AbstractButton abstractButton, int n, int n2, int n3, int n4, boolean bl) {
        abstractButton.setBorderPainted(false);
        abstractButton.addMouseListener(ROLLOVER_LISTENER);
        abstractButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4), BorderFactory.createLineBorder(new Color(230, 230, 230), 1)));
        abstractButton.setFocusPainted(bl);
    }

    public JButton createImageIconButton(String string) {
        JButton jButton = new JButton(this.createImageIcon(string));
        this.createButtonUI(jButton);
        return jButton;
    }

    public JButton createImageIconButton(String string, String string2) {
        JButton jButton = new JButton(this.createImageIcon(string));
        jButton.setToolTipText(this.configuration.getString(string2));
        this.createButtonUI(jButton);
        return jButton;
    }

    public JToggleButton createImageIconToggleButton(String string) {
        JToggleButton jToggleButton = new JToggleButton(this.createImageIcon(string));
        this.createButtonUI(jToggleButton);
        return jToggleButton;
    }

    public JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(this.configuration.getString(string));
        return jLabel;
    }

    private void addListenersToMenuItem(JMenuItem jMenuItem, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            jMenuItem.setText(this.configuration.getString(string2));
        }
        if (string != null && !string.equals("")) {
            jMenuItem.setIcon(this.configuration.getImageIcon(string));
        }
    }

    public JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem();
        this.addListenersToMenuItem(jMenuItem, string, string2);
        return jMenuItem;
    }

    public JCheckBoxMenuItem createCheckBoxMenuItem(String string, String string2) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.addListenersToMenuItem(jCheckBoxMenuItem, string, string2);
        return jCheckBoxMenuItem;
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem(String string, String string2) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.addListenersToMenuItem(jRadioButtonMenuItem, string, string2);
        return jRadioButtonMenuItem;
    }

    public JMenu createMenu(String string, String string2) {
        JMenu jMenu = new JMenu();
        this.addListenersToMenuItem(jMenu, string, string2);
        return jMenu;
    }

    private JMenu createMenu(String string) {
        String string2 = this.configuration.getString(string + MENU_TEXT);
        String string3 = this.configuration.getString(string + MENU_ICON);
        return this.createMenu(string3, string2);
    }

    private void initializeMenu(String string, JPopupMenu jPopupMenu, JMenu jMenu, ActionListener actionListener) {
        String string2 = this.configuration.getString(string + MENU_ITEMS);
        List<String> list = Configuration.split(string2, ",");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem;
            String string3;
            String string4 = list.get(i);
            String string5 = this.configuration.getString(string + "/" + string4 + MENU_TEXT);
            String string6 = this.configuration.getString(string + "/" + string4 + MENU_ICON);
            String string7 = this.configuration.getString(string + "/" + string4 + MENU_ITEMS);
            if (string7.equals("")) {
                string3 = this.configuration.getString(string + "/" + string4 + ACTION_COMMAND);
                jMenuItem = this.createMenuItem(string6, string5);
                jMenuItem.setActionCommand(string3);
                jMenuItem.addActionListener(actionListener);
                if (jMenu != null) {
                    jMenu.add(jMenuItem);
                    continue;
                }
                jPopupMenu.add(jMenuItem);
                continue;
            }
            string3 = string + "/" + string4;
            jMenuItem = this.createMenu(string3);
            this.initializeMenu(string3, null, (JMenu)jMenuItem, actionListener);
            if (jMenu != null) {
                jMenu.add(jMenuItem);
                continue;
            }
            jPopupMenu.add(jMenuItem);
        }
    }

    public JPopupMenu createPopupMenu(String string, ActionListener actionListener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.initializeMenu(string, jPopupMenu, null, actionListener);
        UIManager.addPropertyChangeListener(new UISwitchListener(jPopupMenu));
        return jPopupMenu;
    }

    public JFrame createFrame(String string) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle(this.configuration.getString(string));
        UIManager.addPropertyChangeListener(new UISwitchListener(jFrame.getRootPane()));
        return jFrame;
    }

    public static GuiFactory getInstance() {
        assert (instance != null) : "GuiFactory.getInstance: instance == null";
        return instance;
    }

    public static boolean instanceCreated() {
        return instance != null;
    }

    public static void createInstance() {
        if (instance == null) {
            instance = new GuiFactory();
        }
    }
}

