/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util;

import ch.karatojava.util.ExceptionIconHolderInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ExceptionActionListener
implements ActionListener {
    public static boolean DEBUG = false;
    private static final Color ERROR_COLOR = new Color(230, 200, 200);
    private static Class[] NO_PARAMETERS = new Class[0];
    private static Object[] NO_ARGUMENTS = new Object[0];
    private static Class[] ACTION_EVENT_PARAMETER = new Class[]{ActionEvent.class};
    private Object object;
    private String actionMethod;

    public ExceptionActionListener(Object object, String string) {
        assert (object != null) : "ExceptionActionListener.constructor: object == null";
        assert (string != null) : "ExceptionActionListener.constructor: actionMethod == null";
        this.actionMethod = string;
        this.object = object;
    }

    public ExceptionActionListener() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.object != null && this.actionMethod != null) {
                Method method = this.object.getClass().getMethod(this.actionMethod, NO_PARAMETERS);
                method.invoke(this.object, NO_ARGUMENTS);
            } else {
                this.action(actionEvent);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(actionEvent, invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            this.handleException(actionEvent, exception);
        }
    }

    public void action(ActionEvent actionEvent) throws Exception {
        Method method = this.getClass().getMethod(actionEvent.getActionCommand(), ACTION_EVENT_PARAMETER);
        method.invoke((Object)this, actionEvent);
    }

    protected void handleException(ActionEvent actionEvent, Throwable throwable) {
        if (DEBUG) {
            throwable.printStackTrace();
        }
        ExceptionActionListener.reportException((Component)actionEvent.getSource(), "", throwable);
    }

    private static String getMessage(Throwable throwable) {
        if (DEBUG) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            return throwable.getMessage() + "\n\n" + stringWriter.toString();
        }
        return throwable.getMessage();
    }

    public static synchronized void reportException(Component component, String string, Throwable throwable) {
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setMessage(throwable.getMessage());
        if (throwable instanceof ExceptionIconHolderInterface) {
            jOptionPane.setIcon(((ExceptionIconHolderInterface)((Object)throwable)).getExceptionIcon());
        }
        final JDialog jDialog = jOptionPane.createDialog(JOptionPane.getFrameForComponent(component), string);
        if (!DEBUG) {
            jDialog.setTitle("");
        } else {
            try {
                throw new RuntimeException();
            }
            catch (RuntimeException runtimeException) {
                System.out.println(ExceptionActionListener.getMessage(throwable));
                runtimeException.printStackTrace();
            }
        }
        ExceptionActionListener.makeTransparent(jDialog.getContentPane());
        jDialog.getContentPane().setBackground(ERROR_COLOR);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jDialog.setVisible(true);
            }
        });
    }

    private static void makeTransparent(Container container) {
        if (container instanceof JComponent) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof JComponent)) continue;
                ((JComponent)componentArray[i]).setOpaque(false);
                ExceptionActionListener.makeTransparent((JComponent)componentArray[i]);
            }
        }
    }
}

