/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util;

public class CyclicBarrier {
    protected final int nParticipants;
    protected int count;
    protected int resets;
    protected String processNames = "";

    public CyclicBarrier(int n) {
        this.nParticipants = n;
        this.count = n;
        this.resets = 0;
    }

    public synchronized int sleeping() {
        return this.nParticipants - this.count;
    }

    public synchronized void waitBarrier(String string) throws InterruptedException {
        --this.count;
        this.processNames = this.processNames + " " + string;
        if (this.count > 0) {
            int n = this.resets;
            do {
                this.wait();
            } while (n == this.resets);
        } else {
            this.count = this.nParticipants;
            ++this.resets;
            this.notifyAll();
            this.processNames = "";
        }
    }

    public synchronized void waitBarrierIgnoreInterrupt(String string) {
        try {
            this.waitBarrier(string);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

