/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world.editor;

import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class WorldViewToolbar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private WorldEditor worldEditor;

    public WorldViewToolbar(WorldEditor worldEditor) {
        assert (worldEditor != null);
        this.worldEditor = worldEditor;
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/worldperspective"));
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.worldEditor.getWorldView().isKarasPerspectivePossible()) {
            this.worldEditor.getWorldView().setKarasPerspectiveEnabled(true);
            JToggleButton jToggleButton = new JToggleButton(Configuration.getInstance().getImageIcon("icons/worldview_kara"));
            jToggleButton.setToolTipText(Configuration.getInstance().getString("language/$language/worldperspective_kara"));
            jToggleButton.setBorder(BorderFactory.createEmptyBorder(GuiFactory.BUTTON_MARGIN.top, GuiFactory.BUTTON_MARGIN.left, GuiFactory.BUTTON_MARGIN.bottom, GuiFactory.BUTTON_MARGIN.right));
            jToggleButton.addActionListener(new PerspectiveActionListener(true));
            this.add(jToggleButton);
            buttonGroup.add(jToggleButton);
            jToggleButton.setSelected(true);
            JToggleButton jToggleButton2 = new JToggleButton(Configuration.getInstance().getImageIcon("icons/worldview_global"));
            jToggleButton2.setToolTipText(Configuration.getInstance().getString("language/$language/worldperspective_global"));
            jToggleButton2.setBorder(BorderFactory.createEmptyBorder(GuiFactory.BUTTON_MARGIN.top, GuiFactory.BUTTON_MARGIN.left, GuiFactory.BUTTON_MARGIN.bottom, GuiFactory.BUTTON_MARGIN.right));
            jToggleButton2.addActionListener(new PerspectiveActionListener(false));
            this.add(jToggleButton2);
            buttonGroup.add(jToggleButton2);
        }
    }

    protected class PerspectiveActionListener
    implements ActionListener {
        private boolean karasPerspective;

        public PerspectiveActionListener(boolean bl) {
            this.karasPerspective = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WorldViewToolbar.this.worldEditor.getWorldView().setKarasPerspectiveEnabled(this.karasPerspective);
            WorldViewToolbar.this.worldEditor.getWorldView().repaint();
        }
    }
}

