/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world.editor;

import ch.karatojava.kapps.Konfig;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldField;
import ch.karatojava.kapps.world.WorldListener;
import ch.karatojava.kapps.world.WorldListenerAdapter;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.util.gui.dndpanel.DndPanel;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class WorldView
extends JComponent
implements LightweightDragDrop {
    private static final long serialVersionUID = 1L;
    public static final AlphaComposite ALPHA_OBJECT_NOT_VISIBLE_TO_KARA = AlphaComposite.getInstance(3, 0.3f);
    public static final AlphaComposite ALPHA_VISIBLE_TO_KARA = AlphaComposite.getInstance(10);
    public static final Color WORLD_GRID_COLOR = new Color(170, 170, 170);
    protected World world;
    protected Kara kara;
    protected Image[] scaledWorldImages;
    protected int[][] streetPositions;
    protected int imageSize;
    protected int status = 30;
    protected boolean enableDragDrop = true;
    protected boolean enableMoveWorld = true;
    protected double maxScale = 5.0;
    protected double minScale = 0.08;
    protected double zoom = 1.0;
    protected static final int JUST_LOOKING = 30;
    protected static final int ZOOM = 1;
    protected static final int TRANS = 2;
    protected static final int INDEX_BACKGROUND = 0;
    protected static final int INDEX_TREE = 1;
    protected static final int INDEX_LEAF = 2;
    protected static final int INDEX_MUSHROOM = 3;
    protected static final int INDEX_KARA = 4;
    protected static final int[] TYPE_INDICES = new int[]{0, 1, 2, -1, 3, -1, -1, -1, 4};
    protected Point dragOrigin = new Point(-1, -1);
    protected int worldImageSizeX;
    protected int worldImageSizeY;
    protected int offsetX;
    protected int offsetY;
    protected int distX = 0;
    protected int distY = 0;
    protected Point eventStart;
    protected double dScaleDist = 150.0;
    public boolean drawWorld = true;
    public static final String KARA_PUT_PROPERTY = "kara put";
    public static final String KARA_REMOVED_PROPERTY = "kara removed";
    protected ImageIcon dragIcon;
    protected WorldObjectInterface dragObject;
    protected ArrayList fieldsToRedraw = new ArrayList();
    protected boolean redrawAll = true;
    protected boolean karasPerspectivePossible;
    protected boolean karasPerspectiveEnabled = true;
    protected List<WorldObjectViewInformation> worldObjectViewInfos;
    protected MouseInputListener moveNzoomHandler = new MouseInputAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if ((n & 8) > 0 || (n & 0x10) > 0 && (n & 8) > 0) {
                WorldView.this.status = 1;
                WorldView.this.setCursor(8);
                WorldView.this.eventStart = mouseEvent.getPoint();
            } else if ((n & 0x10) > 0) {
                WorldView.this.status = 2;
                if (WorldView.this.enableMoveWorld && WorldView.this.allowMove()) {
                    WorldView.this.setCursor(13);
                }
                WorldView.this.eventStart = mouseEvent.getPoint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (WorldView.this.status == 1) {
                WorldView.this.changeZoom(mouseEvent.getY());
            } else if (WorldView.this.status == 2) {
                WorldView.this.changeVisiblePart(mouseEvent.getPoint());
            }
            WorldView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            WorldView.this.status = 30;
            WorldView.this.setNormalCursor();
        }
    };
    protected ComponentListener compListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            WorldView.this.resetWorldImageSize();
            WorldView.this.calculateOffsets();
            WorldView.this.repaint();
        }
    };
    protected WorldListener worldListener = new WorldListenerAdapter(){

        @Override
        public void worldObjectAdded(WorldObjectInterface worldObjectInterface, int n, int n2) {
            WorldView.this.demandRepaint();
        }

        @Override
        public void worldObjectMoved(WorldObjectInterface worldObjectInterface, int n, int n2, int n3, int n4) {
            if (WorldView.this.dragOrigin != null && WorldView.this.dragOrigin.x == n && WorldView.this.dragOrigin.y == n2 && !WorldView.this.world.isObjectOfTypeAt(WorldView.this.dragObject, n, n2)) {
                DndPanel.findDndPanel(WorldView.this).abortDragging();
            }
            WorldView.this.demandRepaint();
        }

        @Override
        public void worldObjectRemoved(WorldObjectInterface worldObjectInterface, int n, int n2) {
            WorldView.this.demandRepaint();
        }

        @Override
        public void worldObjectChanged(WorldObjectInterface worldObjectInterface) {
            WorldView.this.demandRepaint();
        }

        @Override
        public void worldChanged(Object object) {
            WorldView.this.demandRepaint();
        }

        @Override
        public void worldCleared() {
            WorldView.this.demandRepaint();
        }

        @Override
        public void worldSizeSet(int n, int n2) {
            WorldView.this.resetWorldImageSize();
            WorldView.this.calculateOffsets();
            WorldView.this.demandRepaint();
        }
    };

    public WorldView(World world) {
        this.updateImages();
        this.setWorld(world);
        this.addMouseListener(this.moveNzoomHandler);
        this.addMouseMotionListener(this.moveNzoomHandler);
        this.addComponentListener(this.compListener);
    }

    public final synchronized void setWorld(World world) {
        this.world = world;
        if (!this.world.getListeners().contains(this.worldListener)) {
            this.world.addWorldListener(this.worldListener);
        }
        this.updateObjectPositions();
        this.distX = 0;
        this.distY = 0;
        this.setZoomFactor(this.getZoomFactor());
        this.firePropertyChange(KARA_PUT_PROPERTY, new String(""), null);
    }

    public void setZoomFactor(double d) {
        if (d < this.minScale) {
            d = this.minScale;
        } else if (d > this.maxScale) {
            d = this.maxScale;
        }
        this.zoom = d;
        this.resetImageSizes();
        this.resetWorldImageSize();
        this.calculateOffsets();
        this.repaint();
    }

    public Point getDistances() {
        return new Point(this.distX, this.distY);
    }

    public void setDistances(Point point) {
        this.distX = point.x;
        this.distY = point.y;
    }

    public void setZoomFitSize() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            double d;
            double d2 = (double)this.getWidth() / (double)(28 * this.world.getSizeX() + 10);
            if (d2 < (d = (double)this.getHeight() / (double)(28 * this.world.getSizeY() + 10))) {
                this.setZoomFactor(d2);
            } else {
                this.setZoomFactor(d);
            }
        }
    }

    public boolean doesWorldFitSize() {
        double d = (double)this.getWidth() / (double)(28 * this.world.getSizeX() + 10);
        double d2 = (double)this.getHeight() / (double)(28 * this.world.getSizeY() + 10);
        return d >= 1.0 && d2 >= 1.0;
    }

    public void setEnabledDragDrop(boolean bl) {
        if (this.enableDragDrop != bl) {
            this.enableDragDrop = bl;
            DndPanel dndPanel = DndPanel.findDndPanel(this);
            if (bl) {
                dndPanel.addThisMouseInputListener(this);
            } else {
                dndPanel.removeThisMouseInputListener(this);
            }
        }
    }

    public void setEnabledMoveWorld(boolean bl) {
        if (this.enableMoveWorld != bl) {
            this.removeMouseListener(this.moveNzoomHandler);
            this.removeMouseMotionListener(this.moveNzoomHandler);
            this.setNormalCursor();
            if (bl) {
                this.addMouseListener(this.moveNzoomHandler);
                this.addMouseMotionListener(this.moveNzoomHandler);
            }
            this.enableMoveWorld = bl;
        }
    }

    public final World getWorld() {
        return this.world;
    }

    public double getZoomFactor() {
        return this.zoom;
    }

    public Point getFieldPos(int n, int n2) {
        if ((n -= this.offsetX) <= 0 || (n2 -= this.offsetY) <= 0 || n >= this.worldImageSizeX - 1 || n2 >= this.worldImageSizeY - 1) {
            return null;
        }
        int n3 = n / this.imageSize;
        int n4 = n2 / this.imageSize;
        return new Point(n3, n4);
    }

    public boolean getEnabledDragDrop() {
        return this.enableDragDrop;
    }

    public Point getDragOrigin() {
        return this.dragOrigin.x >= 0 ? new Point(this.dragOrigin) : null;
    }

    protected void updateImages() {
        this.resetImageSizes();
    }

    protected void resetImageSizes() {
        this.imageSize = (int)(28.0 * this.zoom);
        this.setupWorldImages();
    }

    protected void setupWorldImages() {
        ImageIcon[] imageIconArray = Konfig.getWorldImages();
        this.scaledWorldImages = new Image[imageIconArray.length];
        for (int i = 0; i < imageIconArray.length; ++i) {
            this.scaledWorldImages[i] = this.getResizedImage(imageIconArray[i].getImage());
        }
    }

    protected BufferedImage getResizedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(this.imageSize, this.imageSize, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(this.zoom, this.zoom);
        graphics2D.drawImage(image, 0, 0, this);
        return bufferedImage;
    }

    @Override
    public void repaint() {
        if (this.dragOrigin.x >= 0) {
            DndPanel.findDndPanel(this).repaint();
        } else {
            super.repaint();
        }
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        this.drawWorld = false;
        this.paintGrid(graphics);
        this.paintWorldImages(graphics);
        this.drawWorld = true;
    }

    protected void demandRepaint() {
        this.updateObjectPositions();
        if (this.drawWorld) {
            this.drawWorld = false;
            this.repaint();
        }
    }

    public BufferedImage getExportImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth() + 10, this.getHeight() + 10);
        this.paint(bufferedImage.getGraphics());
        return bufferedImage;
    }

    protected boolean isVisibleToActor(WorldObjectInterface worldObjectInterface, int n, int n2) {
        return worldObjectInterface == this.kara || this.kara != null && this.kara.isVisibleToKara(n, n2);
    }

    protected void paintWorldImages(Graphics graphics) {
        if (this.karasPerspectivePossible && this.karasPerspectiveEnabled) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            for (WorldObjectViewInformation worldObjectViewInformation : this.worldObjectViewInfos) {
                graphics2D.setComposite(worldObjectViewInformation.visibleToKara ? ALPHA_VISIBLE_TO_KARA : ALPHA_OBJECT_NOT_VISIBLE_TO_KARA);
                graphics.drawImage(this.scaledWorldImages[worldObjectViewInformation.guiid], this.offsetX + worldObjectViewInformation.x * this.imageSize, this.offsetY + worldObjectViewInformation.y * this.imageSize, null);
            }
        } else {
            for (WorldObjectViewInformation worldObjectViewInformation : this.worldObjectViewInfos) {
                graphics.drawImage(this.scaledWorldImages[worldObjectViewInformation.guiid], this.offsetX + worldObjectViewInformation.x * this.imageSize, this.offsetY + worldObjectViewInformation.y * this.imageSize, null);
            }
        }
    }

    protected void paintGrid(Graphics graphics) {
        graphics.setColor(WORLD_GRID_COLOR);
        int n = 0;
        for (int i = 0; i <= this.worldImageSizeX; i += this.imageSize) {
            graphics.drawLine(this.offsetX + i, this.offsetY, this.offsetX + i, this.offsetY + this.worldImageSizeY - 1);
        }
        while (n <= this.worldImageSizeY) {
            graphics.drawLine(this.offsetX, this.offsetY + n, this.offsetX + this.worldImageSizeX - 1, this.offsetY + n);
            n += this.imageSize;
        }
    }

    protected void calculateOffsets() {
        this.offsetX = (this.getWidth() - this.worldImageSizeX) / 2 + this.distX;
        this.offsetY = (this.getHeight() - this.worldImageSizeY) / 2 + this.distY;
    }

    protected boolean allowMove() {
        return this.worldImageSizeX > this.getWidth() || this.worldImageSizeY > this.getHeight();
    }

    protected void checkDistances() {
        if (this.worldImageSizeX > this.getWidth()) {
            if (this.distX > 5 - (this.getWidth() - this.worldImageSizeX) / 2) {
                this.distX = 5 - (this.getWidth() - this.worldImageSizeX) / 2;
            }
            if (this.distX < (this.getWidth() - this.worldImageSizeX) / 2 - 5) {
                this.distX = (this.getWidth() - this.worldImageSizeX) / 2 - 5;
            }
        } else {
            this.distX = 0;
        }
        if (this.worldImageSizeY > this.getHeight()) {
            if (this.distY > 5 - (this.getHeight() - this.worldImageSizeY) / 2) {
                this.distY = 5 - (this.getHeight() - this.worldImageSizeY) / 2;
            }
            if (this.distY < (this.getHeight() - this.worldImageSizeY) / 2 - 5) {
                this.distY = (this.getHeight() - this.worldImageSizeY) / 2 - 5;
            }
        } else {
            this.distY = 0;
        }
    }

    protected void resetWorldImageSize() {
        this.worldImageSizeX = this.world.getSizeX() * this.imageSize + 1;
        this.worldImageSizeY = this.world.getSizeY() * this.imageSize + 1;
        this.checkDistances();
    }

    protected void changeZoom(int n) {
        double d = this.zoom + 2.0 * ((double)n - (double)this.eventStart.y) / this.dScaleDist;
        this.eventStart.y = n;
        this.setZoomFactor(d);
    }

    protected void changeVisiblePart(Point point) {
        this.distX = this.distX - this.eventStart.x + point.x;
        this.distY = this.distY - this.eventStart.y + point.y;
        this.checkDistances();
        this.calculateOffsets();
        this.eventStart = point;
    }

    protected void setNormalCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    protected void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    protected synchronized void updateObjectPositions() {
        List<WorldField> list = this.world.getObjectFieldsVector();
        this.kara = Kara.findKaraInWorld(this.world, "Kara");
        this.worldObjectViewInfos = new ArrayList<WorldObjectViewInformation>();
        for (int i = 0; i < list.size(); ++i) {
            WorldField worldField = list.get(i);
            WorldObjectInterface[] worldObjectInterfaceArray = worldField.getStack();
            for (int j = 0; j < worldObjectInterfaceArray.length; ++j) {
                if (worldObjectInterfaceArray[j] == null) continue;
                WorldObjectViewInformation worldObjectViewInformation = new WorldObjectViewInformation();
                worldObjectViewInformation.x = worldField.getX();
                worldObjectViewInformation.y = worldField.getY();
                worldObjectViewInformation.guiid = worldObjectInterfaceArray[j].getGUIID();
                if (this.karasPerspectivePossible && this.karasPerspectiveEnabled) {
                    worldObjectViewInformation.visibleToKara = this.isVisibleToActor(worldObjectInterfaceArray[j], worldObjectViewInformation.x, worldObjectViewInformation.y);
                }
                this.worldObjectViewInfos.add(worldObjectViewInformation);
            }
        }
    }

    @Override
    public BufferedImage getDragImage(Object object) {
        if (this.enableDragDrop && object != null) {
            ImageIcon imageIcon = Konfig.getWorldImages()[((WorldObjectInterface)object).getGUIID()];
            BufferedImage bufferedImage = new BufferedImage(28, 28, 6);
            bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, null);
            return bufferedImage;
        }
        return null;
    }

    @Override
    public Object acceptsDrag(MouseEvent mouseEvent) {
        if (this.enableDragDrop) {
            WorldField worldField;
            Point point = mouseEvent.getPoint();
            Point point2 = this.getFieldPos(point.x, point.y);
            if (point2 != null && (worldField = this.world.getWorldFieldAt(point2.x, point2.y)).getTop() != null) {
                this.dragOrigin.x = point2.x;
                this.dragOrigin.y = point2.y;
                this.dragObject = worldField.getTop();
                this.setEnabledMoveWorld(false);
                return this.dragObject;
            }
        }
        return null;
    }

    @Override
    public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
        Point point = mouseEvent.getPoint();
        Point point2 = this.getFieldPos(point.x, point.y);
        return object != null && object instanceof WorldObjectInterface && point2 != null && !point2.equals(this.dragOrigin) && this.world.canPutObjectAt((WorldObjectInterface)object, point2.x, point2.y);
    }

    @Override
    public void dropTransferObject(MouseEvent mouseEvent, Object object) {
        Point point = mouseEvent.getPoint();
        Point point2 = this.getFieldPos(point.x, point.y);
        if (object instanceof WorldObjectInterface && point2 != null) {
            WorldObjectInterface worldObjectInterface = (WorldObjectInterface)object;
            if (this.dragOrigin.x != -1) {
                this.world.moveObjectAt(worldObjectInterface, this.dragOrigin.x, this.dragOrigin.y, point2.x, point2.y);
            } else {
                this.world.putObjectAt(worldObjectInterface.cloneWorldObject(), point2.x, point2.y);
            }
            this.firePropertyChange(KARA_PUT_PROPERTY, new String(""), worldObjectInterface);
            this.dragOrigin.x = -1;
            this.dragOrigin.y = -1;
        }
    }

    @Override
    public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
        this.dragOrigin.x = -1;
        this.dragOrigin.y = -1;
        this.dragObject = null;
        this.setEnabledMoveWorld(true);
    }

    public boolean isKarasPerspectiveEnabled() {
        return this.karasPerspectiveEnabled;
    }

    public void setKarasPerspectiveEnabled(boolean bl) {
        this.karasPerspectiveEnabled = bl;
    }

    public boolean isKarasPerspectivePossible() {
        return this.karasPerspectivePossible;
    }

    public void setKarasPerspectivePossible(boolean bl) {
        this.karasPerspectivePossible = bl;
    }

    private static class WorldObjectViewInformation {
        public int x;
        public int y;
        public int guiid;
        public boolean visibleToKara;

        private WorldObjectViewInformation() {
        }
    }
}

