/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world.editor;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.Konfig;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.kapps.world.editor.DndToggleButton;
import ch.karatojava.kapps.world.editor.ToggleObjectsMouseListener;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.kapps.world.editor.WorldExportWindow;
import ch.karatojava.kapps.world.editor.WorldSizeDialog;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;

public class WorldEditorToolbar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG_MODE = false;
    public static final String CLIENT_PROPERTY_TOOLTIP = "WorldEditorToolbarTooltip";
    private WorldEditor worldEditor;
    private World clipboardWorld;
    private JToggleButton dummyButton;
    private WorldSizeDialog worldSizeDialog;
    private JPopupMenu popupMenu;
    private JPopupMenu zoomMenu;
    private JPanel zoomPanel;
    private JPanel sizePanel;
    private JButton zoomButton;
    private WorldExportWindow worldExportWindow;
    private JMenuItem worldPasteMenuItem;
    private ToggleObjectsMouseListener currentToggler;
    private MenuListener menuListener = new MenuListener();
    private boolean interpreterRunning;
    private MouseListener stopTogglerListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (WorldEditorToolbar.this.findComponentAt(mouseEvent.getPoint()) == WorldEditorToolbar.this) {
                WorldEditorToolbar.this.stopToggling();
            }
        }
    };
    private MouseListener popupListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if ((n & 4) > 0 || (n & 0x10) > 0 && (n & 2) > 0) {
                WorldEditorToolbar.this.requestFocus();
                WorldEditorToolbar.this.popupMenu.show(WorldEditorToolbar.this.worldEditor.getWorldView(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };
    private ActionListener zoomPopupListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            WorldEditorToolbar.this.zoomMenu.show(jComponent, jComponent.getWidth(), 0);
        }
    };
    private InterpreterListener interpreterListener = new InterpreterListenerAdapter(){

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            WorldEditorToolbar.this.interpreterRunning = true;
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
            WorldEditorToolbar.this.interpreterRunning = false;
        }

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            WorldEditorToolbar.this.interpreterRunning = false;
        }
    };
    private FocusAdapter editFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            WorldEditorToolbar.this.stopToggling();
        }
    };

    public WorldEditorToolbar(WorldEditor worldEditor) {
        assert (worldEditor != null);
        this.worldEditor = worldEditor;
        this.worldSizeDialog = this.createWorldSizeDialog();
        this.createGUI();
        this.createPopupMenus();
        this.createZoomPanel();
        this.createSizePanel();
        worldEditor.getWorldView().addMouseListener(this.popupListener);
        this.addMouseListener(this.stopTogglerListener);
        this.worldExportWindow = new WorldExportWindow(worldEditor);
    }

    public InterpreterListener getInterpreterListener() {
        return this.interpreterListener;
    }

    public ActionListener getZoomListener() {
        return this.zoomPopupListener;
    }

    public JComponent getZoomPanel() {
        return this.zoomPanel;
    }

    public JComponent getSizePanel() {
        return this.sizePanel;
    }

    protected JToggleButton initButton(DndToggleButton dndToggleButton, ImageIcon imageIcon) {
        ToggleObjectsMouseListener toggleObjectsMouseListener = new ToggleObjectsMouseListener(this.worldEditor, dndToggleButton.getWorldField(), imageIcon, this.dummyButton);
        dndToggleButton.addActionListener(new EditActionListener(toggleObjectsMouseListener));
        dndToggleButton.addFocusListener(this.editFocusListener);
        return dndToggleButton;
    }

    protected JToggleButton createButton(WorldObjectInterface worldObjectInterface) {
        DndToggleButton dndToggleButton = new DndToggleButton(worldObjectInterface);
        return this.initButton(dndToggleButton, (ImageIcon)worldObjectInterface.getClientProperty("imageicon"));
    }

    protected WorldSizeDialog createWorldSizeDialog() {
        return new WorldSizeDialog(this.worldEditor);
    }

    private void stopToggling() {
        this.worldEditor.getWorldView().removeMouseListener(this.currentToggler);
        this.worldEditor.getWorldView().removeMouseMotionListener(this.currentToggler);
        this.currentToggler = null;
        this.worldEditor.getWorldView().setCursor(Cursor.getPredefinedCursor(0));
        this.dummyButton.doClick();
        this.worldEditor.getWorldView().setEnabledDragDrop(true);
        this.worldEditor.getWorldView().setEnabledMoveWorld(true);
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/worldeditor/worldcontroller/bordertitle"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.dummyButton = new JToggleButton("never visible", true);
        buttonGroup.add(this.dummyButton);
        WorldObjectInterface[] worldObjectInterfaceArray = Konfig.getWorldObjects();
        for (int i = 0; i < worldObjectInterfaceArray.length; ++i) {
            JToggleButton jToggleButton = this.createButton(worldObjectInterfaceArray[i]);
            if (worldObjectInterfaceArray[i].getClientProperty(CLIENT_PROPERTY_TOOLTIP) != null) {
                jToggleButton.setToolTipText(Configuration.getInstance().getString((String)worldObjectInterfaceArray[i].getClientProperty(CLIENT_PROPERTY_TOOLTIP)));
            }
            buttonGroup.add(jToggleButton);
            this.add(jToggleButton);
        }
        this.add(Box.createRigidArea(new Dimension(5, 10)));
        this.add(Box.createVerticalGlue());
        TrashButton trashButton = new TrashButton();
        trashButton.setBorder(BorderFactory.createEmptyBorder(GuiFactory.BUTTON_MARGIN.top, GuiFactory.BUTTON_MARGIN.left, GuiFactory.BUTTON_MARGIN.bottom, GuiFactory.BUTTON_MARGIN.right));
        this.add(trashButton);
    }

    private void createPopupMenus() {
        this.popupMenu = GuiFactory.getInstance().createPopupMenu("worldeditor/contextmenu", this.menuListener);
        this.worldPasteMenuItem = (JMenuItem)this.popupMenu.getComponent(2);
        this.worldPasteMenuItem.setEnabled(false);
        this.zoomMenu = GuiFactory.getInstance().createPopupMenu("worldeditor/zoommenu", this.menuListener);
    }

    private void createZoomPanel() {
        this.zoomButton = new JButton(GuiFactory.getInstance().createImageIcon("icons/zoomfit"));
        this.zoomButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0), BorderFactory.createLineBorder(new Color(120, 140, 120), 1)));
        this.zoomButton.setFocusPainted(false);
        this.zoomButton.setActionCommand("zoomFit");
        this.zoomButton.addActionListener(this.menuListener);
        JButton jButton = new JButton(GuiFactory.getInstance().createImageIcon("icons/menuopener"));
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createLineBorder(new Color(120, 140, 120), 1)));
        jButton.setFocusPainted(false);
        jButton.addActionListener(this.getZoomListener());
        this.zoomPanel = new JPanel();
        this.zoomPanel.setBorder(BorderFactory.createCompoundBorder(GuiFactory.getInstance().createTitledBorder("language/$language/worldeditor/zoomtitle"), BorderFactory.createEmptyBorder(0, 0, 5, 0)));
        this.zoomPanel.setLayout(new BoxLayout(this.zoomPanel, 0));
        this.zoomPanel.add(Box.createHorizontalGlue());
        this.zoomPanel.add(this.zoomButton);
        this.zoomPanel.add(jButton);
        this.zoomPanel.add(Box.createHorizontalGlue());
    }

    private void createSizePanel() {
        JButton jButton = new JButton(GuiFactory.getInstance().createImageIcon("icons/setworldsize"));
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0), BorderFactory.createLineBorder(new Color(120, 140, 120), 1)));
        jButton.setFocusPainted(false);
        jButton.setActionCommand("resize");
        jButton.addActionListener(this.menuListener);
        this.sizePanel = new JPanel();
        this.sizePanel.setBorder(BorderFactory.createCompoundBorder(GuiFactory.getInstance().createTitledBorder("language/$language/worldeditor/sizetitle"), BorderFactory.createEmptyBorder(0, 0, 5, 0)));
        this.sizePanel.setLayout(new BoxLayout(this.sizePanel, 0));
        this.sizePanel.add(Box.createHorizontalGlue());
        this.sizePanel.add(jButton);
        this.sizePanel.add(Box.createHorizontalGlue());
    }

    private class TrashButton
    extends JLabel
    implements LightweightDragDrop {
        private static final long serialVersionUID = 1L;

        public TrashButton() {
            super(GuiFactory.getInstance().createImageIcon("icons/trashcan"));
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            return null;
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            return null;
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            return (object instanceof WorldObjectInterface && ((WorldObjectInterface)object).getType() != 8 || !WorldEditorToolbar.this.interpreterRunning) && WorldEditorToolbar.this.worldEditor.getWorldView().getDragOrigin() != null;
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
            Point point = WorldEditorToolbar.this.worldEditor.getWorldView().getDragOrigin();
            if (point != null && object instanceof WorldObjectInterface) {
                WorldObjectInterface worldObjectInterface = (WorldObjectInterface)object;
                WorldEditorToolbar.this.worldEditor.getWorld().removeObjectAt(worldObjectInterface, point.x, point.y);
            }
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
        }
    }

    protected class MenuListener
    extends ExceptionActionListener {
        protected MenuListener() {
        }

        private void checkInterpreter(String string) {
            if (WorldEditorToolbar.this.interpreterRunning) {
                throw new RuntimeException(Configuration.getInstance().getString(string));
            }
        }

        public void clear(ActionEvent actionEvent) {
            this.checkInterpreter("language/$language/worldeditor/cannotclearall");
            WorldEditorToolbar.this.worldEditor.getWorld().clearAll();
        }

        public void copy(ActionEvent actionEvent) {
            this.checkInterpreter("language/$language/worldeditor/cannotcopy");
            WorldEditorToolbar.this.clipboardWorld = new World(WorldEditorToolbar.this.worldEditor.getWorld());
            WorldEditorToolbar.this.worldPasteMenuItem.setEnabled(true);
        }

        public void paste(ActionEvent actionEvent) {
            this.checkInterpreter("language/$language/worldeditor/cannotpaste");
            if (WorldEditorToolbar.this.clipboardWorld != null) {
                WorldEditorToolbar.this.worldEditor.setWorld(new World(WorldEditorToolbar.this.clipboardWorld));
            }
        }

        public void exportWorld(ActionEvent actionEvent) {
            WorldEditorToolbar.this.worldExportWindow.showExportDialog();
        }

        public void resize(ActionEvent actionEvent) {
            this.checkInterpreter("language/$language/worldeditor/cannotresize");
            WorldEditorToolbar.this.worldSizeDialog.setVisible(true);
            if (WorldEditorToolbar.this.worldSizeDialog.getReturnValue() == 0) {
                WorldEditorToolbar.this.worldEditor.getWorld().setSize(WorldEditorToolbar.this.worldSizeDialog.getWorldSizeX(), WorldEditorToolbar.this.worldSizeDialog.getWorldSizeY());
            }
        }

        private void checkZoomPanel(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                WorldEditorToolbar.this.zoomButton.setIcon(jMenuItem.getIcon());
                WorldEditorToolbar.this.zoomButton.setActionCommand(jMenuItem.getActionCommand());
            }
        }

        public void zoomIn(ActionEvent actionEvent) {
            double d = WorldEditorToolbar.this.worldEditor.getWorldView().getZoomFactor();
            WorldEditorToolbar.this.worldEditor.getWorldView().setZoomFactor(d *= 1.1);
            this.checkZoomPanel(actionEvent);
        }

        public void zoomFit(ActionEvent actionEvent) {
            WorldEditorToolbar.this.worldEditor.getWorldView().setZoomFitSize();
            this.checkZoomPanel(actionEvent);
        }

        public void zoomOut(ActionEvent actionEvent) {
            double d = WorldEditorToolbar.this.worldEditor.getWorldView().getZoomFactor();
            WorldEditorToolbar.this.worldEditor.getWorldView().setZoomFactor(d *= 0.9);
            this.checkZoomPanel(actionEvent);
        }

        public void zoom100Percent(ActionEvent actionEvent) {
            WorldEditorToolbar.this.worldEditor.getWorldView().setZoomFactor(1.0);
            this.checkZoomPanel(actionEvent);
        }

        public void switchgui(ActionEvent actionEvent) {
            ((WorldEditorToolbar)WorldEditorToolbar.this).worldEditor.getWorldView().drawWorld = !((WorldEditorToolbar)WorldEditorToolbar.this).worldEditor.getWorldView().drawWorld;
        }
    }

    protected class EditActionListener
    implements ActionListener {
        private ToggleObjectsMouseListener toggler;

        public EditActionListener(ToggleObjectsMouseListener toggleObjectsMouseListener) {
            this.toggler = toggleObjectsMouseListener;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (WorldEditorToolbar.this.currentToggler != this.toggler) {
                WorldEditorToolbar.this.worldEditor.getWorldView().setEnabledDragDrop(false);
                WorldEditorToolbar.this.worldEditor.getWorldView().setEnabledMoveWorld(false);
                WorldEditorToolbar.this.worldEditor.getWorldView().removeMouseListener(this.toggler);
                WorldEditorToolbar.this.worldEditor.getWorldView().removeMouseMotionListener(this.toggler);
                WorldEditorToolbar.this.worldEditor.getWorldView().addMouseListener(this.toggler);
                WorldEditorToolbar.this.worldEditor.getWorldView().addMouseMotionListener(this.toggler);
                WorldEditorToolbar.this.currentToggler = this.toggler;
            }
        }
    }
}

