/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world.editor;

import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.kapps.world.editor.WorldEditor;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.event.MouseInputAdapter;

public class ToggleObjectsMouseListener
extends MouseInputAdapter {
    protected static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    protected Cursor fieldCursor;
    protected WorldEditor worldEditor;
    protected Point pressedOnWorldPoint;
    protected JToggleButton dummyButton;
    protected WorldObjectInterface worldObject;
    protected ImageIcon cursorIcon;

    public ToggleObjectsMouseListener(WorldEditor worldEditor, WorldObjectInterface worldObjectInterface, ImageIcon imageIcon, JToggleButton jToggleButton) {
        this.worldEditor = worldEditor;
        this.dummyButton = jToggleButton;
        this.worldObject = worldObjectInterface;
        this.cursorIcon = imageIcon;
        this.pressedOnWorldPoint = null;
        this.setCursor();
    }

    @Override
    public final void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = this.worldEditor.getWorldView().getFieldPos(point.x, point.y);
        this.updateCursor(point2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        Point point = mouseEvent.getPoint();
        Point point2 = this.worldEditor.getWorldView().getFieldPos(point.x, point.y);
        if (point2 != null) {
            if ((n & 0x10) > 0) {
                if (this.conditionTrue(point2)) {
                    this.action(point2);
                }
                this.pressedOnWorldPoint = new Point(point2);
            }
        } else {
            this.worldEditor.getWorldView().requestFocus();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pressedOnWorldPoint != null) {
            Point point = mouseEvent.getPoint();
            Point point2 = this.worldEditor.getWorldView().getFieldPos(point.x, point.y);
            this.updateCursor(point2);
            if (point2 != null && !point2.equals(this.pressedOnWorldPoint) && this.conditionTrue(point2)) {
                this.action(point2);
                this.pressedOnWorldPoint = new Point(point2);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressedOnWorldPoint = null;
    }

    protected void setCursor() {
        BufferedImage bufferedImage = new BufferedImage(32, 32, 6);
        bufferedImage.getGraphics().drawImage(this.cursorIcon.getImage(), 2, 2, null);
        this.fieldCursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(15, 15), "");
    }

    protected boolean conditionTrue(Point point) {
        int n = point.x;
        int n2 = point.y;
        boolean bl = this.worldEditor.getWorld().canPutObjectAt(this.worldObject, n, n2) || this.worldEditor.getWorld().isObjectOfTypeAt(this.worldObject, n, n2);
        return bl;
    }

    protected void updateCursor(Point point) {
        if (point != null && this.conditionTrue(point)) {
            this.worldEditor.getWorldView().setCursor(this.fieldCursor);
        } else {
            this.worldEditor.getWorldView().setCursor(DEFAULT_CURSOR);
        }
    }

    protected void action(Point point) {
        int n;
        int n2;
        World world = this.worldEditor.getWorld();
        if (world.canPutObjectAt(this.worldObject, n2 = point.x, n = point.y)) {
            world.putObjectAt(this.worldObject.cloneWorldObject(), n2, n);
        } else {
            world.removeObjectOfSameTypeAt(this.worldObject, n2, n);
        }
    }
}

