/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world.editor;

import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class DndToggleButton
extends JToggleButton
implements LightweightDragDrop {
    private static final long serialVersionUID = 1L;
    protected WorldObjectInterface dragObject;
    protected ImageIcon dragIcon;

    public DndToggleButton(WorldObjectInterface worldObjectInterface) {
        this(worldObjectInterface, 4, 4, 4, 4, true);
    }

    public DndToggleButton(WorldObjectInterface worldObjectInterface, int n, int n2, int n3, int n4, boolean bl) {
        super((ImageIcon)worldObjectInterface.getClientProperty("imageicon"));
        GuiFactory.getInstance().createButtonUI(this, n, n2, n3, n4, bl);
        this.dragObject = worldObjectInterface;
        this.dragIcon = (ImageIcon)worldObjectInterface.getClientProperty("imageicon");
    }

    public WorldObjectInterface getWorldField() {
        return this.dragObject;
    }

    @Override
    public BufferedImage getDragImage(Object object) {
        BufferedImage bufferedImage = new BufferedImage(28, 28, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(this.dragIcon.getImage(), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public Object acceptsDrag(MouseEvent mouseEvent) {
        return this.dragObject;
    }

    @Override
    public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
        return false;
    }

    @Override
    public void dropTransferObject(MouseEvent mouseEvent, Object object) {
        assert (false) : "WorldEditorToolbar.dropTransferObject: should never be called";
    }

    @Override
    public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
    }
}

