/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turtleworld;

import ch.karatojava.kapps.turtleworld.Turtle;
import ch.karatojava.kapps.turtleworld.TurtleWorldEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.gui.ZoomableJComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class TurtleWorld
extends ZoomableJComponent {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_PEN_WIDTH = 2;
    protected static final BasicStroke DEFAULT_LINE_STROKE = new BasicStroke(2.0f, 1, 2);
    protected static final Color DEFAULT_COLOR = new Color(0, 0, 0);
    public static final int DEFAULT_WORLD_SIZE = 1000;
    protected static final int TURTLE_IMAGE_SIZE = 28;
    protected static final BufferedImage[] TURTLE_IMAGES = new BufferedImage[360];
    protected int worldSizeX;
    protected int worldSizeY;
    protected BufferedImage world;
    protected Graphics2D worldGraphics;
    protected List<Turtle> turtles;
    protected boolean modified;
    protected Line2D line;
    protected BasicStroke lineStroke;
    protected int penWidth;
    protected Color color;
    protected TurtleWorldEditor turtleWorldEditor;

    public TurtleWorld(TurtleWorldEditor turtleWorldEditor) {
        this.turtleWorldEditor = turtleWorldEditor;
        this.clear();
    }

    protected BufferedImage createWorld() {
        BufferedImage bufferedImage = new BufferedImage(this.worldSizeX, this.worldSizeY, 2);
        bufferedImage.setRGB(255, 255, 255);
        this.worldGraphics = (Graphics2D)bufferedImage.getGraphics();
        this.worldGraphics.setStroke(this.lineStroke);
        this.worldGraphics.setPaint(this.color);
        this.worldGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return bufferedImage;
    }

    public List<Turtle> getTurtles() {
        return this.turtles;
    }

    public void clear() {
        this.turtles = new ArrayList<Turtle>();
        this.worldSizeX = 1000;
        this.worldSizeY = 1000;
        this.line = new Line2D.Float();
        this.penWidth = 2;
        this.lineStroke = DEFAULT_LINE_STROKE;
        this.color = DEFAULT_COLOR;
        this.world = this.createWorld();
        this.setModified(false);
        this.repaint();
    }

    public int getWorldSizeX() {
        return this.worldSizeX;
    }

    public void setWorldSizeX(int n) {
        this.worldSizeX = n;
    }

    public int getWorldSizeY() {
        return this.worldSizeY;
    }

    public void setWorldSizeY(int n) {
        this.worldSizeY = n;
    }

    protected int transformX(int n) {
        return this.worldSizeX / 2 + n;
    }

    protected int transformY(int n) {
        return this.worldSizeX / 2 - n;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        int n5 = this.transformX(n);
        int n6 = this.transformY(n2);
        int n7 = this.transformX(n3);
        int n8 = this.transformY(n4);
        this.line.setLine(n5, n6, n7, n8);
        this.worldGraphics.draw(this.line);
        this.repaint();
        this.setModified(true);
    }

    public Turtle addTurtle() {
        Turtle turtle = new Turtle();
        this.turtles.add(turtle);
        turtle.setTurtleWorld(this);
        this.setModified(true);
        return turtle;
    }

    public void setColor(int n, int n2, int n3) {
        this.color = new Color(n, n2, n3);
        this.worldGraphics.setPaint(this.color);
    }

    public Color getColor() {
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public int getPenWidth() {
        return this.penWidth;
    }

    public void setPenWidth(int n) {
        this.penWidth = n;
        this.lineStroke = new BasicStroke(n, 1, 2);
        this.worldGraphics.setStroke(this.lineStroke);
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        graphics.drawImage(this.world, this.offsetX, this.offsetY, null);
        for (Turtle turtle : this.turtles) {
            int n = this.offsetX + this.transformX(turtle.getX()) - 14;
            int n2 = this.offsetY + this.transformY(turtle.getY()) - 14;
            graphics.drawImage(TURTLE_IMAGES[turtle.getDirection()], n, n2, null);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (bl) {
            this.turtleWorldEditor.notifyModification();
        }
    }

    public BufferedImage getWorldImage() {
        return this.world;
    }

    public void setWorldImage(BufferedImage bufferedImage) {
        this.clear();
        this.worldGraphics.drawImage(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        this.repaint();
    }

    public TurtleWorldEditor getTurtleWorldEditor() {
        return this.turtleWorldEditor;
    }

    @Override
    protected int getTotalHeight() {
        return this.getWorldSizeX();
    }

    @Override
    protected int getTotalWidth() {
        return this.getWorldSizeY();
    }

    static {
        Image image = Configuration.getInstance().getImage("icons/turtles/turtleFacingEastIcon");
        for (int i = 0; i < 360; ++i) {
            TurtleWorld.TURTLE_IMAGES[i] = new BufferedImage(28, 28, 2);
            Graphics2D graphics2D = (Graphics2D)TURTLE_IMAGES[i].getGraphics();
            graphics2D.rotate(Math.toRadians(-i), 14.0, 14.0);
            graphics2D.drawImage(image, 0, 0, null);
        }
    }
}

