/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turtleworld;

import ch.karatojava.kapps.turtleworld.TurtleWorld;

public class Turtle {
    protected double x = 0.0;
    protected double y = 0.0;
    protected int direction = 0;
    protected boolean penDown = true;
    protected TurtleWorld turtleWorld;

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getX() {
        return (int)this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return (int)this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public boolean isPenDown() {
        return this.penDown;
    }

    public void setPenDown(boolean bl) {
        this.penDown = bl;
    }

    public void penUp() {
        this.penDown = false;
    }

    public void penDown() {
        this.penDown = true;
    }

    public TurtleWorld getTurtleWorld() {
        return this.turtleWorld;
    }

    public void setTurtleWorld(TurtleWorld turtleWorld) {
        this.turtleWorld = turtleWorld;
    }

    public void moveto(int n, int n2) {
        if (this.penDown) {
            this.turtleWorld.drawLine((int)this.x, (int)this.y, n, n2);
        }
        this.x = n;
        this.y = n2;
    }

    public void forward(int n) {
        double d = this.x;
        double d2 = this.y;
        this.x += Math.cos(Math.toRadians(this.direction)) * (double)n;
        this.y += Math.sin(Math.toRadians(this.direction)) * (double)n;
        if (this.penDown) {
            this.turtleWorld.drawLine((int)d, (int)d2, (int)this.x, (int)this.y);
        }
    }

    public void turn(int n) {
        this.direction = (this.direction + n) % 360;
        while (this.direction < 0) {
            this.direction += 360;
        }
        this.turtleWorld.repaint();
    }

    public void setColor(int n, int n2, int n3) {
        this.turtleWorld.setColor(n, n2, n3);
    }

    public int getColorRed() {
        return this.turtleWorld.getColor().getRed();
    }

    public int getColorGreen() {
        return this.turtleWorld.getColor().getGreen();
    }

    public int getColorBlue() {
        return this.turtleWorld.getColor().getBlue();
    }

    public int getPenWidth() {
        return this.turtleWorld.getPenWidth();
    }

    public void setPenWidth(int n) {
        this.turtleWorld.setPenWidth(n);
    }
}

