/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turingkaraide.worldio;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.turingkaraide.TuringObject;
import ch.karatojava.kapps.turingkaraide.worldio.TuringKaraWorldOutputter;
import ch.karatojava.kapps.turingkaraide.worldio.XmlKara;
import ch.karatojava.kapps.turingkaraide.worldio.XmlWorld;
import ch.karatojava.kapps.turingkaraide.worldio.XmlWorldObject;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldInternalException;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.kapps.world.editor.io.WorldBuilderInterface;
import ch.karatojava.util.Configuration;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class TuringKaraWorldBuilder
implements WorldBuilderInterface {
    private static TuringKaraWorldBuilder instance;

    public static WorldBuilderInterface getInstance() {
        if (instance == null) {
            instance = new TuringKaraWorldBuilder();
        }
        return instance;
    }

    @Override
    public World buildWorld(InputStream inputStream) throws Exception {
        try {
            int n;
            Object object;
            Object object2;
            int n2;
            List<Object> list;
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"ch.karatojava.kapps.turingkaraide.worldio");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            XmlWorld xmlWorld = (XmlWorld)unmarshaller.unmarshal(inputStream);
            String string = xmlWorld.getVersion();
            if (!string.equalsIgnoreCase(TuringKaraWorldOutputter.version)) {
                String[] stringArray = new String[]{string, TuringKaraWorldOutputter.version};
                throw new WorldInternalException("language/$language/iomessages/wrongversion", stringArray);
            }
            World world = new World(xmlWorld.getSizex(), xmlWorld.getSizey());
            if (xmlWorld.getXmlKara().size() > 0) {
                list = xmlWorld.getXmlKara();
                for (n2 = 0; n2 < list.size(); ++n2) {
                    int n3;
                    object2 = (XmlKara)list.get(n2);
                    if (Kara.getKara(((XmlKara)object2).getName()) != null) {
                        object = (Kara)Kara.getKara(((XmlKara)object2).getName()).clone();
                        ((Kara)object).setDirection(((XmlKara)object2).getDirection());
                        n3 = ((XmlKara)object2).getX();
                        n = ((XmlKara)object2).getY();
                        this.checkCoordinate(world, n3, n);
                        if (!world.canPutObjectAt((WorldObjectInterface)object, n3, n)) {
                            throw new Exception("Invalid kara / other object combination.");
                        }
                    } else {
                        throw new WorldInternalException("language/$language/iomessages/invalidactorname");
                    }
                    world.putObjectAt((WorldObjectInterface)object, n3, n);
                }
            }
            list = xmlWorld.getXmlWorldObject();
            for (n2 = 0; n2 < list.size(); ++n2) {
                object2 = (XmlWorldObject)list.get(n2);
                object = ((XmlWorldObject)object2).getType();
                if (!TuringObject.isValidSymbol((String)object)) {
                    throw new Exception("Invalid symbol (" + (String)object + ")");
                }
                TuringObject turingObject = TuringObject.getInstance((String)object);
                n = ((XmlWorldObject)object2).getX();
                int n4 = ((XmlWorldObject)object2).getY();
                this.checkCoordinate(world, n, n4);
                if (!world.canPutObjectAt(turingObject, n, n4)) {
                    throw new Exception("Invalid kara / other object combination.");
                }
                world.putObjectAt(turingObject, n, n4);
            }
            return world;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            String string2 = MessageFormat.format(Configuration.getInstance().getString("language/$language/iomessages/error"), string);
            throw new Exception(string2);
        }
    }

    protected void checkCoordinate(World world, int n, int n2) throws Exception {
        if (!world.coordinateOk(n, n2)) {
            throw new Exception("Invalid coordinate (" + n + ", " + n2 + ")");
        }
    }
}

