/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turingkaraide;

import ch.karatojava.kapps.world.WorldObject;
import ch.karatojava.kapps.world.WorldObjectInterface;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class TuringObject
extends WorldObject {
    private String symbol;
    private static Hashtable<String, TuringObject> turingObjects = new Hashtable();
    private static List<String> validSymbols;

    private TuringObject(String string) {
        this.symbol = string;
        turingObjects.put(string, this);
    }

    public static boolean isValidSymbol(String string) {
        return validSymbols != null && validSymbols.contains(string);
    }

    public static void setValidSymbols(List<String> list) {
        validSymbols = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            validSymbols.add(list.get(i));
        }
    }

    @Override
    public boolean canCombineWith(WorldObjectInterface worldObjectInterface) {
        return true;
    }

    @Override
    public WorldObjectInterface mergeWith(WorldObjectInterface worldObjectInterface) {
        if (worldObjectInterface.equals(TuringObject.getInstance("")) || this.equals(worldObjectInterface)) {
            return null;
        }
        return worldObjectInterface;
    }

    @Override
    public WorldObjectInterface detach(WorldObjectInterface worldObjectInterface) {
        return null;
    }

    @Override
    public WorldObjectInterface cloneWorldObject() {
        return this;
    }

    public String getLetter() {
        return this.symbol;
    }

    @Override
    public boolean equals(WorldObjectInterface worldObjectInterface) {
        return worldObjectInterface != null && worldObjectInterface.getType() == this.getType() && this.symbol.equals(((TuringObject)worldObjectInterface).getLetter());
    }

    public static TuringObject getInstance(String string) {
        if (turingObjects.get(string) == null) {
            new TuringObject(string);
        }
        return turingObjects.get(string);
    }
}

