/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turingkaraide;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraException;
import ch.karatojava.kapps.turingkaraide.TuringObject;
import ch.karatojava.kapps.world.WorldObjectInterface;

public class TuringKara
extends Kara {
    public TuringKara(String string) {
        super(string);
    }

    public TuringKara(String string, int n) {
        this(string);
        this.integerIdentifier = n;
    }

    public TuringKara(TuringKara turingKara) {
        this(turingKara.identity, turingKara.integerIdentifier);
        this.direction = turingKara.direction;
        this.x = turingKara.x;
        this.y = turingKara.y;
        this.guiID = turingKara.guiID;
        this.clientProperties = turingKara.clientProperties;
    }

    @Override
    public int getGUIID() {
        return this.guiID;
    }

    @Override
    public Object clone() {
        return new TuringKara(this);
    }

    @Override
    public WorldObjectInterface cloneWorldObject() {
        return new TuringKara(this);
    }

    public void moveUp() throws KaraException {
        this.direction = 0;
        this.move();
    }

    public void moveDown() throws KaraException {
        this.direction = 2;
        this.move();
    }

    public void moveLeft() throws KaraException {
        this.direction = 1;
        this.move();
    }

    public void moveRight() throws KaraException {
        this.direction = 3;
        this.move();
    }

    public void putZero() {
        this.putTuringObject("zero");
    }

    public void putOne() {
        this.putTuringObject("one");
    }

    public void putE() {
        if (this.world.isObjectOfTypeAt(TuringObject.getInstance(""), this.x, this.y)) {
            this.world.removeObjectOfSameTypeAt(TuringObject.getInstance(""), this.x, this.y);
        }
    }

    public void putUp() {
        this.putTuringObject("up");
    }

    public void putLeft() {
        this.putTuringObject("left");
    }

    public void putRight() {
        this.putTuringObject("right");
    }

    public void putDown() {
        this.putTuringObject("down");
    }

    public void putTerm() {
        this.putTuringObject("term");
    }

    private void putTuringObject(String string) {
        if (!this.world.isObjectAt(TuringObject.getInstance(string), this.x, this.y)) {
            this.world.putObjectAt(TuringObject.getInstance(string), this.x, this.y);
        }
    }

    @Override
    public synchronized void move() throws KaraException {
        this.assertCanMove();
        int n = this.nextX();
        int n2 = this.nextY();
        int n3 = this.x;
        int n4 = this.y;
        this.x = n;
        this.y = n2;
        this.world.moveObjectAt(this, n3, n4, this.x, this.y);
    }

    @Override
    protected synchronized void assertCanMove() throws KaraException {
    }
}

