/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks.kara;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraException;
import ch.karatojava.kapps.tasks.AbstractTestCase;
import ch.karatojava.kapps.tasks.kara.TestCaseInterpreterListener;
import ch.karatojava.kapps.world.World;
import ch.karatojava.util.Configuration;
import java.awt.Point;
import java.util.ArrayList;

public class SlalomTestCase
extends AbstractTestCase {
    public static final int TURNLEFT = 0;
    public static final int TURNRIGHT = 1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SOUTHWEST = 0;
    public static final int NORTHEAST = 1;
    protected int lastWorldHashCode;
    protected boolean testPassed;
    protected TestCaseInterpreterListener interpreterListener = new TestCaseInterpreterListener();
    protected ArrayList<Point> solutionPath;
    protected Point startPos;
    protected int numOfTrees;
    protected int karaStartDir;
    protected int karaStartPos;
    protected int karaState;
    protected Kara kara;

    public SlalomTestCase() {
        this.constructWorld();
        this.solutionPath = new ArrayList();
        this.karaState = 0;
    }

    protected int getRandomDirection() {
        return Math.random() < 0.5 ? 1 : 0;
    }

    protected int getRandomKaraStartPos() {
        return Math.random() < 0.5 ? 1 : 0;
    }

    @Override
    public InterpreterListener getInterpreterListener() {
        return this.interpreterListener;
    }

    @Override
    public World getInitialWorld() {
        this.exception = null;
        World world = super.getInitialWorld();
        this.interpreterListener.setWorld(world);
        this.computeSolutionPath();
        this.interpreterListener.setSolutionPath(this.solutionPath);
        return world;
    }

    @Override
    public boolean testPassed(World world) {
        if (world.hashCode() != this.lastWorldHashCode) {
            this.testPassed = this.exception == null && this.interpreterListener.testPassed();
            this.lastWorldHashCode = world.hashCode();
        }
        return this.testPassed;
    }

    @Override
    public String causeOfFailure() {
        String string = super.causeOfFailure();
        if (string.equals("")) {
            string = Configuration.getInstance().getString("language/$language/tasks/kara/slalom/causeoffailure");
        }
        return string;
    }

    protected void computeSolutionPath() {
        this.kara = Kara.findKaraInWorld(this.world, "Kara");
        int n = 0;
        this.solutionPath.clear();
        this.solutionPath.add(n++, this.kara.getPosition());
        while (!this.solutionPath.get(0).equals(this.kara.getPosition()) || this.solutionPath.size() <= 1) {
            try {
                if (this.karaState == 0) {
                    if (!this.kara.treeRight() && this.kara.treeLeft()) {
                        this.kara.move();
                        this.solutionPath.add(n++, this.kara.getPosition());
                        this.kara.turnLeft();
                        this.kara.move();
                        this.solutionPath.add(n++, this.kara.getPosition());
                        continue;
                    }
                    if (!this.kara.treeRight() || !this.kara.treeLeft()) continue;
                    this.kara.move();
                    this.solutionPath.add(n++, this.kara.getPosition());
                    this.kara.turnRight();
                    this.kara.move();
                    this.solutionPath.add(n++, this.kara.getPosition());
                    this.karaState = 1;
                    continue;
                }
                if (this.kara.treeRight() && !this.kara.treeLeft()) {
                    this.kara.move();
                    this.solutionPath.add(n++, this.kara.getPosition());
                    this.kara.turnRight();
                    this.kara.move();
                    this.solutionPath.add(n++, this.kara.getPosition());
                    continue;
                }
                if (!this.kara.treeRight() || !this.kara.treeLeft()) continue;
                this.kara.move();
                this.solutionPath.add(n++, this.kara.getPosition());
                this.kara.turnLeft();
                this.kara.move();
                this.solutionPath.add(n++, this.kara.getPosition());
                this.karaState = 0;
            }
            catch (KaraException karaException) {
                System.err.println("Exception while computing solution Path for Slalom");
            }
        }
    }

    void constructWorld() {
    }
}

