/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks.kara;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraException;
import ch.karatojava.kapps.tasks.AbstractTestCase;
import ch.karatojava.kapps.tasks.kara.TestCaseInterpreterListener;
import ch.karatojava.kapps.world.World;
import ch.karatojava.util.Configuration;
import java.awt.Point;
import java.util.ArrayList;

public class FollowwallTestCase
extends AbstractTestCase {
    protected int lastWorldHashCode;
    protected boolean testPassed;
    protected TestCaseInterpreterListener interpreterListener = new TestCaseInterpreterListener();

    @Override
    public InterpreterListener getInterpreterListener() {
        return this.interpreterListener;
    }

    @Override
    public World getInitialWorld() {
        World world = super.getInitialWorld();
        this.interpreterListener.setWorld(world);
        this.interpreterListener.setSolutionPath(this.computeSolutionPath());
        return world;
    }

    @Override
    public boolean testPassed(World world) {
        if (world.hashCode() != this.lastWorldHashCode) {
            this.testPassed = this.exception == null && this.interpreterListener.testPassed();
            this.lastWorldHashCode = world.hashCode();
        }
        return this.testPassed;
    }

    public ArrayList computeSolutionPath() {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Kara kara = Kara.findKaraInWorld(this.world, "Kara");
        int n = 0;
        arrayList.clear();
        arrayList.add(n++, kara.getPosition());
        while (!((Point)arrayList.get(0)).equals(kara.getPosition()) || arrayList.size() <= 1) {
            try {
                if (!kara.treeFront() && kara.treeRight()) {
                    kara.move();
                    arrayList.add(n++, kara.getPosition());
                    continue;
                }
                if (!kara.treeRight()) {
                    kara.turnRight();
                    kara.move();
                    arrayList.add(n++, kara.getPosition());
                    continue;
                }
                if (!kara.treeFront() || !kara.treeRight()) continue;
                kara.turnLeft();
            }
            catch (KaraException karaException) {
                System.err.println("Exception while computing solution Path for Follow-Wall");
            }
        }
        return arrayList;
    }

    @Override
    public String causeOfFailure() {
        String string = super.causeOfFailure();
        if (string.equals("")) {
            string = Configuration.getInstance().getString("language/$language/tasks/kara/followwall/causeoffailure");
        }
        return string;
    }
}

