/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks;

import ch.karatojava.kapps.tasks.TaskControllerInterface;
import ch.karatojava.kapps.tasks.TaskControllerListener;
import ch.karatojava.kapps.tasks.TaskInterface;
import ch.karatojava.kapps.tasks.TestCaseInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TestCasesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String TESTCASE_CLIENT_PROPERTY = "test case";
    protected Icon untestedIcon;
    protected Icon testPassedIcon;
    protected Icon testFailedIcon;
    protected TaskControllerInterface taskController;
    protected TaskInterface task;
    protected JPanel progressPanel;
    protected JLabel[] statusLabels;
    protected JPanel[] testCasePanels;
    protected JButton testButton;
    protected JButton stopButton;
    protected ButtonListener buttonListener;
    protected Runnable testRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                TestCasesPanel.this.taskController.testTask(TestCasesPanel.this.task);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ExceptionActionListener.reportException(JOptionPane.getFrameForComponent(TestCasesPanel.this), "", exception);
            }
        }
    };
    protected TaskControllerListener tcListener = new TaskControllerListener.Adapter(){
        protected int currentTestIndex;
        protected boolean ourTaskStarted;

        @Override
        public void startingTask(TaskInterface taskInterface) {
            boolean bl = this.ourTaskStarted = TestCasesPanel.this.task == taskInterface;
            if (this.ourTaskStarted) {
                TestCasesPanel.this.initializeStatusLabels();
                this.currentTestIndex = 0;
                TestCasesPanel.this.testButton.setEnabled(false);
                TestCasesPanel.this.stopButton.setEnabled(true);
            }
        }

        @Override
        public void startingTestCase(TestCaseInterface testCaseInterface) {
            if (this.ourTaskStarted) {
                ((JButton)TestCasesPanel.this.testCasePanels[this.currentTestIndex].getComponent(2)).setOpaque(false);
                TestCasesPanel.this.testCasePanels[this.currentTestIndex].setOpaque(true);
                TestCasesPanel.this.testCasePanels[this.currentTestIndex].setBackground(Color.yellow);
                TestCasesPanel.this.progressPanel.repaint();
            }
        }

        @Override
        public void finishedTestCase(TestCaseInterface testCaseInterface) {
            if (this.ourTaskStarted) {
                if (testCaseInterface.testPassed(TestCasesPanel.this.taskController.getCurrentWorld())) {
                    TestCasesPanel.this.statusLabels[this.currentTestIndex].setIcon(TestCasesPanel.this.testPassedIcon);
                } else {
                    TestCasesPanel.this.statusLabels[this.currentTestIndex].setIcon(TestCasesPanel.this.testFailedIcon);
                }
                TestCasesPanel.this.testCasePanels[this.currentTestIndex].setOpaque(false);
                TestCasesPanel.this.progressPanel.repaint();
                ++this.currentTestIndex;
            }
        }

        @Override
        public void finishedTask(TaskInterface taskInterface) {
            if (this.ourTaskStarted) {
                TestCasesPanel.this.testButton.setEnabled(true);
                TestCasesPanel.this.stopButton.setEnabled(false);
                if (this.currentTestIndex < taskInterface.numberOfTestCases()) {
                    TestCasesPanel.this.testCasePanels[this.currentTestIndex].setOpaque(false);
                    TestCasesPanel.this.progressPanel.repaint();
                }
            }
        }
    };

    public TestCasesPanel(TaskControllerInterface taskControllerInterface, TaskInterface taskInterface) {
        this.taskController = taskControllerInterface;
        this.task = taskInterface;
        this.buttonListener = new ButtonListener();
        taskControllerInterface.addTcListener(this.tcListener);
        this.createGui();
    }

    protected void createGui() {
        this.untestedIcon = Configuration.getInstance().getImageIcon("icons/tasks/nottested");
        this.testPassedIcon = Configuration.getInstance().getImageIcon("icons/tasks/testpassed");
        this.testFailedIcon = Configuration.getInstance().getImageIcon("icons/tasks/testfailed");
        JPanel jPanel = new JPanel();
        this.testButton = new JButton();
        this.stopButton = new JButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.progressPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        jScrollPane.setViewportView(this.progressPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.testButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.stopButton);
        jPanel.add(Box.createHorizontalGlue());
        this.testButton.setText(Configuration.getInstance().getString("language/$language/tasks/gui/runtestcases"));
        this.testButton.setMargin(new Insets(0, 0, 0, 4));
        this.testButton.setIcon(Configuration.getInstance().getImageIcon("icons/interpretertoolbar/playbutton"));
        this.testButton.addActionListener(this.buttonListener);
        this.testButton.setActionCommand("startTesting");
        this.stopButton.setText(Configuration.getInstance().getString("language/$language/tasks/gui/stoptestcases"));
        this.stopButton.setMargin(new Insets(0, 0, 0, 4));
        this.stopButton.setIcon(Configuration.getInstance().getImageIcon("icons/interpretertoolbar/stopbutton"));
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(this.buttonListener);
        this.stopButton.setActionCommand("stopTesting");
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 1));
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.createProgressPanel();
    }

    protected void createProgressPanel() {
        this.progressPanel.removeAll();
        TestCaseInterface[] testCaseInterfaceArray = this.task.getTestCases();
        this.statusLabels = new JLabel[testCaseInterfaceArray.length];
        this.testCasePanels = new JPanel[testCaseInterfaceArray.length];
        for (int i = 0; i < this.statusLabels.length; ++i) {
            this.statusLabels[i] = new JLabel(this.untestedIcon);
            JButton jButton = new JButton(Configuration.getInstance().getString(testCaseInterfaceArray[i].getNameKey()));
            jButton.putClientProperty(TESTCASE_CLIENT_PROPERTY, new Integer(i));
            jButton.setActionCommand("showTestCaseWorld");
            jButton.addActionListener(this.buttonListener);
            jButton.setOpaque(false);
            this.testCasePanels[i] = new JPanel();
            JPanel jPanel = this.testCasePanels[i];
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.statusLabels[i]);
            jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel.add(jButton);
            jPanel.add(Box.createHorizontalGlue());
            this.progressPanel.add(Box.createVerticalStrut(4));
            this.progressPanel.add(jPanel);
        }
        this.progressPanel.add(Box.createVerticalGlue());
        this.progressPanel.revalidate();
    }

    protected void initializeStatusLabels() {
        for (int i = 0; i < this.statusLabels.length; ++i) {
            this.statusLabels[i].setIcon(this.untestedIcon);
        }
    }

    protected class ButtonListener
    extends ExceptionActionListener {
        protected ButtonListener() {
        }

        public void showTestCaseWorld(ActionEvent actionEvent) throws Exception {
            JButton jButton = (JButton)actionEvent.getSource();
            Integer n = (Integer)jButton.getClientProperty(TestCasesPanel.TESTCASE_CLIENT_PROPERTY);
            TestCaseInterface testCaseInterface = TestCasesPanel.this.task.getTestCase(n);
            TestCasesPanel.this.taskController.showWorld(testCaseInterface.getInitialWorldAsResource());
        }

        public void startTesting(ActionEvent actionEvent) {
            new Thread(TestCasesPanel.this.testRunnable).start();
        }

        public void stopTesting(ActionEvent actionEvent) throws Exception {
            TestCasesPanel.this.taskController.stopTesting();
        }
    }
}

