/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks;

import ch.karatojava.editor.EditorInterface;
import ch.karatojava.editor.EditorIoToolbar;
import ch.karatojava.interpreter.ExceptionHandler;
import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterToolbar;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.kapps.InterpreterFacadeInterface;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.tasks.DefaultTask;
import ch.karatojava.kapps.tasks.DummyTask;
import ch.karatojava.kapps.tasks.ExecutableLoaderInterface;
import ch.karatojava.kapps.tasks.ProgramResource;
import ch.karatojava.kapps.tasks.TaskControllerInterface;
import ch.karatojava.kapps.tasks.TaskControllerListener;
import ch.karatojava.kapps.tasks.TaskInterface;
import ch.karatojava.kapps.tasks.TestCaseInterface;
import ch.karatojava.kapps.tasks.WorldResource;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.kapps.world.editor.WorldView;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import java.util.ArrayList;
import java.util.List;

public class DefaultTaskController
implements TaskControllerInterface {
    protected WorldEditorFacadeInterface worldEditorFacade;
    protected EditorInterface worldEditor;
    protected EditorIoToolbar worldEditorIoToolbar;
    protected ProgramEditorFacadeInterface programEditorFacade;
    protected EditorInterface programEditor;
    protected EditorIoToolbar programEditorIoToolbar;
    protected InterpreterFacadeInterface interpreterFacade;
    protected RunnableInterface interpreter;
    protected InterpreterToolbar interpreterToolbar;
    protected boolean modifyWithoutAskingUser;
    protected boolean stopTestingFlag;
    protected ArrayList<TaskControllerListener> listeners;
    protected TaskInterface[] tasks;
    protected Exception programException;
    protected ExceptionHandler originalExceptionHandler;
    protected ExceptionHandler interpreterExceptionHandler = new ExceptionHandler(){

        @Override
        public void handleException(Exception exception) {
            DefaultTaskController.this.programException = exception;
            DefaultTaskController.this.originalExceptionHandler.handleException(exception);
        }
    };

    public DefaultTaskController() {
        this.listeners = new ArrayList();
    }

    @Override
    public void setFacades(WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface, InterpreterFacadeInterface interpreterFacadeInterface) {
        this.worldEditorFacade = worldEditorFacadeInterface;
        this.worldEditor = worldEditorFacadeInterface.getWorldEditor();
        this.worldEditorIoToolbar = worldEditorFacadeInterface.getWorldEditorIoToolbar();
        this.programEditorFacade = programEditorFacadeInterface;
        this.programEditor = programEditorFacadeInterface.getProgramEditor();
        this.programEditorIoToolbar = programEditorFacadeInterface.getProgramEditorIoToolbar();
        this.interpreterFacade = interpreterFacadeInterface;
        this.interpreter = interpreterFacadeInterface.getInterpreter();
        this.interpreterToolbar = (InterpreterToolbar)interpreterFacadeInterface.getInterpreterToolbar();
        this.originalExceptionHandler = this.interpreter.getExceptionHandler();
    }

    @Override
    public TaskInterface[] getTasks() {
        return this.tasks;
    }

    @Override
    public World getCurrentWorld() {
        return (World)this.worldEditor.getContent();
    }

    public void initialize() {
        List<String> list = Configuration.split(Configuration.getInstance().getString("tasks/$karamodel/list/$language"), ",");
        this.tasks = new TaskInterface[list.size()];
        for (int i = 0; i < this.tasks.length; ++i) {
            String string = list.get(i);
            this.tasks[i] = !"_separator_".equalsIgnoreCase(string) ? new DefaultTask(this, "tasks/$karamodel/" + string) : new DummyTask();
        }
    }

    public boolean initialized() {
        return this.tasks != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testTask(TaskInterface taskInterface) throws Exception {
        if (this.interpreter.getState() != RunnableInterface.State.IDLE) {
            throw new Exception(Configuration.getInstance().getString("language/$language/tasks/gui/donotstartprogram"));
        }
        TestCaseInterface[] testCaseInterfaceArray = taskInterface.getTestCases();
        InterpreterListener interpreterListener = null;
        this.programException = null;
        this.stopTestingFlag = false;
        this.interpreter.setExceptionHandler(this.interpreterExceptionHandler);
        this.interpreterToolbar.disableAllButtons();
        this.interpreterToolbar.stopUpdatingButtonsState();
        WorldView worldView = ((WorldEditor)this.worldEditor).getWorldView();
        try {
            this.fireStartingTask(taskInterface);
            for (int i = 0; i < testCaseInterfaceArray.length && !this.stopTestingFlag; ++i) {
                testCaseInterfaceArray[i].setProgramException(null);
                this.fireStartingTestCase(testCaseInterfaceArray[i]);
                this.worldEditor.setContent(testCaseInterfaceArray[i].getInitialWorld());
                if (worldView.doesWorldFitSize()) {
                    worldView.setZoomFactor(1.0);
                } else {
                    worldView.setZoomFitSize();
                }
                interpreterListener = testCaseInterfaceArray[i].getInterpreterListener();
                if (interpreterListener != null) {
                    this.interpreter.addInterpreterListener(interpreterListener);
                }
                this.interpreter.play();
                if (!this.stopTestingFlag) {
                    RunnableInterface runnableInterface = this.interpreter;
                    synchronized (runnableInterface) {
                        if (this.interpreter.getState() != RunnableInterface.State.IDLE) {
                            this.interpreter.wait();
                        }
                    }
                }
                if (interpreterListener != null) {
                    this.interpreter.removeInterpreterListener(interpreterListener);
                }
                if (this.programException != null) {
                    testCaseInterfaceArray[i].setProgramException(this.programException);
                }
                this.fireFinishedTestCase(testCaseInterfaceArray[i]);
                if (this.stopTestingFlag || this.programException == null && testCaseInterfaceArray[i].testPassed((World)this.worldEditor.getContent())) continue;
                throw new InterpreterException(testCaseInterfaceArray[i].causeOfFailure());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("DefaultTaskController.testTask: InterruptedException should not happen");
        }
        catch (InterpreterException interpreterException) {
            if (this.programException == null) {
                ExceptionActionListener.reportException(KaraGuiFactory.getInstance().getApplicationFrame(), "", interpreterException);
            }
        }
        finally {
            this.interpreterToolbar.resetButtons();
            this.interpreterToolbar.startUpdatingButtonsState();
            if (interpreterListener != null) {
                this.interpreter.removeInterpreterListener(interpreterListener);
            }
            this.interpreter.setExceptionHandler(this.originalExceptionHandler);
            this.fireFinishedTask(taskInterface);
        }
    }

    @Override
    public void stopTesting() throws Exception {
        this.stopTestingFlag = true;
        if (this.interpreter.getState() != RunnableInterface.State.IDLE) {
            this.interpreter.stop();
        }
    }

    @Override
    public void addTcListener(TaskControllerListener taskControllerListener) {
        this.listeners.add(taskControllerListener);
    }

    @Override
    public void removeTcListener(TaskControllerListener taskControllerListener) {
        this.listeners.remove(taskControllerListener);
    }

    public boolean modifyWithoutAskingUser() {
        return this.modifyWithoutAskingUser;
    }

    public void setModifyWithoutAskingUser(boolean bl) {
        this.modifyWithoutAskingUser = bl;
    }

    protected void loadIntoEditor(EditorInterface editorInterface, EditorIoToolbar editorIoToolbar, String string, Object object, String string2) throws Exception {
        if (this.interpreter.getState() == RunnableInterface.State.IDLE) {
            if (this.modifyWithoutAskingUser || editorIoToolbar.canChangeContent()) {
                if (string != null) {
                    editorInterface.load(this.getClass().getResourceAsStream(string));
                } else {
                    editorInterface.setContent(object);
                }
            }
        } else {
            throw new Exception(Configuration.getInstance().getString(string2));
        }
    }

    @Override
    public void showProgram(ProgramResource programResource) throws Exception {
        String string = Configuration.getInstance().getString(programResource.getProgramKey());
        this.loadIntoEditor(this.programEditor, this.programEditorIoToolbar, string, null, "language/$language/tasks/gui/donotshowprogram");
        String string2 = programResource.getExecutableFilePath();
        if (!string2.equals("") && this.programEditor instanceof ExecutableLoaderInterface) {
            ((ExecutableLoaderInterface)((Object)this.programEditor)).loadExecutable(string2);
        }
        this.programEditorFacade.getProgramEditorGui().setVisible(true);
    }

    @Override
    public void showWorld(WorldResource worldResource) throws Exception {
        if (worldResource.getWorldFile() != null) {
            this.loadIntoEditor(this.worldEditor, this.worldEditorIoToolbar, worldResource.getWorldFile(), null, "language/$language/tasks/gui/donotshowworld");
        } else {
            this.loadIntoEditor(this.worldEditor, this.worldEditorIoToolbar, null, worldResource.getWorld(), "language/$language/tasks/gui/donotshowworld");
        }
    }

    @Override
    public World loadWorld(String string) throws Exception {
        return (World)this.worldEditor.create(this.getClass().getResourceAsStream(string));
    }

    @Override
    public boolean facadesSet() {
        return this.worldEditorFacade != null;
    }

    protected void fireStartingTask(TaskInterface taskInterface) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).startingTask(taskInterface);
        }
    }

    protected void fireStartingTestCase(TestCaseInterface testCaseInterface) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).startingTestCase(testCaseInterface);
        }
    }

    protected void fireFinishedTestCase(TestCaseInterface testCaseInterface) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).finishedTestCase(testCaseInterface);
        }
    }

    protected void fireFinishedTask(TaskInterface taskInterface) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).finishedTask(taskInterface);
        }
    }
}

