/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks;

import ch.karatojava.kapps.tasks.ProgramResource;
import ch.karatojava.kapps.tasks.TaskControllerInterface;
import ch.karatojava.kapps.tasks.TaskInterface;
import ch.karatojava.kapps.tasks.TestCaseInterface;
import ch.karatojava.kapps.tasks.WorldResource;
import ch.karatojava.util.Configuration;
import java.util.List;

public class DefaultTask
implements TaskInterface {
    protected String titleKey;
    protected String textKey;
    protected TestCaseInterface[] testCases;
    protected Class randomTestCaseClass;
    protected TestCaseInterface randomTestCase;
    protected WorldResource[] worldResources;
    protected ProgramResource[] programResources;
    protected int randomTestCount;
    protected Configuration configuration = Configuration.getInstance();
    protected TaskControllerInterface taskController;
    protected String randomTestCaseConfig;

    public DefaultTask(TaskControllerInterface taskControllerInterface, String string) {
        this.taskController = taskControllerInterface;
        string = string + "/";
        this.titleKey = this.configuration.getString(string + "titlekey");
        this.textKey = this.configuration.getString(string + "textkey");
        String string2 = this.configuration.getString(string + "testcasesenabled");
        if (string2.equalsIgnoreCase("yes")) {
            this.initializeWithTestCases(taskControllerInterface, string);
        } else {
            this.initializeWithoutTestCases(taskControllerInterface, string);
        }
        this.initializeProgramResources(taskControllerInterface, string);
    }

    @Override
    public void setRandomTestCount(int n) {
        this.randomTestCount = n;
    }

    @Override
    public int getRandomTestCount() {
        return this.randomTestCount;
    }

    @Override
    public TestCaseInterface[] getTestCases() {
        TestCaseInterface[] testCaseInterfaceArray = new TestCaseInterface[this.testCases.length + this.randomTestCount];
        System.arraycopy(this.testCases, 0, testCaseInterfaceArray, 0, this.testCases.length);
        for (int i = this.testCases.length; i < testCaseInterfaceArray.length; ++i) {
            testCaseInterfaceArray[i] = this.getRandomTestCase();
        }
        return testCaseInterfaceArray;
    }

    @Override
    public TestCaseInterface getTestCase(int n) {
        TestCaseInterface testCaseInterface = n < this.testCases.length ? this.testCases[n] : this.getRandomTestCase();
        return testCaseInterface;
    }

    @Override
    public String getTaskTitleKey() {
        return this.titleKey;
    }

    @Override
    public String getTaskTextKey() {
        return this.textKey;
    }

    @Override
    public TestCaseInterface getRandomTestCase() {
        TestCaseInterface testCaseInterface = null;
        if (this.randomTestCase != null) {
            testCaseInterface = this.randomTestCase;
            try {
                this.randomTestCase = (TestCaseInterface)this.randomTestCaseClass.newInstance();
                this.randomTestCase.initializeFromConfig(this.taskController, this.randomTestCaseConfig);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("DefaultTask.getRandomTestCase: could not create random test case");
            }
        }
        return testCaseInterface;
    }

    @Override
    public WorldResource[] getWorldResources() {
        return this.worldResources;
    }

    @Override
    public ProgramResource[] getProgramResources() {
        return this.programResources;
    }

    @Override
    public int numberOfTestCases() {
        return this.testCases.length + this.randomTestCount;
    }

    protected void initializeWithTestCases(TaskControllerInterface taskControllerInterface, String string) {
        List<String> list = Configuration.split(this.configuration.getString(string + "testcases/list"), ",");
        String string2 = string + "testcases" + "/";
        this.testCases = new TestCaseInterface[list.size()];
        this.worldResources = new WorldResource[list.size()];
        String string3 = null;
        try {
            for (int i = 0; i < this.testCases.length; ++i) {
                string3 = this.configuration.getString(string2 + list.get(i) + "/" + "class");
                this.testCases[i] = (TestCaseInterface)Class.forName(string3).newInstance();
                this.testCases[i].initializeFromConfig(taskControllerInterface, string2 + list.get(i) + "/");
                String string4 = this.configuration.getString(string2 + list.get(i) + "/" + "namekey");
                this.worldResources[i] = new WorldResource(this.testCases[i], string4);
            }
            string3 = this.configuration.getString(string2 + "randomtestcase" + "/" + "class");
            if (!string3.equals("")) {
                this.randomTestCaseClass = Class.forName(string3);
                this.randomTestCase = (TestCaseInterface)this.randomTestCaseClass.newInstance();
                this.randomTestCaseConfig = string2 + "randomtestcase" + "/";
                this.randomTestCase.initializeFromConfig(taskControllerInterface, this.randomTestCaseConfig);
                this.randomTestCount = Configuration.getInstance().getInt(string2 + "randomtestcase/count");
            } else {
                this.randomTestCount = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("DefaultTask.initializeWithTestCases: could not create test case for class " + string3 + "\n" + "exception was " + exception);
        }
    }

    protected void initializeWithoutTestCases(TaskControllerInterface taskControllerInterface, String string) {
        this.randomTestCount = 0;
        this.testCases = new TestCaseInterface[0];
        List<String> list = Configuration.split(this.configuration.getString(string + "worlds/list"), ",");
        String string2 = string + "worlds" + "/";
        this.worldResources = new WorldResource[list.size()];
        for (int i = 0; i < this.worldResources.length; ++i) {
            String string3 = this.configuration.getString(string2 + list.get(i) + "/" + "namekey");
            String string4 = this.configuration.getString(string2 + list.get(i) + "/" + "file");
            this.worldResources[i] = new WorldResource(string4, string3);
        }
    }

    protected void initializeProgramResources(TaskControllerInterface taskControllerInterface, String string) {
        List<String> list = Configuration.split(this.configuration.getString(string + "programs/list"), ",");
        String string2 = string + "programs" + "/";
        this.programResources = new ProgramResource[list.size()];
        for (int i = 0; i < this.programResources.length; ++i) {
            String string3 = this.configuration.getString(string2 + list.get(i) + "/" + "textkey");
            String string4 = this.configuration.getString(string2 + list.get(i) + "/" + "filekey");
            String string5 = this.configuration.getString(string2 + list.get(i) + "/" + "namekey");
            String string6 = this.configuration.getString(string2 + list.get(i) + "/" + "executable");
            this.programResources[i] = new ProgramResource(string4, string3, string5, string6);
        }
    }
}

