/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide.worldobjects;

import ch.karatojava.kapps.world.WorldObject;
import ch.karatojava.kapps.world.WorldObjectInterface;

public class STREET
extends WorldObject {
    private int streetType;
    private static final int MIN_STREET_TYPE = 1;
    private static final int MAX_STREET_TYPE = 15;
    private static final STREET[] STREETS = new STREET[16];

    private STREET(int n) {
        assert (STREETS[n] == null) : "STREET.STREET: type " + n + " already created";
        this.type = 16;
        this.streetType = n;
        STREET.STREETS[n] = this;
    }

    public static boolean isValidStreetType(int n) {
        return n >= 1 && n <= 15;
    }

    public static STREET getInstance(int n) {
        assert (STREET.isValidStreetType(n)) : "STREET.getInstance: wrong streetType " + n;
        if (STREETS[n] == null) {
            STREET.STREETS[n] = new STREET(n);
        }
        return STREETS[n];
    }

    public int getStreetType() {
        return this.streetType;
    }

    @Override
    public WorldObjectInterface mergeWith(WorldObjectInterface worldObjectInterface) {
        assert (worldObjectInterface.getType() == 16) : "STREET.mergeWith: worldObject has wrong type";
        int n = (this.streetType ^ ((STREET)worldObjectInterface).getStreetType()) % 16;
        return STREETS[n];
    }

    @Override
    public boolean canCombineWith(WorldObjectInterface worldObjectInterface) {
        return true;
    }

    @Override
    public boolean equals(WorldObjectInterface worldObjectInterface) {
        return worldObjectInterface != null && worldObjectInterface.getType() == this.getType() && ((STREET)worldObjectInterface).getStreetType() == this.streetType;
    }

    @Override
    public WorldObjectInterface detach(WorldObjectInterface worldObjectInterface) {
        assert (worldObjectInterface.getType() == 16) : "STREET.detach: worldObject has wrong type";
        int n = (this.streetType & (((STREET)worldObjectInterface).getStreetType() ^ 0xF)) % 16;
        return STREETS[n];
    }

    @Override
    public WorldObjectInterface cloneWorldObject() {
        return this;
    }

    public String toString() {
        return "S" + this.streetType;
    }
}

