/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide.worldio;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.worldio.XmlKara;
import ch.karatojava.kapps.karaide.worldio.XmlKaraList;
import ch.karatojava.kapps.karaide.worldio.XmlMeetingroom;
import ch.karatojava.kapps.karaide.worldio.XmlMeetingroomList;
import ch.karatojava.kapps.karaide.worldio.XmlMonitor;
import ch.karatojava.kapps.karaide.worldio.XmlMonitorList;
import ch.karatojava.kapps.karaide.worldio.XmlObstaclePoints;
import ch.karatojava.kapps.karaide.worldio.XmlPaintedfieldPoints;
import ch.karatojava.kapps.karaide.worldio.XmlPoint;
import ch.karatojava.kapps.karaide.worldio.XmlStreet;
import ch.karatojava.kapps.karaide.worldio.XmlStreetList;
import ch.karatojava.kapps.karaide.worldio.XmlWallPoints;
import ch.karatojava.kapps.karaide.worldio.XmlWorld;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.multikaraide.MultiKaraScheduler;
import ch.karatojava.kapps.multikaraide.worldobjects.STREET;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldField;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.kapps.world.editor.io.WorldOutputterInterface;
import ch.karatojava.util.Configuration;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;

public class MultiKaraWorldOutputter
implements WorldOutputterInterface {
    private static MultiKaraWorldOutputter instance;
    public static String version;
    private MultiKaraScheduler scheduler;

    protected MultiKaraWorldOutputter() {
    }

    public static WorldOutputterInterface getInstance() {
        if (instance == null) {
            instance = new MultiKaraWorldOutputter();
        }
        return instance;
    }

    public void setScheduler(MultiKaraScheduler multiKaraScheduler) {
        this.scheduler = multiKaraScheduler;
    }

    @Override
    public void outputWorld(World world, OutputStream outputStream) throws Exception {
        WorldField worldField;
        String string = (String)this.scheduler.getClientProperty("startingorderforsaving");
        String string2 = (String)this.scheduler.getClientProperty("prioritiesforsaving");
        String string3 = (String)this.scheduler.getClientProperty("parkingorderforsaging");
        XmlWorld xmlWorld = new XmlWorld();
        xmlWorld.setSizex(world.getSizeX());
        xmlWorld.setSizey(world.getSizeY());
        xmlWorld.setVersion(version);
        XmlPaintedfieldPoints xmlPaintedfieldPoints = new XmlPaintedfieldPoints();
        XmlWallPoints xmlWallPoints = new XmlWallPoints();
        XmlObstaclePoints xmlObstaclePoints = new XmlObstaclePoints();
        XmlStreetList xmlStreetList = new XmlStreetList();
        XmlMeetingroomList xmlMeetingroomList = new XmlMeetingroomList();
        XmlMonitorList xmlMonitorList = new XmlMonitorList();
        XmlKaraList xmlKaraList = new XmlKaraList();
        List<WorldField> list = world.getObjectFieldsVector();
        for (int i = 0; i < list.size(); ++i) {
            worldField = list.get(i);
            WorldObjectInterface[] worldObjectInterfaceArray = worldField.getStack();
            for (int j = 0; j < worldObjectInterfaceArray.length; ++j) {
                Object object;
                WorldObjectInterface worldObjectInterface = worldObjectInterfaceArray[j];
                if (worldObjectInterface == null) continue;
                int n = worldObjectInterface.getType();
                if (n == 1) {
                    object = new XmlPoint();
                    ((XmlPoint)object).setX(worldField.getX());
                    ((XmlPoint)object).setY(worldField.getY());
                    xmlWallPoints.getXmlPoint().add((XmlPoint)object);
                    continue;
                }
                if (n == 4) {
                    object = new XmlPoint();
                    ((XmlPoint)object).setX(worldField.getX());
                    ((XmlPoint)object).setY(worldField.getY());
                    xmlObstaclePoints.getXmlPoint().add((XmlPoint)object);
                    continue;
                }
                if (n == 2) {
                    object = new XmlPoint();
                    ((XmlPoint)object).setX(worldField.getX());
                    ((XmlPoint)object).setY(worldField.getY());
                    ((XmlPoint)object).setType(((LEAF)worldObjectInterface).getLeafType());
                    xmlPaintedfieldPoints.getXmlPoint().add((XmlPoint)object);
                    continue;
                }
                if (n == 16) {
                    object = new XmlStreet();
                    ((XmlStreet)object).setX(worldField.getX());
                    ((XmlStreet)object).setY(worldField.getY());
                    ((XmlStreet)object).setType(((STREET)worldObjectInterface).getStreetType());
                    xmlStreetList.getXmlStreet().add((XmlStreet)object);
                    continue;
                }
                if (n == 10) {
                    object = new XmlMeetingroom();
                    ((XmlMeetingroom)object).setX(worldField.getX());
                    ((XmlMeetingroom)object).setY(worldField.getY());
                    xmlMeetingroomList.getXmlMeetingroom().add((XmlMeetingroom)object);
                    continue;
                }
                if (n == 11) {
                    object = new XmlMonitor();
                    ((XmlMonitor)object).setX(worldField.getX());
                    ((XmlMonitor)object).setY(worldField.getY());
                    xmlMonitorList.getXmlMonitor().add((XmlMonitor)object);
                    continue;
                }
                if (n != 8) continue;
                object = new XmlKara();
                ((XmlKara)object).setX(worldField.getX());
                ((XmlKara)object).setY(worldField.getY());
                ((XmlKara)object).setName(((Kara)worldObjectInterface).getIdentity());
                ((XmlKara)object).setDirection(((Kara)worldObjectInterface).getDirection());
                xmlKaraList.getXmlKara().add((XmlKara)object);
            }
        }
        if (string != null) {
            xmlKaraList.setStartingOrder(string);
        }
        if (string2 != null) {
            xmlKaraList.setPriorities(string2);
        }
        if (string3 != null) {
            xmlKaraList.setParkingOrder(string3);
        }
        xmlWorld.setXmlPaintedfieldPoints(xmlPaintedfieldPoints);
        xmlWorld.setXmlObstaclePoints(xmlObstaclePoints);
        xmlWorld.setXmlKaraList(xmlKaraList);
        xmlWorld.setXmlStreetList(xmlStreetList);
        xmlWorld.getXmlMeetingroomList().add(xmlMeetingroomList);
        xmlWorld.getXmlMonitorList().add(xmlMonitorList);
        xmlWorld.setXmlWallPoints(xmlWallPoints);
        JAXBContext jAXBContext = JAXBContext.newInstance((String)"ch.karatojava.kapps.multikaraide.worldio");
        worldField = jAXBContext.createMarshaller();
        worldField.setProperty("jaxb.formatted.output", Boolean.TRUE);
        worldField.marshal(xmlWorld, outputStream);
    }

    static {
        version = "KaraX 1.0 " + Configuration.getInstance().getString("karamodel/$karamodel/savefiletype");
    }
}

