/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide.worldio;

import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.kapps.karaide.worldio.WorldBuilder;
import ch.karatojava.kapps.karaide.worldio.XmlMeetingroom;
import ch.karatojava.kapps.karaide.worldio.XmlMonitor;
import ch.karatojava.kapps.karaide.worldio.XmlStreet;
import ch.karatojava.kapps.karaide.worldio.XmlWorld;
import ch.karatojava.kapps.multikaraide.MultiKaraScheduler;
import ch.karatojava.kapps.multikaraide.worldio.MultiKaraWorldOutputter;
import ch.karatojava.kapps.multikaraide.worldobjects.MEETINGROOMFIELD;
import ch.karatojava.kapps.multikaraide.worldobjects.MONITORFIELD;
import ch.karatojava.kapps.multikaraide.worldobjects.STREET;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldInternalException;
import ch.karatojava.kapps.world.editor.io.WorldBuilderInterface;
import ch.karatojava.util.Configuration;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class MultiKaraWorldBuilder
extends WorldBuilder
implements WorldBuilderInterface {
    private static MultiKaraWorldBuilder instance;
    private MultiKaraScheduler scheduler;

    protected MultiKaraWorldBuilder() {
    }

    public static WorldBuilderInterface getInstance() {
        if (instance == null) {
            instance = new MultiKaraWorldBuilder();
        }
        return instance;
    }

    public void setScheduler(MultiKaraScheduler multiKaraScheduler) {
        this.scheduler = multiKaraScheduler;
    }

    @Override
    public World buildWorld(InputStream inputStream) throws Exception {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"ch.karatojava.kapps.karaide.worldio");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            XmlWorld xmlWorld = (XmlWorld)unmarshaller.unmarshal(inputStream);
            String string = xmlWorld.getVersion();
            if (!string.equalsIgnoreCase(MultiKaraWorldOutputter.version)) {
                String[] stringArray = new String[]{string, MultiKaraWorldOutputter.version};
                throw new WorldInternalException("language/$language/iomessages/wrongversion", stringArray);
            }
            World world = new World(xmlWorld.getSizex(), xmlWorld.getSizey());
            this.addKaras(world, xmlWorld.getXmlKaraList().getXmlKara());
            this.addMushrooms(world, xmlWorld.getXmlObstaclePoints().getXmlPoint());
            this.addLeafs(world, xmlWorld.getXmlPaintedfieldPoints().getXmlPoint());
            this.addTrees(world, xmlWorld.getXmlWallPoints().getXmlPoint());
            this.addStreets(world, xmlWorld.getXmlStreetList().getXmlStreet());
            if (xmlWorld.getXmlMeetingroomList().size() > 0) {
                this.addMeetingrooms(world, xmlWorld.getXmlMeetingroomList().get(0).getXmlMeetingroom());
            }
            if (xmlWorld.getXmlMonitorList().size() > 0) {
                this.addMonitors(world, xmlWorld.getXmlMonitorList().get(0).getXmlMonitor());
            }
            this.setStartingOrder(world, xmlWorld.getXmlKaraList().getStartingOrder());
            this.setPriorities(world, xmlWorld.getXmlKaraList().getPriorities());
            this.setParkingOrder(world, xmlWorld.getXmlKaraList().getParkingOrder());
            return world;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            String string2 = MessageFormat.format(Configuration.getInstance().getString("language/$language/iomessages/error"), string);
            exception.printStackTrace();
            throw new Exception(string2);
        }
    }

    protected void setStartingOrder(World world, String string) {
        if (string == null || this.scheduler == null) {
            return;
        }
        List<String> list = Configuration.split(string, ",");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (KaraActorKonfig.getInstance().getKaraActor(string2) != null) continue;
            throw new WorldInternalException("language/$language/iomessages/wrongstartingorder");
        }
        this.scheduler.setClientProperty("startingorder", string);
    }

    protected void setPriorities(World world, String string) throws Exception {
        int n;
        if (string == null || this.scheduler == null) {
            return;
        }
        List<String> list = Configuration.split((String)this.scheduler.getClientProperty("startingorderforsaving"), ",");
        List<String> list2 = Configuration.split(string, ",");
        int n2 = 0;
        for (n = 0; n < list2.size(); ++n) {
            int n3 = Integer.parseInt(list2.get(n));
            if (n3 < 0) {
                throw new Exception("Priority value less than 0!");
            }
            n2 += n3;
        }
        if (n2 > 16) {
            throw new Exception("Sum of Priorities > 16");
        }
        for (n = 0; n < list.size(); ++n) {
            this.scheduler.setStepperPriority(list.get(n), Integer.parseInt(list2.get(n)));
        }
    }

    protected void setParkingOrder(World world, String string) {
        this.scheduler.setClientProperty("clearkaraparking", "");
        if (string == null || this.scheduler == null) {
            return;
        }
        List<String> list = Configuration.split(string, ",");
        String string2 = "";
        for (int i = 0; i < list.size(); ++i) {
            if ("-".equals(list.get(i))) continue;
            string2 = list.get(i) + "," + new Integer(i).toString();
            this.scheduler.setClientProperty("puttospecifiedkaraparking", string2);
        }
    }

    protected void addStreets(World world, List list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            XmlStreet xmlStreet = (XmlStreet)list.get(i);
            int n = xmlStreet.getX();
            int n2 = xmlStreet.getY();
            int n3 = xmlStreet.getType();
            this.checkCoordinate(world, n, n2);
            this.checkStreetType(n3);
            if (!world.canPutObjectAt(STREET.getInstance(n3), n, n2)) {
                throw new Exception("Invalid street / other object combination.");
            }
            world.putObjectAt(STREET.getInstance(xmlStreet.getType()), n, n2);
        }
    }

    protected void checkStreetType(int n) throws Exception {
        if (!STREET.isValidStreetType(n)) {
            throw new Exception("Invalid street type (" + n + ")");
        }
    }

    protected void addMeetingrooms(World world, List list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            XmlMeetingroom xmlMeetingroom = (XmlMeetingroom)list.get(i);
            int n = xmlMeetingroom.getX();
            int n2 = xmlMeetingroom.getY();
            this.checkCoordinate(world, n, n2);
            if (!world.canPutObjectAt(MEETINGROOMFIELD.getInstance(), n, n2)) {
                throw new Exception("Invalid meetingroom / other object combination.");
            }
            world.putObjectAt(MEETINGROOMFIELD.getInstance(), n, n2);
        }
    }

    protected void addMonitors(World world, List list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            XmlMonitor xmlMonitor = (XmlMonitor)list.get(i);
            int n = xmlMonitor.getX();
            int n2 = xmlMonitor.getY();
            this.checkCoordinate(world, n, n2);
            if (!world.canPutObjectAt(MONITORFIELD.getInstance(), n, n2)) {
                throw new Exception("Invalid monitor / other object combination.");
            }
            world.putObjectAt(MONITORFIELD.getInstance().cloneWorldObject(), n, n2);
        }
    }
}

