/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.kapps.actorfsm.ActorTypeInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.editor.ActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.SingleActorFsmEditor;
import ch.karatojava.kapps.actorfsm.editor.fsmdiagrameditor.StateDialog;
import ch.karatojava.kapps.multikaraide.MultiKaraProgramEditorFacade;
import ch.karatojava.kapps.multikaraide.MultiKaraSensorToolboxDialog;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.dndpanel.DndPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MultiKaraStateDialog
extends StateDialog {
    private static final long serialVersionUID = 1L;
    protected MultiKaraProgramEditorFacade programFacade;
    protected StateDialog.TrashButton libraryViewTrash;
    protected MultiKaraSensorToolboxDialog toolbox;

    public MultiKaraStateDialog(Frame frame, String string, ActorTypeInterface actorTypeInterface, MultiKaraProgramEditorFacade multiKaraProgramEditorFacade) {
        super(frame, string, actorTypeInterface);
        this.programFacade = multiKaraProgramEditorFacade;
        this.toolbox = new MultiKaraSensorToolboxDialog(this);
    }

    public MultiKaraStateDialog(Frame frame, String string, ActorTypeInterface actorTypeInterface) {
        super(frame, string, actorTypeInterface);
    }

    @Override
    public void show(StateMachine stateMachine) {
        this.resetLibraryView();
        super.show(stateMachine);
    }

    @Override
    public void show(State state) {
        this.resetLibraryView();
        super.show(state);
    }

    public void addSensor(SensorTypeInterface sensorTypeInterface) {
        this.actor.addSensorTypeInterface(sensorTypeInterface);
        this.resetLibraryView();
    }

    @Override
    public void resetLibraryView() {
        this.createSensors();
        this.libraryView.resetSensors();
        this.libraryScrollPane.setViewportView(this.libraryView);
        this.libraryScrollPane.validate();
        this.libraryScrollPane.getVerticalScrollBar().setValue(this.libraryScrollPane.getVerticalScrollBar().getMaximum());
        this.libraryViewTrash.setParent(this.libraryView);
        this.mainPanel.addThisMouseInputListener(this.libraryView);
    }

    @Override
    protected DndPanel createMainPanel() {
        this.mainPanel = new DndPanel();
        this.mainPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        this.selectedSensorView = new StateDialog.SelectedSensorsView(this);
        this.sensorViewTrash = new StateDialog.TrashButton(this.selectedSensorView);
        this.selectedScrollPane = new JScrollPane(this.selectedSensorView);
        this.selectedScrollPane.setPreferredSize(new Dimension(150, 150));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.sensorViewTrash);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/sensordialog/usedsensortitle"), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        jPanel2.add(this.selectedScrollPane);
        jPanel2.add(jPanel);
        this.libraryView = new MultiKaraLibraryView((StateDialog)this);
        this.libraryScrollPane = new JScrollPane(this.libraryView);
        this.libraryViewTrash = new StateDialog.TrashButton(this.libraryView);
        this.libraryViewTrash.setAlignmentX(1.0f);
        JButton jButton = new JButton(Configuration.getInstance().getString("language/$language/multikara/createsensorbutton"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiKaraStateDialog.this.openToolbox();
            }
        });
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.libraryViewTrash);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/sensordialog/librarytitle"), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        jPanel3.add(this.libraryScrollPane);
        jPanel3.add(jPanel);
        this.mainPanel.add(jPanel2);
        this.mainPanel.add(jPanel3);
        this.mainPanel.addThisMouseInputListenerToChildren();
        return this.mainPanel;
    }

    protected void openToolbox() {
        this.toolbox.setLocationRelativeTo(this);
        this.toolbox.setVisible(true);
    }

    protected void removeSensor(SensorTypeInterface sensorTypeInterface) {
        ActorFsmEditor actorFsmEditor = (ActorFsmEditor)this.programFacade.getProgramEditor();
        SingleActorFsmEditor[] singleActorFsmEditorArray = actorFsmEditor.getSingleActorFsmEditors();
        if (this.checkRemoveSensor(sensorTypeInterface, singleActorFsmEditorArray)) {
            for (int i = 0; i < singleActorFsmEditorArray.length; ++i) {
                State[] stateArray = singleActorFsmEditorArray[i].getStateMachine().getStates();
                for (int j = 0; j < stateArray.length; ++j) {
                    if (!stateArray[j].usesSensor(sensorTypeInterface)) continue;
                    stateArray[j].removeSensor(sensorTypeInterface);
                }
            }
            this.actor.removeSensorTypeInterface(sensorTypeInterface);
            this.selectedSensors.remove(sensorTypeInterface);
        }
    }

    protected boolean checkRemoveSensor(SensorTypeInterface sensorTypeInterface, SingleActorFsmEditor[] singleActorFsmEditorArray) {
        int n;
        for (n = 0; n < singleActorFsmEditorArray.length; ++n) {
            State[] stateArray = singleActorFsmEditorArray[n].getStateMachine().getStates();
            for (int i = 0; i < stateArray.length; ++i) {
                if (!stateArray[i].usesSensor(sensorTypeInterface)) continue;
                int n2 = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this), Configuration.getInstance().getString("language/$language/multikara/sensorinuse"), Configuration.getInstance().getString("language/$language/multikara/deletetitle"), 0);
                return n2 == 0;
            }
        }
        n = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this), Configuration.getInstance().getString("language/$language/multikara/sensordelete"), Configuration.getInstance().getString("language/$language/multikara/deletetitle"), 0);
        return n == 0;
    }

    protected class MultiKaraLibraryView
    extends StateDialog.LibraryView {
        private static final long serialVersionUID = 1L;

        public MultiKaraLibraryView(StateDialog stateDialog) {
            super(stateDialog);
        }

        @Override
        public void sensorTrashed(SensorTypeInterface sensorTypeInterface) {
            MultiKaraStateDialog.this.removeSensor(sensorTypeInterface);
            MultiKaraStateDialog.this.resetView();
        }
    }
}

