/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.kapps.multikaraide.MultiKaraObjectsViewComponent;
import ch.karatojava.kapps.multikaraide.MultiKaraSensorViewComponent;
import ch.karatojava.kapps.multikaraide.MultiKaraStateDialog;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.dndpanel.DndPanel;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class MultiKaraSensorToolboxDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected JTabbedPane tabbedPane;
    protected MultiKaraSensorViewComponent sensorViewComponent;
    protected JTextField descriptionText = new JTextField();
    protected MultiKaraStateDialog dad;
    protected static final int WORLDSENSORINDEX = 0;

    public MultiKaraSensorToolboxDialog(MultiKaraStateDialog multiKaraStateDialog, boolean bl) {
        super((Dialog)multiKaraStateDialog, bl);
    }

    public MultiKaraSensorToolboxDialog(MultiKaraStateDialog multiKaraStateDialog) {
        super((Dialog)multiKaraStateDialog, true);
        this.setTitle(Configuration.getInstance().getString("language/$language/actorfsm/editor/sensordialog/sensortoolboxtitle"));
        this.setSize(310, 400);
        this.setResizable(false);
        this.dad = multiKaraStateDialog;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(Configuration.getInstance().getString("language/$language/multikara/worldsensortitle"), this.createWorldSensorPanel());
        GuiFactory.getInstance().addUiSwitchListener(this);
        this.getContentPane().add(this.tabbedPane);
    }

    @Override
    public void setVisible(boolean bl) {
        this.descriptionText.setText("");
        this.sensorViewComponent.reset();
        super.setVisible(bl);
    }

    protected JPanel createWorldSensorPanel() {
        ExceptionActionListener exceptionActionListener = new ExceptionActionListener(){

            @Override
            public void action(ActionEvent actionEvent) throws Exception {
                MultiKaraSensorToolboxDialog.this.doneWorldSensor();
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 25));
        jPanel.add((Component)this.createSensorNorthPanel(0), "North");
        jPanel.add((Component)this.createWorldSensorCenterPanel(), "Center");
        jPanel.add((Component)this.createButtonPanel(exceptionActionListener), "South");
        return jPanel;
    }

    protected JPanel createSensorNorthPanel(int n) {
        JLabel jLabel = new JLabel(Configuration.getInstance().getString("language/$language/actorfsm/editor/sensordialog/sensornamelabel"));
        this.descriptionText = new JTextField(20);
        this.descriptionText.setBackground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.descriptionText);
        return jPanel;
    }

    protected DndPanel createWorldSensorCenterPanel() {
        this.sensorViewComponent = new MultiKaraSensorViewComponent();
        TrashButton trashButton = new TrashButton(this.sensorViewComponent);
        trashButton.setBorder(BorderFactory.createEmptyBorder(GuiFactory.BUTTON_MARGIN.top, GuiFactory.BUTTON_MARGIN.left, GuiFactory.BUTTON_MARGIN.bottom, GuiFactory.BUTTON_MARGIN.right));
        trashButton.setAlignmentX(1.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/sensordialog/sensor"));
        jPanel.add(this.sensorViewComponent);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(trashButton);
        DndPanel dndPanel = new DndPanel();
        dndPanel.setLayout(new BoxLayout(dndPanel, 0));
        dndPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        dndPanel.add(jPanel);
        dndPanel.add(new MultiKaraObjectsViewComponent());
        dndPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        dndPanel.addThisMouseInputListenerToChildren();
        return dndPanel;
    }

    protected JPanel createButtonPanel(ExceptionActionListener exceptionActionListener) {
        JButton jButton = GuiFactory.getInstance().createImageIconButton("icons/ok");
        jButton.addActionListener(exceptionActionListener);
        JButton jButton2 = GuiFactory.getInstance().createImageIconButton("icons/cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiKaraSensorToolboxDialog.this.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    protected void doneWorldSensor() throws Exception {
        this.dad.addSensor(this.sensorViewComponent.getSensor(this.descriptionText.getText()));
        this.setVisible(false);
    }

    protected class TrashButton
    extends JLabel
    implements LightweightDragDrop {
        private static final long serialVersionUID = 1L;
        protected MultiKaraSensorViewComponent sensorComponent;

        public TrashButton(MultiKaraSensorViewComponent multiKaraSensorViewComponent) {
            super(GuiFactory.getInstance().createImageIcon("icons/trashcan"));
            this.sensorComponent = multiKaraSensorViewComponent;
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            return null;
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            return null;
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            return this.sensorComponent.getDragOrigin() != -1;
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
        }
    }
}

