/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.kapps.actorfsm.SensorFactoryInterface;
import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.worldobjects.EMPTY;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.karaide.worldobjects.MUSHROOM;
import ch.karatojava.kapps.karaide.worldobjects.TREE;
import ch.karatojava.kapps.multikaraide.MultiKaraExtendedWorldSensor;
import ch.karatojava.kapps.multikaraide.worldobjects.STREET;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;

public class MultiKaraSensorFactory
implements SensorFactoryInterface {
    public BufferedImage neutralActorImage;
    private BufferedImage dontCareImage;
    public final int DONTCAREINDEX = 17;
    private static final String WORLDSENSOR_METHOD_NAME = "extendedWorldSensor";
    private static final String WORLDSENSOR_OLD_METHOD_NAME = "extendedSensor";
    private static MultiKaraSensorFactory instance;
    private Kara neutralKara;

    private MultiKaraSensorFactory() {
        this.resetImages();
    }

    @Override
    public boolean areParametersValid(String string, String string2, String string3, String string4) {
        if (string2.equals(WORLDSENSOR_OLD_METHOD_NAME)) {
            string2 = WORLDSENSOR_METHOD_NAME;
        }
        if (string2.equals(WORLDSENSOR_METHOD_NAME)) {
            List<String> list = Configuration.split(string4, ",");
            if (list.size() % 4 != 0) {
                return false;
            }
            for (int i = 0; i < list.size(); i += 4) {
                int[] nArray = new int[4];
                for (int j = 0; j < 4; ++j) {
                    try {
                        String string5 = list.get(i + j);
                        nArray[j] = Integer.parseInt(string5);
                        continue;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                if (nArray[1] < 0 || nArray[1] > 1 || nArray[0] < -1 || nArray[0] > 1) {
                    return false;
                }
                if (!(nArray[2] == 16 ? !STREET.isValidStreetType(nArray[3]) : (nArray[2] == 2 ? !LEAF.isValidLeafType(nArray[3]) : nArray[2] != 4 && nArray[2] != 1 && nArray[2] != 0 && nArray[2] != 8))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public SensorTypeInterface createSensor(String string, String string2, String string3, String string4) {
        return this.createWorldSensor(string, WORLDSENSOR_METHOD_NAME, string3, string4);
    }

    public SensorTypeInterface createWorldSensor(String string, String string2) {
        String string3 = Configuration.getInstance().getString(string);
        MultiKaraExtendedWorldSensor multiKaraExtendedWorldSensor = new MultiKaraExtendedWorldSensor(WORLDSENSOR_METHOD_NAME, string3);
        this.fillSensorValues(multiKaraExtendedWorldSensor, string2);
        multiKaraExtendedWorldSensor.setIcon(this.createImage(multiKaraExtendedWorldSensor));
        multiKaraExtendedWorldSensor.setAttribute("paramString", string2);
        multiKaraExtendedWorldSensor.setAttribute("descPath", string);
        return multiKaraExtendedWorldSensor;
    }

    public SensorTypeInterface createWorldSensor(WorldObjectInterface[] worldObjectInterfaceArray, String string) {
        String string2 = this.createWorldSensorParameterString(worldObjectInterfaceArray);
        MultiKaraExtendedWorldSensor multiKaraExtendedWorldSensor = new MultiKaraExtendedWorldSensor(WORLDSENSOR_METHOD_NAME, string);
        this.fillSensorValues(multiKaraExtendedWorldSensor, string2);
        multiKaraExtendedWorldSensor.setIcon(this.createImage(multiKaraExtendedWorldSensor));
        multiKaraExtendedWorldSensor.setAttribute("paramString", string2);
        multiKaraExtendedWorldSensor.setIdentifier("" + System.currentTimeMillis());
        return multiKaraExtendedWorldSensor;
    }

    private void resetImages() {
        this.createNeutralActorImage();
        this.createDontCareImage();
    }

    private SensorTypeInterface createWorldSensor(String string, String string2, String string3, String string4) {
        MultiKaraExtendedWorldSensor multiKaraExtendedWorldSensor = new MultiKaraExtendedWorldSensor(WORLDSENSOR_METHOD_NAME, string3);
        this.fillSensorValues(multiKaraExtendedWorldSensor, string4);
        multiKaraExtendedWorldSensor.setIcon(this.createImage(multiKaraExtendedWorldSensor));
        multiKaraExtendedWorldSensor.setAttribute("paramString", string4);
        multiKaraExtendedWorldSensor.setIdentifier(string);
        return multiKaraExtendedWorldSensor;
    }

    public BufferedImage getEmptyFieldImage() {
        BufferedImage bufferedImage = new BufferedImage(30, 30, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(new Color(170, 170, 170));
        graphics.drawRect(0, 0, 29, 29);
        return bufferedImage;
    }

    private void createDontCareImage() {
        this.dontCareImage = new BufferedImage(29, 29, 6);
        Graphics2D graphics2D = (Graphics2D)this.dontCareImage.getGraphics();
        graphics2D.setColor(new Color(170, 170, 170));
        graphics2D.drawLine(0, 0, 28, 28);
        graphics2D.drawLine(0, 28, 28, 0);
    }

    public BufferedImage getDontCareImage() {
        return this.dontCareImage;
    }

    public Kara getNeutralKara() {
        if (this.neutralKara == null) {
            this.neutralKara = (Kara)Kara.getKaras()[0].cloneWorldObject();
            this.neutralKara.setClientProperty("imageicon", GuiFactory.getInstance().createImageIcon("schemes/ladybugscheme/neutralbug"));
        }
        return this.neutralKara;
    }

    private void createNeutralActorImage() {
        this.neutralActorImage = new BufferedImage(28, 28, 6);
        Graphics2D graphics2D = (Graphics2D)this.neutralActorImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(0.5, 0.5);
        int n = 15;
        graphics2D.drawImage(Configuration.getInstance().getImage("schemes/ladybugscheme/neutralbug"), n, n, null);
        if (this.getNeutralKara() != null) {
            this.getNeutralKara().setClientProperty("imageicon", Configuration.getInstance().getImageIcon("schemes/ladybugscheme/neutralbug"));
        }
    }

    private void fillSensorValues(MultiKaraExtendedWorldSensor multiKaraExtendedWorldSensor, String string) {
        List<String> list = Configuration.split(string, ",");
        assert (list.size() % 4 == 0) : "MultiKaraSensorFactory.createParameterAndFields: paramString has wrong format:\n" + string;
        for (int i = 0; i < list.size(); i += 4) {
            int[] nArray = new int[4];
            for (int j = 0; j < 4; ++j) {
                try {
                    String string2 = list.get(i + j);
                    nArray[j] = Integer.parseInt(string2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            int n = nArray[1] == 1 ? 3 : 1 + nArray[0];
            if (nArray[2] == 16) {
                multiKaraExtendedWorldSensor.setField(n, STREET.getInstance(nArray[3]));
                continue;
            }
            if (nArray[2] == 2) {
                multiKaraExtendedWorldSensor.setField(n, LEAF.getInstance(nArray[3]));
                continue;
            }
            if (nArray[2] == 4) {
                multiKaraExtendedWorldSensor.setField(n, MUSHROOM.getInstance());
                continue;
            }
            if (nArray[2] == 1) {
                multiKaraExtendedWorldSensor.setField(n, TREE.getInstance());
                continue;
            }
            if (nArray[2] == 0) {
                multiKaraExtendedWorldSensor.setField(n, EMPTY.getInstance());
                continue;
            }
            if (nArray[2] != 8) continue;
            multiKaraExtendedWorldSensor.setField(n, this.getNeutralKara());
        }
    }

    private String createWorldSensorParameterString(WorldObjectInterface[] worldObjectInterfaceArray) {
        String string = "";
        for (int i = 0; i < 4; ++i) {
            if (worldObjectInterfaceArray[i] == null) continue;
            int n = 0;
            int n2 = MultiKaraExtendedWorldSensor.getRelativeXCoord(i);
            int n3 = MultiKaraExtendedWorldSensor.getRelativeYCoord(i);
            if (worldObjectInterfaceArray[i].getType() == 16) {
                n = ((STREET)worldObjectInterfaceArray[i]).getStreetType();
            } else if (worldObjectInterfaceArray[i].getType() == 2) {
                n = ((LEAF)worldObjectInterfaceArray[i]).getLeafType();
            }
            string = string + n2 + "," + n3 + "," + worldObjectInterfaceArray[i].getType() + "," + n + ",";
        }
        if (string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private ImageIcon createImage(MultiKaraExtendedWorldSensor multiKaraExtendedWorldSensor) {
        Image image;
        int n = 43;
        int n2 = 29;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(0.5, 0.5);
        graphics2D.setColor(new Color(170, 170, 170));
        graphics2D.drawRect(28, 0, 28, 56);
        graphics2D.drawRect(0, 28, 84, 28);
        for (int i = 0; i < 4; ++i) {
            int n3 = MultiKaraExtendedWorldSensor.getImageXCoord(i);
            int n4 = MultiKaraExtendedWorldSensor.getImageYCoord(i);
            int n5 = n3 * 28;
            int n6 = n4 * 28;
            if (multiKaraExtendedWorldSensor.getWorldObject(i) == null) {
                graphics2D.setColor(new Color(170, 170, 170));
                graphics2D.drawLine(n5 + 1, n6 + 1, n5 + 1 + 28, n6 + 1 + 28);
                graphics2D.drawLine(n5 + 1, n6 + 1 + 28, n5 + 1 + 28, n6);
                continue;
            }
            if (multiKaraExtendedWorldSensor.getWorldObject(i).getType() == 0) continue;
            image = ((ImageIcon)multiKaraExtendedWorldSensor.getWorldObject(i).getClientProperty("imageicon")).getImage();
            graphics2D.drawImage(image, n5, n6, null);
        }
        image = Toolkit.getDefaultToolkit().createImage(this.neutralActorImage.getSource());
        graphics2D.drawImage(image, 28, 28, 28, 28, null);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static MultiKaraSensorFactory getInstance() {
        if (instance == null) {
            instance = new MultiKaraSensorFactory();
        }
        return instance;
    }
}

