/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.kapps.Konstants;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.multikaraide.MultiKaraSchedulerView;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.kapps.world.editor.WorldView;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import ch.karatojava.util.gui.rieditor.DynamicLineBorder;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

class MultiKaraSchedulerViewKaraParkPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ImageIcon[] karapark;
    private MultiKaraSchedulerView dad;
    protected ArrayList<ParkingPanel> parkingPanels = new ArrayList();

    protected MultiKaraSchedulerViewKaraParkPanel(MultiKaraSchedulerView multiKaraSchedulerView) {
        JPanel jPanel;
        this.dad = multiKaraSchedulerView;
        this.setLayout(new BoxLayout(this, 1));
        Kara[] karaArray = Kara.getKaras();
        this.karapark = new ImageIcon[karaArray.length];
        for (int i = 0; i < karaArray.length; ++i) {
            this.karapark[i] = Configuration.getInstance().getImageIcon(Konstants.SCHEDULER_KARA_PARK_ICONS[i]);
            jPanel = new ParkingPanel(multiKaraSchedulerView, null, this.karapark[i]);
            this.parkingPanels.add((ParkingPanel)jPanel);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.parkingPanels.get(0));
        jPanel2.add(this.parkingPanels.get(1));
        jPanel = new JPanel();
        jPanel.setBorder(new DynamicLineBorder(WorldView.WORLD_GRID_COLOR, 1, 0, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(new Dimension(1, 28)));
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.parkingPanels.get(2));
        jPanel3.add(this.parkingPanels.get(3));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new DynamicLineBorder(WorldView.WORLD_GRID_COLOR, 1, 0, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createRigidArea(new Dimension(1, 28)));
        jPanel3.add(jPanel4);
        this.add(jPanel2);
        this.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new DynamicLineBorder(WorldView.WORLD_GRID_COLOR, 1, 0, 2));
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(Box.createRigidArea(new Dimension(57, 1)));
        this.add(jPanel5);
    }

    public void putToParking(String string) {
        boolean bl = false;
        for (int i = 0; i < Kara.getKaras().length; ++i) {
            if (this.parkingPanels.get(i).getKara() != null || bl) continue;
            this.parkingPanels.get(i).changeKara(string);
            bl = true;
        }
    }

    public void putToParking(String string, int n) {
        this.parkingPanels.get(n).changeKara(string);
    }

    public void clearParking() {
        for (int i = 0; i < this.parkingPanels.size(); ++i) {
            this.parkingPanels.get(i).changeKara("");
        }
    }

    public void removeFromParking(String string) {
        for (int i = 0; i < Kara.getKaras().length; ++i) {
            if (this.parkingPanels.get(i).getKara() != Kara.getKara(string)) continue;
            this.parkingPanels.get(i).changeKara("");
        }
    }

    private void karaParkingChanged() {
        String string = "";
        for (int i = 0; i < this.parkingPanels.size(); ++i) {
            Kara kara = this.parkingPanels.get(i).getKara();
            String string2 = "-";
            if (kara != null) {
                string2 = kara.getIdentity();
            }
            string = string + string2 + ",";
        }
        this.dad.karaParkingChanged(string);
    }

    private class ParkingPanel
    extends JPanel
    implements LightweightDragDrop {
        private static final long serialVersionUID = 1L;
        private Kara kara;
        private MultiKaraSchedulerView dad1;
        private WorldObjectInterface dragObject;
        private ImageIcon parkingImageIcon;

        public ParkingPanel(MultiKaraSchedulerView multiKaraSchedulerView, Kara kara, ImageIcon imageIcon) {
            this.dad1 = multiKaraSchedulerView;
            this.kara = kara;
            this.parkingImageIcon = imageIcon;
            this.dragObject = kara;
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createRigidArea(new Dimension(28, 28)));
        }

        protected void changeKara(String string) {
            this.kara = Kara.getKara(string);
            this.dragObject = this.kara;
            MultiKaraSchedulerViewKaraParkPanel.this.karaParkingChanged();
            this.repaint();
        }

        protected Kara getKara() {
            return this.kara;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(WorldView.WORLD_GRID_COLOR);
            graphics.drawLine(0, 0, 28, 0);
            graphics.drawLine(0, 0, 0, 28);
            BufferedImage bufferedImage = new BufferedImage(28, 28, 6);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
            graphics2D.drawImage(this.parkingImageIcon.getImage(), 0, 0, null);
            graphics2D.dispose();
            graphics.drawImage(bufferedImage, 0, 0, this);
            if (this.kara != null) {
                graphics.drawImage(GuiFactory.getInstance().createImageIcon(this.kara.getKaraImageKeys()[0]).getImage(), 0, 0, null);
            }
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            BufferedImage bufferedImage = new BufferedImage(28, 28, 6);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawImage(GuiFactory.getInstance().createImageIcon(this.kara.getKaraImageKeys()[0]).getImage(), 0, 0, null);
            graphics2D.dispose();
            return bufferedImage;
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            if (!this.dad1.acceptDragging) {
                ExceptionActionListener.reportException(this.dad1.getComponent(), Configuration.getInstance().getString("language/$language/multikara/dontmodifytitle"), new Exception(Configuration.getInstance().getString("language/$language/multikara/dontmodify")));
            }
            if (this.dad1.acceptDragging && this.kara != null) {
                this.dad1.dragObjectFrom = "Kara Parking Panel";
                this.dad1.requestFocus();
                return this.dragObject;
            }
            return null;
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
            Kara[] karaArray = Kara.getKaras();
            for (int i = 0; i < karaArray.length; ++i) {
                if (object != karaArray[i]) continue;
                this.changeKara(karaArray[i].getIdentity());
                this.dad1.dragObjectTo = "Kara Parking Panel";
            }
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
            if (bl && (this.dad1.dragObjectTo.equals("Kara Priority Panel") || this.dad1.dragObjectTo.equals("Kara Parking Panel"))) {
                this.changeKara("");
            }
            this.dad1.dragObjectFrom = "";
            this.dad1.dragObjectTo = "";
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            boolean bl = false;
            Kara[] karaArray = Kara.getKaras();
            for (int i = 0; i < karaArray.length; ++i) {
                if (object != karaArray[i]) continue;
                bl = true;
            }
            return bl && this.kara == null;
        }
    }
}

