/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.SchedulerListener;
import ch.karatojava.kapps.Konstants;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.multikaraide.MultiKaraScheduler;
import ch.karatojava.kapps.multikaraide.MultiKaraSchedulerViewKaraParkPanel;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import ch.karatojava.util.gui.rieditor.DynamicLineBorder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class MultiKaraSchedulerView
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Color ACTIVE_BORDER = new Color(102, 102, 153);
    public static final Color INACTIVE_BORDER = new Color(180, 200, 180);
    public static final Color SLEEP_BACKGROUND_COLOR = new Color(208, 208, 208);
    public static final int NUMBER_OF_PRIORITY_SLOTS = 16;
    public static final int SPACE_RIGHT_SIDE_FOR_MARKER = 3;
    public static final int PRIORITY_PANEL_HEIGHT = 33;
    public static final int PRIORITY_PANEL_TOP_SPACE = 10;
    public static final int SNAP_PANEL_HEIGHT = 10;
    public static final String KARA_PARK_PANEL = "Kara Parking Panel";
    public static final String KARA_PRIORITY_PANEL = "Kara Priority Panel";
    protected String dragObjectFrom = "";
    protected String dragObjectTo = "";
    protected ArrayList<PriorityPanel> priorityPanels = new ArrayList();
    protected PriorityPanel emptyPriorityPanel = null;
    protected JPanel main = new JPanel();
    protected MultiKaraSchedulerViewPrioritySnapPanel snapperPanel = new MultiKaraSchedulerViewPrioritySnapPanel();
    protected MultiKaraSchedulerViewKaraParkPanel karaParkPanel = null;
    protected PriorityPanel activePanel = null;
    protected boolean acceptDragging = true;
    private MultiKaraScheduler scheduler;
    private Hashtable<String, PriorityPanel> priorityPanelHashtable;
    private SchedulerListener schedulerListener = new SchedulerListener.Adapter(){

        @Override
        public void processPutToSleep(Object object) {
            ((PriorityPanel)MultiKaraSchedulerView.this.priorityPanelHashtable.get(object)).setPutToSleep();
        }

        @Override
        public void processWakeUp(Object object) {
            ((PriorityPanel)MultiKaraSchedulerView.this.priorityPanelHashtable.get(object)).setWakeUp();
        }

        @Override
        public void processTerminated(Object object) {
            MultiKaraSchedulerView.this.scheduler.setStepperPriority(object, 0);
            MultiKaraSchedulerView.this.karaParkPanel.putToParking((String)object);
        }

        @Override
        public void processActivated(Object object) {
            ((PriorityPanel)MultiKaraSchedulerView.this.priorityPanelHashtable.get(object)).setActivated();
        }

        @Override
        public void processDeactivated(Object object) {
            ((PriorityPanel)MultiKaraSchedulerView.this.priorityPanelHashtable.get(object)).setDeactivated();
        }

        @Override
        public void processPriorityChanged(Object object, int n) {
            ((PriorityPanel)MultiKaraSchedulerView.this.priorityPanelHashtable.get(object)).setPriority(n);
            MultiKaraSchedulerView.this.resetMainPanel();
        }

        @Override
        public void processClientPropertySet(Object object, Object object2) {
            int n;
            Kara[] karaArray;
            if (((String)object).equals("startingorder")) {
                karaArray = Configuration.split((String)object2, ",");
                for (n = 0; n < karaArray.size(); ++n) {
                    MultiKaraSchedulerView.this.scheduler.putActorToLastVisiblePosition(karaArray.get(n));
                }
            }
            if (((String)object).equals("clearkaraparking")) {
                MultiKaraSchedulerView.this.karaParkPanel.clearParking();
            }
            if (((String)object).equals("puttokaraparking")) {
                MultiKaraSchedulerView.this.karaParkPanel.putToParking((String)object2);
            }
            if (((String)object).equals("puttospecifiedkaraparking")) {
                karaArray = Configuration.split((String)object2, ",");
                MultiKaraSchedulerView.this.karaParkPanel.putToParking((String)karaArray.get(0), new Integer((String)karaArray.get(1)));
            }
            if (((String)object).equals("savepriorities")) {
                karaArray = Kara.getKaras();
                for (n = 0; n < karaArray.length; ++n) {
                    ((PriorityPanel)MultiKaraSchedulerView.this.priorityPanelHashtable.get(karaArray[n].getIdentity())).savePriorities();
                }
            }
            if (((String)object).equals("resetprioritypanel")) {
                karaArray = Kara.getKaras();
                for (n = 0; n < karaArray.length; ++n) {
                    ((PriorityPanel)MultiKaraSchedulerView.this.priorityPanelHashtable.get(karaArray[n].getIdentity())).resetPriorityAfterStopped();
                }
            }
        }
    };
    private InterpreterListener interpreterListener = new InterpreterListenerAdapter(){

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            MultiKaraSchedulerView.this.disallowDragging();
        }

        @Override
        public void playing(RunnableInterface runnableInterface) {
        }

        @Override
        public void pausing(RunnableInterface runnableInterface) {
        }

        @Override
        public void stepped(RunnableInterface runnableInterface) {
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
            Kara[] karaArray = Kara.getKaras();
            for (int i = 0; i < karaArray.length; ++i) {
                MultiKaraSchedulerView.this.priorityPanels.get(i).resetPriorityAfterStopped();
                MultiKaraSchedulerView.this.priorityPanels.get(i).setNormal();
            }
            MultiKaraSchedulerView.this.allowDragging();
            MultiKaraSchedulerView.this.activePanel = null;
        }

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            this.stopped(runnableInterface);
        }
    };

    public MultiKaraSchedulerView() {
        Kara[] karaArray = Kara.getKaras();
        this.priorityPanelHashtable = new Hashtable();
        int n = 16;
        for (int i = 0; i < karaArray.length; ++i) {
            PriorityPanel priorityPanel = new PriorityPanel(this, karaArray[i], 2);
            GuiFactory.getInstance().addUiSwitchListener(priorityPanel);
            n -= priorityPanel.getPriority();
            this.priorityPanels.add(priorityPanel);
            this.priorityPanelHashtable.put(karaArray[i].getIdentity(), priorityPanel);
        }
        this.emptyPriorityPanel = new PriorityPanel(this, null, n);
        this.setupPanel();
    }

    protected Component getComponent() {
        return this;
    }

    public void setScheduler(MultiKaraScheduler multiKaraScheduler) {
        this.scheduler = multiKaraScheduler;
        multiKaraScheduler.addListener(this.schedulerListener);
        multiKaraScheduler.clearVisibleOrder();
    }

    public InterpreterListener getInterpreterListener() {
        return this.interpreterListener;
    }

    private void disallowDragging() {
        this.acceptDragging = false;
    }

    private void allowDragging() {
        this.acceptDragging = true;
    }

    private void resetMainPanel() {
        this.main.removeAll();
        this.main.setLayout(new BoxLayout(this.main, 0));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new DynamicLineBorder(ACTIVE_BORDER, 1, 0, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(new Dimension(1, 33)));
        this.main.add(jPanel);
        int n = 16;
        for (int i = 0; i < this.priorityPanels.size(); ++i) {
            PriorityPanel priorityPanel = this.priorityPanels.get(i);
            if (this.scheduler != null) {
                priorityPanel = this.priorityPanels.get(this.scheduler.getIndexOfVisiblePosition(i));
            }
            n -= priorityPanel.getPriority();
            if (priorityPanel.getPriority() <= 0) continue;
            this.main.add(priorityPanel);
        }
        this.emptyPriorityPanel.setPriority(n);
        this.main.add(this.emptyPriorityPanel);
        if (n == 16) {
            jPanel.setBorder(new DynamicLineBorder(INACTIVE_BORDER, 1, 0, 1));
        }
        this.revalidate();
        this.snapperPanel.repaint();
    }

    protected void setupPanel() {
        this.setLayout(new FlowLayout(1, 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.resetMainPanel();
        jPanel4.add(this.main);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(Box.createRigidArea(new Dimension(3, 33)));
        jPanel4.add(jPanel5);
        jPanel2.add(jPanel4);
        jPanel2.add(this.snapperPanel);
        jPanel.add(jPanel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.add(jPanel6);
        this.karaParkPanel = new MultiKaraSchedulerViewKaraParkPanel(this);
        jPanel.add(this.karaParkPanel);
        this.add(jPanel);
    }

    protected void karaParkingChanged(String string) {
        this.scheduler.setParkingOrderForSaving(string);
    }

    private class MultiKaraSchedulerViewPrioritySnapPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public final int SNAPPER_DRAGGABLE_RANGE = 10;
        public final int SNAPPER_ICON_POSITION_TOP = 2;
        private int snapper_drag_startpos = 0;
        private String snapper_drag_karaname = "";
        private int snapper_drag_value = 0;
        private boolean snapper_dragging = false;
        private int snapper_priorities_sum = 0;
        private ArrayList<ImageIcon> snapperIcons;
        private MouseInputAdapter snapperChangeListener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Kara[] karaArray = Kara.getKaras();
                int n = 0;
                for (int i = 0; i < karaArray.length; ++i) {
                    int n2 = MultiKaraSchedulerView.this.scheduler.getStepperPriority(karaArray[MultiKaraSchedulerView.this.scheduler.getIndexOfVisiblePosition(i)].getIdentity());
                    if (n2 <= 0 || mouseEvent.getY() < 2 || mouseEvent.getY() >= 2 + ((ImageIcon)MultiKaraSchedulerViewPrioritySnapPanel.this.snapperIcons.get(MultiKaraSchedulerView.this.scheduler.getIndexOfVisiblePosition(i))).getIconHeight() || mouseEvent.getX() < (n += n2) * 28 - 10 || mouseEvent.getX() > n * 28 + 10) continue;
                    MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_dragging = true;
                    MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_startpos = mouseEvent.getX();
                    MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_value = n2;
                    MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_karaname = karaArray[MultiKaraSchedulerView.this.scheduler.getIndexOfVisiblePosition(i)].getIdentity();
                }
                MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_priorities_sum = n;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_dragging) {
                    MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_dragging = false;
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (MultiKaraSchedulerView.this.scheduler.getStepperPriority(MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_karaname) == 0) {
                    this.mouseReleased(mouseEvent);
                }
                int n = 0;
                int n2 = 0;
                int n3 = MultiKaraSchedulerView.this.scheduler.getStepperPriority(MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_karaname);
                if (MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_dragging) {
                    n = (int)Math.round((double)(mouseEvent.getX() - MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_startpos) / 28.0);
                    n2 = Math.max(MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_value + n, 1);
                    if (MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_priorities_sum + n > 16) {
                        n2 = MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_value + (16 - MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_priorities_sum);
                    }
                    if (n2 != n3) {
                        MultiKaraSchedulerView.this.scheduler.setStepperPriority(MultiKaraSchedulerViewPrioritySnapPanel.this.snapper_drag_karaname, n2);
                    }
                }
            }
        };

        protected MultiKaraSchedulerViewPrioritySnapPanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createRigidArea(new Dimension(452, 10)));
            this.snapperIcons = new ArrayList();
            Kara[] karaArray = Kara.getKaras();
            for (int i = 0; i < karaArray.length; ++i) {
                this.snapperIcons.add(Configuration.getInstance().getImageIcon(Konstants.SCHEDULER_PRIORITY_SNAPPER_ICONS[i]));
            }
            this.addMouseListener(this.snapperChangeListener);
            this.addMouseMotionListener(this.snapperChangeListener);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(ACTIVE_BORDER);
            for (int i = 0; i <= 16; ++i) {
                graphics.drawLine(i * 28, 4, i * 28, 7);
            }
            Kara[] karaArray = Kara.getKaras();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < karaArray.length; ++i) {
                n2 = MultiKaraSchedulerView.this.scheduler.getStepperPriority(karaArray[MultiKaraSchedulerView.this.scheduler.getIndexOfVisiblePosition(i)].getIdentity());
                n += n2;
                if (n2 <= 0) continue;
                graphics.drawImage(this.snapperIcons.get(MultiKaraSchedulerView.this.scheduler.getIndexOfVisiblePosition(i)).getImage(), n * 28 - this.snapperIcons.get(MultiKaraSchedulerView.this.scheduler.getIndexOfVisiblePosition(i)).getIconWidth() / 2, 2, null);
            }
        }
    }

    private class PriorityPanel
    extends JPanel
    implements LightweightDragDrop {
        private static final long serialVersionUID = 1L;
        private Kara kara;
        private int priority;
        private int priorityBeforeTerminating = 0;
        private MultiKaraSchedulerView dad;
        private ImageIcon icon;
        private WorldObjectInterface dragObject;
        private JLabel actorLabel;

        public PriorityPanel(MultiKaraSchedulerView multiKaraSchedulerView2, Kara kara, int n) {
            this.dad = multiKaraSchedulerView2;
            this.kara = kara;
            this.priority = n;
            this.dragObject = kara;
            if (kara != null) {
                this.icon = GuiFactory.getInstance().createImageIcon(kara.getKaraImageKeys()[0]);
                this.shiftLeftIcon();
                this.actorLabel = new JLabel(this.icon);
                Dimension dimension = new Dimension(28, 33);
                this.actorLabel.setSize(dimension);
                this.actorLabel.setMinimumSize(dimension);
                this.actorLabel.setMaximumSize(dimension);
                this.setBorder(new DynamicLineBorder(ACTIVE_BORDER, 1, 0, 14));
            } else {
                this.setBorder(new DynamicLineBorder(INACTIVE_BORDER, 1, 0, 14));
            }
            this.setLayout(new BoxLayout(this, 0));
            this.updatePriorityPanel();
        }

        private void updatePriorityPanel() {
            this.removeAll();
            if (this.kara != null) {
                if (this.priority > 1) {
                    this.add(Box.createRigidArea(new Dimension((this.priority - 1) * 28 / 2, 33)));
                }
                this.add(this.actorLabel);
                if (this.priority > 1) {
                    this.add(Box.createRigidArea(new Dimension((this.priority - 1) * 28 / 2, 33)));
                }
            } else {
                this.add(Box.createRigidArea(new Dimension(this.priority * 28, 33)));
            }
        }

        public synchronized void setPriority(int n) {
            this.priority = n;
            this.updatePriorityPanel();
        }

        public void setNormal() {
            this.actorLabel.setIcon(this.icon);
        }

        public void resetPriorityAfterStopped() {
            if (this.priorityBeforeTerminating > 0) {
                this.dad.karaParkPanel.removeFromParking(this.kara.getIdentity());
                MultiKaraSchedulerView.this.scheduler.setStepperPriority(this.kara.getIdentity(), this.priorityBeforeTerminating);
                this.priorityBeforeTerminating = 0;
            }
        }

        public void savePriorities() {
            this.priorityBeforeTerminating = this.priority;
        }

        public void setPutToSleep() {
            BufferedImage bufferedImage = new BufferedImage(28, 28, 6);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
            graphics2D.drawImage(this.icon.getImage(), 0, 0, null);
            graphics2D.dispose();
            this.actorLabel.setIcon(new ImageIcon(bufferedImage));
            this.setBackground(SLEEP_BACKGROUND_COLOR);
        }

        public void setWakeUp() {
            this.actorLabel.setIcon(this.icon);
            this.setBackground(null);
        }

        public int getPriority() {
            return this.priority;
        }

        public Kara getKara() {
            return this.kara;
        }

        public String getIdentity() {
            return this.kara.getIdentity();
        }

        public void setActivated() {
            this.setBackground(Color.yellow);
        }

        public void setDeactivated() {
            this.setBackground(null);
        }

        private void shiftLeftIcon() {
            BufferedImage bufferedImage = new BufferedImage(28, 28, 6);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawImage(this.icon.getImage(), -1, -1, null);
            graphics2D.dispose();
            this.icon.setImage(bufferedImage);
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            BufferedImage bufferedImage = new BufferedImage(28, 28, 6);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawImage(this.icon.getImage(), 0, 0, null);
            graphics2D.dispose();
            return bufferedImage;
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            Component component = this.getComponentAt(mouseEvent.getX(), mouseEvent.getY());
            if (!this.dad.acceptDragging) {
                ExceptionActionListener.reportException(this.dad.getComponent(), Configuration.getInstance().getString("language/$language/multikara/dontmodifytitle"), new Exception(Configuration.getInstance().getString("language/$language/multikara/dontmodify")));
            }
            if (this.dad.acceptDragging && component instanceof JLabel && this.kara != null) {
                this.dad.requestFocus();
                this.dad.dragObjectFrom = MultiKaraSchedulerView.KARA_PRIORITY_PANEL;
                return this.dragObject;
            }
            return null;
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
            int n;
            Kara[] karaArray = Kara.getKaras();
            if (this.dad.dragObjectFrom.equals(MultiKaraSchedulerView.KARA_PRIORITY_PANEL)) {
                for (n = 0; n < karaArray.length && !karaArray[MultiKaraSchedulerView.this.scheduler.getIndexOfVisiblePosition(n)].equals(this.kara); ++n) {
                }
                MultiKaraSchedulerView.this.scheduler.putActorToVisiblePosition(((Kara)object).getIdentity(), n);
                this.dad.dragObjectTo = MultiKaraSchedulerView.KARA_PRIORITY_PANEL;
                MultiKaraSchedulerView.this.resetMainPanel();
            }
            if (this.dad.dragObjectFrom.equals(MultiKaraSchedulerView.KARA_PARK_PANEL)) {
                if (this.kara == null) {
                    for (n = 0; n < karaArray.length; ++n) {
                        if (object != karaArray[n]) continue;
                        MultiKaraSchedulerView.this.scheduler.putActorToLastVisiblePosition(karaArray[n].getIdentity());
                        MultiKaraSchedulerView.this.scheduler.setStepperPriority(karaArray[n].getIdentity(), 1);
                        this.dad.dragObjectTo = MultiKaraSchedulerView.KARA_PRIORITY_PANEL;
                    }
                } else {
                    for (n = 0; n < karaArray.length && !karaArray[n].equals(this.kara); ++n) {
                    }
                    MultiKaraSchedulerView.this.scheduler.putActorToVisiblePosition(((Kara)object).getIdentity(), n);
                    MultiKaraSchedulerView.this.scheduler.setStepperPriority(((Kara)object).getIdentity(), 1);
                    this.dad.dragObjectTo = MultiKaraSchedulerView.KARA_PRIORITY_PANEL;
                    MultiKaraSchedulerView.this.resetMainPanel();
                }
            }
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
            if (bl && this.dad.dragObjectTo.equals(MultiKaraSchedulerView.KARA_PARK_PANEL)) {
                MultiKaraSchedulerView.this.scheduler.setStepperPriority(this.kara.getIdentity(), 0);
            }
            this.dad.dragObjectFrom = "";
            this.dad.dragObjectTo = "";
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            if (this.dad.dragObjectFrom.equals(MultiKaraSchedulerView.KARA_PARK_PANEL)) {
                if (this.kara == null) {
                    return true;
                }
                Kara[] karaArray = Kara.getKaras();
                int n = 0;
                for (int i = 0; i < karaArray.length; ++i) {
                    n += MultiKaraSchedulerView.this.scheduler.getStepperPriority(karaArray[i].getIdentity());
                }
                if (n < 16) {
                    return true;
                }
            }
            return this.dad.dragObjectFrom.equals(MultiKaraSchedulerView.KARA_PRIORITY_PANEL);
        }
    }
}

