/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.InterpreterToolbar;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.StepableInterpreter;
import ch.karatojava.interpreter.ToolbarUiFactoryInterface;
import ch.karatojava.kapps.Konstants;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.multikaraide.MultiKaraScheduler;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class MultiKaraInterpreterToolbar
extends InterpreterToolbar {
    private static final long serialVersionUID = 1L;
    protected MultiKaraScheduler multiKaraScheduler;
    protected boolean stepModeManual = false;
    protected JPanel manualStepPanel = new JPanel();
    protected JButton stepButtonYellow;
    protected JButton stepButtonRed;
    protected JButton stepButtonViolet;
    protected JButton stepButtonBlue;
    protected String nameYellow;
    protected String nameRed;
    protected String nameViolet;
    protected String nameBlue;

    public MultiKaraInterpreterToolbar(ToolbarUiFactoryInterface toolbarUiFactoryInterface, RunnableInterface runnableInterface) {
        super(toolbarUiFactoryInterface, runnableInterface);
        this.manualStepPanel.setLayout(new BoxLayout(this.manualStepPanel, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ImageIcon imageIcon = GuiFactory.getInstance().createImageIcon(Konstants.MULTIKARA_MANUALSTEP_ICONS[0]);
        this.nameYellow = Kara.getKaras()[0].getIdentity();
        this.stepButtonYellow = new JButton(imageIcon);
        this.stepButtonYellow.setEnabled(false);
        GuiFactory.getInstance().createButtonUI(this.stepButtonYellow, 2, 2, 2, 2, false);
        this.stepButtonYellow.addActionListener(new ExceptionActionListener(this, "stepYellow"));
        GuiFactory.getInstance().addUiSwitchListener(this.stepButtonYellow);
        jPanel.add(this.stepButtonYellow);
        imageIcon = GuiFactory.getInstance().createImageIcon(Konstants.MULTIKARA_MANUALSTEP_ICONS[1]);
        this.nameRed = Kara.getKaras()[1].getIdentity();
        this.stepButtonRed = new JButton(imageIcon);
        this.stepButtonRed.setEnabled(false);
        GuiFactory.getInstance().createButtonUI(this.stepButtonRed, 2, 2, 2, 2, false);
        this.stepButtonRed.addActionListener(new ExceptionActionListener(this, "stepRed"));
        GuiFactory.getInstance().addUiSwitchListener(this.stepButtonRed);
        jPanel.add(this.stepButtonRed);
        this.manualStepPanel.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        imageIcon = GuiFactory.getInstance().createImageIcon(Konstants.MULTIKARA_MANUALSTEP_ICONS[3]);
        this.nameBlue = Kara.getKaras()[3].getIdentity();
        this.stepButtonBlue = new JButton(imageIcon);
        this.stepButtonBlue.setEnabled(false);
        GuiFactory.getInstance().createButtonUI(this.stepButtonBlue, 2, 2, 2, 2, false);
        this.stepButtonBlue.addActionListener(new ExceptionActionListener(this, "stepBlue"));
        GuiFactory.getInstance().addUiSwitchListener(this.stepButtonBlue);
        jPanel.add(this.stepButtonBlue);
        imageIcon = GuiFactory.getInstance().createImageIcon(Konstants.MULTIKARA_MANUALSTEP_ICONS[2]);
        this.nameViolet = Kara.getKaras()[2].getIdentity();
        this.stepButtonViolet = new JButton(imageIcon);
        this.stepButtonViolet.setEnabled(false);
        GuiFactory.getInstance().createButtonUI(this.stepButtonViolet, 2, 2, 2, 2, false);
        this.stepButtonViolet.addActionListener(new ExceptionActionListener(this, "stepViolet"));
        GuiFactory.getInstance().addUiSwitchListener(this.stepButtonViolet);
        jPanel.add(this.stepButtonViolet);
        this.manualStepPanel.add(jPanel);
    }

    @Override
    protected InterpreterToolbar.ToolbarInterpreterListener createNewToolbarInterpreterListener() {
        return new MultiKaraToolbarInterpreterListener();
    }

    public void setMultiKaraScheduler(MultiKaraScheduler multiKaraScheduler) {
        this.multiKaraScheduler = multiKaraScheduler;
    }

    public MultiKaraScheduler getMultiKaraScheduler() {
        return this.multiKaraScheduler;
    }

    public void setCompositeStepModeToManual(boolean bl) {
        if (this.stepModeManual != bl) {
            if (bl) {
                this.buttons.add((Component)this.manualStepPanel, 0);
            } else {
                this.buttons.remove(this.manualStepPanel);
            }
            this.stepModeManual = bl;
            this.buttons.revalidate();
        }
    }

    public boolean isCompositeStepModeManual() {
        return this.stepModeManual;
    }

    @Override
    public void disableAllButtons() {
        super.disableAllButtons();
        this.stepButtonYellow.setEnabled(false);
        this.stepButtonRed.setEnabled(false);
        this.stepButtonViolet.setEnabled(false);
        this.stepButtonBlue.setEnabled(false);
    }

    @Override
    protected void disablePlayButtons() {
        super.disablePlayButtons();
        this.stepButtonYellow.setEnabled(false);
        this.stepButtonRed.setEnabled(false);
        this.stepButtonViolet.setEnabled(false);
        this.stepButtonBlue.setEnabled(false);
    }

    public void stepYellow() throws InterpreterException {
        if (this.multiKaraScheduler.runningActorIsReady(this.nameYellow)) {
            this.multiKaraScheduler.setNextActorTo(this.nameYellow);
            ((StepableInterpreter)this.interpreter).step();
        }
    }

    public void stepRed() throws InterpreterException {
        if (this.multiKaraScheduler.runningActorIsReady(this.nameRed)) {
            this.multiKaraScheduler.setNextActorTo(this.nameRed);
            ((StepableInterpreter)this.interpreter).step();
        }
    }

    public void stepViolet() throws InterpreterException {
        if (this.multiKaraScheduler.runningActorIsReady(this.nameViolet)) {
            this.multiKaraScheduler.setNextActorTo(this.nameViolet);
            ((StepableInterpreter)this.interpreter).step();
        }
    }

    public void stepBlue() throws InterpreterException {
        if (this.multiKaraScheduler.runningActorIsReady(this.nameBlue)) {
            this.multiKaraScheduler.setNextActorTo(this.nameBlue);
            ((StepableInterpreter)this.interpreter).step();
        }
    }

    protected class MultiKaraToolbarInterpreterListener
    extends InterpreterToolbar.ToolbarInterpreterListener {
        private void enableKaraIfActiveAndNotSleeping(String string, JButton jButton) {
            if (MultiKaraInterpreterToolbar.this.multiKaraScheduler.isKaraRunning(string) && !MultiKaraInterpreterToolbar.this.multiKaraScheduler.isKaraSleeping(string)) {
                jButton.setEnabled(true);
            }
        }

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
            if (MultiKaraInterpreterToolbar.this.stepButton != null) {
                MultiKaraInterpreterToolbar.this.stepButton.setEnabled(true);
                this.enableKaraIfActiveAndNotSleeping(MultiKaraInterpreterToolbar.this.nameYellow, MultiKaraInterpreterToolbar.this.stepButtonYellow);
                this.enableKaraIfActiveAndNotSleeping(MultiKaraInterpreterToolbar.this.nameRed, MultiKaraInterpreterToolbar.this.stepButtonRed);
                this.enableKaraIfActiveAndNotSleeping(MultiKaraInterpreterToolbar.this.nameViolet, MultiKaraInterpreterToolbar.this.stepButtonViolet);
                this.enableKaraIfActiveAndNotSleeping(MultiKaraInterpreterToolbar.this.nameBlue, MultiKaraInterpreterToolbar.this.stepButtonBlue);
            }
            MultiKaraInterpreterToolbar.this.playButton.setEnabled(true);
            MultiKaraInterpreterToolbar.this.pauseButton.setEnabled(false);
            MultiKaraInterpreterToolbar.this.stopButton.setEnabled(true);
        }

        @Override
        public void playing(RunnableInterface runnableInterface) {
            if (MultiKaraInterpreterToolbar.this.stepButton != null) {
                MultiKaraInterpreterToolbar.this.stepButton.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonYellow.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonRed.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonViolet.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonBlue.setEnabled(false);
            }
            MultiKaraInterpreterToolbar.this.playButton.setEnabled(false);
            MultiKaraInterpreterToolbar.this.pauseButton.setEnabled(true);
            MultiKaraInterpreterToolbar.this.stopButton.setEnabled(true);
        }

        @Override
        public void pausing(RunnableInterface runnableInterface) {
            this.gotReady(runnableInterface);
        }

        @Override
        public void beginCompositeStep(RunnableInterface runnableInterface) {
            if (runnableInterface.getState() != RunnableInterface.State.RUNNING) {
                MultiKaraInterpreterToolbar.this.stepButton.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonYellow.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonRed.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonViolet.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonBlue.setEnabled(false);
                MultiKaraInterpreterToolbar.this.playButton.setEnabled(false);
                MultiKaraInterpreterToolbar.this.pauseButton.setEnabled(false);
            }
        }

        @Override
        public void endCompositeStep(RunnableInterface runnableInterface) {
            if (runnableInterface.getState() != RunnableInterface.State.RUNNING) {
                this.gotReady(runnableInterface);
            }
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
            if (MultiKaraInterpreterToolbar.this.stepButton != null) {
                MultiKaraInterpreterToolbar.this.stepButton.setEnabled(true);
                MultiKaraInterpreterToolbar.this.stepButtonYellow.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonRed.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonViolet.setEnabled(false);
                MultiKaraInterpreterToolbar.this.stepButtonBlue.setEnabled(false);
            }
            MultiKaraInterpreterToolbar.this.playButton.setEnabled(true);
            MultiKaraInterpreterToolbar.this.pauseButton.setEnabled(false);
            MultiKaraInterpreterToolbar.this.stopButton.setEnabled(false);
        }

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            this.stopped(runnableInterface);
        }
    }
}

