/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.InterpreterToolbar;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.SchedulerListener;
import ch.karatojava.interpreter.StepableInterpreter;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.KaraInterpreterUiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.actorfsm.editor.FsmStatisticsWindow;
import ch.karatojava.kapps.karaide.KaraInterpreterFacade;
import ch.karatojava.kapps.multikaraide.MultiKaraInterpreterToolbar;
import ch.karatojava.kapps.multikaraide.MultiKaraScheduler;
import ch.karatojava.kapps.multikaraide.MultiKaraWorldEditorFacade;
import ch.karatojava.kapps.multikaraide.worldio.MultiKaraWorldBuilder;
import ch.karatojava.kapps.multikaraide.worldio.MultiKaraWorldOutputter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class MultiKaraInterpreterFacade
extends KaraInterpreterFacade {
    protected ActionListener manualSchedulerModeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((MultiKaraInterpreterToolbar)MultiKaraInterpreterFacade.this.toolbar).setCompositeStepModeToManual(actionEvent.getActionCommand().equals("manualschedulerenabled"));
        }
    };
    protected ActionListener executionOrderModeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiKaraInterpreterFacade.this.scheduler.setExecutionOrderMode(actionEvent.getActionCommand());
        }
    };
    private MultiKaraScheduler scheduler;
    protected ActionListener interpreterModeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiKaraInterpreterFacade.this.scheduler.setDeterministic(actionEvent.getActionCommand().equals("deterministic"));
        }
    };

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        n = super.initialize(jProgressBar, jLabel, n);
        this.getInterpreter().addInterpreterListener(((MultiKaraWorldEditorFacade)this.worldEditorFacade).getSchedulerView().getInterpreterListener());
        this.getInterpreter().addInterpreterListener(this.scheduler.getInterpreterListener());
        this.scheduler.resetPriorities();
        SchedulerListener[] schedulerListenerArray = this.worldEditorFacade.getSchedulerListeners();
        for (int i = 0; i < schedulerListenerArray.length; ++i) {
            this.scheduler.addListener(schedulerListenerArray[i]);
        }
        ((MultiKaraWorldEditorFacade)this.worldEditorFacade).getSchedulerView().setScheduler(this.scheduler);
        ((MultiKaraWorldBuilder)MultiKaraWorldBuilder.getInstance()).setScheduler(this.scheduler);
        ((MultiKaraWorldOutputter)MultiKaraWorldOutputter.getInstance()).setScheduler(this.scheduler);
        return n;
    }

    @Override
    protected InterpreterToolbar createToolbar(RunnableInterface runnableInterface) {
        MultiKaraInterpreterToolbar multiKaraInterpreterToolbar = new MultiKaraInterpreterToolbar(new KaraInterpreterUiFactory(), runnableInterface);
        multiKaraInterpreterToolbar.setMultiKaraScheduler(this.scheduler);
        return multiKaraInterpreterToolbar;
    }

    @Override
    protected ActionListener getInterpreterModeListener() {
        return this.interpreterModeListener;
    }

    @Override
    protected FsmStatisticsWindow createFsmStatisticsWindow() {
        FsmStatisticsWindow fsmStatisticsWindow = new FsmStatisticsWindow();
        this.interpreter.addInterpreterListener(fsmStatisticsWindow.getInterpreterListener());
        return fsmStatisticsWindow;
    }

    @Override
    protected RunnableInterface createInterpreter() {
        this.scheduler = new MyScheduler((MultiKaraWorldEditorFacade)this.worldEditorFacade, this.programEditorFacade);
        StepableInterpreter stepableInterpreter = new StepableInterpreter(this.scheduler);
        this.scheduler.setStepableInterpreter(stepableInterpreter);
        return stepableInterpreter;
    }

    protected ActionListener getManualSchedulerModeListener() {
        return this.manualSchedulerModeListener;
    }

    protected ActionListener getExecutionOrderModeListener() {
        return this.executionOrderModeListener;
    }

    @Override
    public JComponent getConfigGui() {
        KaraGuiFactory karaGuiFactory = KaraGuiFactory.getInstance();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(super.getConfigGui());
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(karaGuiFactory.createConfigurableRadioButtonPanel(this.getManualSchedulerModeListener(), "manualscheduler", "language/$language/multikara/manualschedulermode"));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(karaGuiFactory.createConfigurableRadioButtonPanel(this.getExecutionOrderModeListener(), "executionorder", "language/$language/multikara/executionordermode"));
        return jPanel;
    }

    private class MyScheduler
    extends MultiKaraScheduler {
        public MyScheduler(MultiKaraWorldEditorFacade multiKaraWorldEditorFacade, ProgramEditorFacadeInterface programEditorFacadeInterface) {
            super(multiKaraWorldEditorFacade, programEditorFacadeInterface);
        }

        @Override
        public void getReady() throws InterpreterException {
            MultiKaraInterpreterFacade.this.checkProgramEditorWindow();
            super.getReady();
        }
    }
}

