/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.karaide.KaraActorType;
import ch.karatojava.kapps.multikaraide.MultiKara;
import ch.karatojava.kapps.multikaraide.MultiKaraKonstants;
import ch.karatojava.kapps.multikaraide.MultiKaraSensorFactory;
import ch.karatojava.util.Configuration;
import java.util.List;

public class MultiKaraActorType
extends KaraActorType {
    protected MultiKaraActorType() {
    }

    public static KaraActorType getInstance() {
        if (instance == null) {
            instance = new MultiKaraActorType();
        }
        return instance;
    }

    @Override
    public Class getKaraActorClass() {
        return MultiKara.class;
    }

    @Override
    protected void createSensors() {
        super.createSensors();
        this.createMultiKaraSensors();
    }

    protected void createMultiKaraSensors() {
        MultiKaraSensorFactory multiKaraSensorFactory = MultiKaraSensorFactory.getInstance();
        String string = Configuration.getInstance().getString(MultiKaraKonstants.MULTIKARA_SENSOR_LIST);
        List<String> list = Configuration.split(string, ",");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            String string3 = MultiKaraKonstants.MULTIKARA_SENSORS + "/" + string2 + MultiKaraKonstants.MULTIKARA_SENSOR_DESCPATH;
            string3 = Configuration.getInstance().getString(string3);
            String string4 = MultiKaraKonstants.MULTIKARA_SENSORS + "/" + string2 + MultiKaraKonstants.MULTIKARA_SENSOR_PARAMLABEL;
            String string5 = Configuration.getInstance().getString(string4);
            SensorTypeInterface sensorTypeInterface = multiKaraSensorFactory.createWorldSensor(string3, string5);
            sensorTypeInterface.setIdentifier(string2);
            this.sensors.add(sensorTypeInterface);
            this.systemSensors.add(sensorTypeInterface);
            this.systemSensorIndices.put(sensorTypeInterface.getName(), new Integer(i));
        }
    }
}

