/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multijavakaraide;

import ch.karatojava.kapps.Konfig;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraActorCommandsToolbar;
import ch.karatojava.kapps.karaide.KaraWorldEditorFacade;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.multikaraide.MultiKara;
import ch.karatojava.kapps.multikaraide.MultiKaraActorCommandsToolbar;
import ch.karatojava.kapps.multikaraide.worldobjects.STREET;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.util.Configuration;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class MultiJavaKaraWorldEditorFacade
extends KaraWorldEditorFacade {
    protected MouseListener mouseActivationListener = new MouseAdapter(){
        protected Point start;
        protected int clickDistance = 3;

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Point point2 = MultiJavaKaraWorldEditorFacade.this.worldEditor.getWorldView().getFieldPos(point.x, point.y);
            if (point2 != null && MultiJavaKaraWorldEditorFacade.this.worldEditor.getWorld().isObjectOfTypeAt(Kara.getKaras()[0], point2.x, point2.y)) {
                MultiKara multiKara = (MultiKara)MultiJavaKaraWorldEditorFacade.this.worldEditor.getWorld().getObjectOfTypeAt(Kara.getKaras()[0], point2.x, point2.y);
                ((MultiKaraActorCommandsToolbar)MultiJavaKaraWorldEditorFacade.this.karaCommandToolbar).setActorToControl(multiKara.getIdentity());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.start = mouseEvent.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.start != null && this.start.distance(mouseEvent.getPoint()) < (double)this.clickDistance) {
                this.mouseClicked(mouseEvent);
            }
            this.start = null;
        }
    };
    protected PropertyChangeListener actorActivationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("kara removed")) {
                ((MultiKaraActorCommandsToolbar)MultiJavaKaraWorldEditorFacade.this.karaCommandToolbar).resetActorToControl((String)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof MultiKara) {
                ((MultiKaraActorCommandsToolbar)MultiJavaKaraWorldEditorFacade.this.karaCommandToolbar).setActorToControl(((MultiKara)propertyChangeEvent.getNewValue()).getIdentity());
            }
        }
    };

    @Override
    public int getNumberOfInitSteps() {
        return 8;
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        jLabel.setText("creating karas ...");
        this.createKaraPrototypes();
        jProgressBar.setValue(++n);
        jLabel.setText("creating world objects ...");
        super.createWorldObjects();
        jProgressBar.setValue(++n);
        jLabel.setText("creating street objects ...");
        this.createWorldStreetObjects();
        jProgressBar.setValue(++n);
        jLabel.setText("creating world editor ...");
        this.worldEditor = this.createWorldEditor();
        this.worldEditor.getWorldView().addPropertyChangeListener("kara put", this.actorActivationListener);
        this.worldEditor.getWorldView().addPropertyChangeListener("kara removed", this.actorActivationListener);
        this.worldEditor.getWorldView().addMouseListener(this.mouseActivationListener);
        jProgressBar.setValue(++n);
        jLabel.setText("creating world editor io toolbar  ...");
        this.worldEditorIOToolbar = this.createWorldEditorIOToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        jLabel.setText("creating kara toolbar  ...");
        this.karaCommandToolbar = this.createkaraCommandToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        jLabel.setText("creating world toolbar ...");
        this.worldEditorToolbar = this.createworldEditorToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        jLabel.setText("creating zoom toolbar  ...");
        this.westPanel = this.createWestPanel(this.worldEditor);
        jProgressBar.setValue(++n);
        return n;
    }

    protected void createWorldStreetObjects() {
        Konfig.addWorldObject(STREET.getInstance(1));
        Konfig.addWorldObject(STREET.getInstance(2));
        Konfig.addWorldObject(STREET.getInstance(4));
        Konfig.addWorldObject(STREET.getInstance(8));
        for (int i = 1; i < 16; ++i) {
            Konfig.addWorldImage(STREET.getInstance(i), Configuration.getInstance().getImageIcon("schemes/ladybugscheme/street/streeticon" + i));
            STREET.getInstance(i).setClientProperty("WorldEditorToolbarTooltip", "language/$language/kawomodel/objectdescriptions/street");
        }
    }

    @Override
    protected void createKaraPrototypes() {
        int n = 1;
        String string = Configuration.getInstance().getString("karamodel/$karamodel/karaidentities");
        List<String> list = Configuration.split(string, ",");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            MultiKara multiKara = new MultiKara(string2, n);
            Kara.addKaraPrototype(multiKara);
            ImageIcon imageIcon = Configuration.getInstance().getImageIcon("schemes/ladybugscheme/" + string2 + "/paintedicon");
            Konfig.addWorldImage(LEAF.getInstance(n), imageIcon);
            Konfig.addWorldObject(multiKara);
            ImageIcon[] imageIconArray = multiKara.getKaraImageIcons();
            for (int j = 0; j < imageIconArray.length; ++j) {
                Konfig.addWorldImage(multiKara, imageIconArray[j]);
            }
            multiKara.setGUIID(multiKara.getGUIID() - multiKara.getDirection() - 3);
            multiKara.setDirection(0);
            ++n;
        }
    }

    @Override
    protected KaraActorCommandsToolbar createkaraCommandToolbar(WorldEditor worldEditor) {
        return new MultiKaraActorCommandsToolbar(worldEditor);
    }
}

