/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Hashtable;

public class TurtlePrimitives
extends PrimitiveGroup {
    static final int TURTLE_HEIGHT = 16;
    static final int TURTLE_HALF_WIDTH = 6;
    static final int DEFAULT_WINDOW_WIDTH = 400;
    static final int DEFAULT_WINDOW_HEIGHT = 400;
    private Color _backColor;
    private Color _penColor;
    private byte _penState;
    private double _xpos;
    private double _ypos;
    int _xhalfsize;
    int _yhalfsize;
    private double _heading;
    private boolean _turtleVisible;
    private byte _wrapState;
    private TurtleWind _graphWind;
    Graphics _graphContext;
    private Hashtable _colorNames;
    Machine _mach;
    RedisplayThread _thread;
    int _redisplayInterval;
    private static final byte PS_DOWN = 1;
    private static final byte PS_UP = 2;
    private static final byte PS_ERASE = 3;
    private static final byte WS_WRAP = 1;
    private static final byte WS_FENCE = 2;
    private static final byte WS_WINDOW = 3;

    @Override
    protected void setup(Machine machine, Console console) throws SetupException {
        this.registerPrimitive("BACK", "pBACK", 1);
        this.registerPrimitive("BK", "pBACK", 1);
        this.registerPrimitive("CLEAN", "pCLEAN", 0);
        this.registerPrimitive("CLEARSCREEN", "pCLEARSCREEN", 0);
        this.registerPrimitive("CS", "pCLEARSCREEN", 0);
        this.registerPrimitive("DISTANCETO", "pDISTANCETO", 1);
        this.registerPrimitive("DISTANCETOXY", "pDISTANCETOXY", 2);
        this.registerPrimitive("DRAW", "pDRAW", 0);
        this.registerPrimitive("FD", "pFORWARD", 1);
        this.registerPrimitive("FENCE", "pFENCE", 0);
        this.registerPrimitive("FORWARD", "pFORWARD", 1);
        this.registerPrimitive("GETBACKGROUND", "pGETBACKGROUND", 0);
        this.registerPrimitive("GETBG", "pGETBACKGROUND", 0);
        this.registerPrimitive("GETPC", "pGETPENCOLOR", 0);
        this.registerPrimitive("GETPENCOLOR", "pGETPENCOLOR", 0);
        this.registerPrimitive("HEADING", "pHEADING", 0);
        this.registerPrimitive("HIDETURTLE", "pHIDETURTLE", 0);
        this.registerPrimitive("HOME", "pHOME", 0);
        this.registerPrimitive("HT", "pHIDETURTLE", 0);
        this.registerPrimitive("LABEL", "pLABEL", 1);
        this.registerPrimitive("LEFT", "pLEFT", 1);
        this.registerPrimitive("LT", "pLEFT", 1);
        this.registerPrimitive("ND", "pNODRAW", 0);
        this.registerPrimitive("NODRAW", "pNODRAW", 0);
        this.registerPrimitive("PALETTE", "pPALETTE", 1);
        this.registerPrimitive("PALETTE?", "pPALETTEP", 1);
        this.registerPrimitive("PALETTEP", "pPALETTEP", 1);
        this.registerPrimitive("PD", "pPENDOWN", 0);
        this.registerPrimitive("PE", "pPENERASE", 0);
        this.registerPrimitive("PENDOWN", "pPENDOWN", 0);
        this.registerPrimitive("PENERASE", "pPENERASE", 0);
        this.registerPrimitive("PENUP", "pPENUP", 0);
        this.registerPrimitive("POS", "pPOS", 0);
        this.registerPrimitive("PU", "pPENUP", 0);
        this.registerPrimitive("REFRESH", "pREFRESH", 0);
        this.registerPrimitive("REFRESHINTERVAL", "pREFRESHINTERVAL", 1);
        this.registerPrimitive("RESETPALETTE", "pRESETPALETTE", 1);
        this.registerPrimitive("RIGHT", "pRIGHT", 1);
        this.registerPrimitive("RT", "pRIGHT", 1);
        this.registerPrimitive("SETBACKGROUND", "pSETBACKGROUND", 1);
        this.registerPrimitive("SETBG", "pSETBACKGROUND", 1);
        this.registerPrimitive("SETH", "pSETHEADING", 1);
        this.registerPrimitive("SETHEADING", "pSETHEADING", 1);
        this.registerPrimitive("SETPALETTE", "pSETPALETTE", 1);
        this.registerPrimitive("SETPC", "pSETPENCOLOR", 1);
        this.registerPrimitive("SETPENCOLOR", "pSETPENCOLOR", 1);
        this.registerPrimitive("SETPOS", "pSETPOS", 1);
        this.registerPrimitive("SETX", "pSETX", 1);
        this.registerPrimitive("SETXY", "pSETXY", 2);
        this.registerPrimitive("SETY", "pSETY", 1);
        this.registerPrimitive("SHOWTURTLE", "pSHOWTURTLE", 0);
        this.registerPrimitive("ST", "pSHOWTURTLE", 0);
        this.registerPrimitive("TOWARDS", "pTOWARDS", 1);
        this.registerPrimitive("TOWARDSXY", "pTOWARDSXY", 2);
        this.registerPrimitive("UNSETPALETTE", "pUNSETPALETTE", 1);
        this.registerPrimitive("WINDOW", "pWINDOW", 0);
        this.registerPrimitive("WRAP", "pWRAP", 0);
        this.registerPrimitive("XCOR", "pXCOR", 0);
        this.registerPrimitive("XSIZE", "pXSIZE", 0);
        this.registerPrimitive("YCOR", "pYCOR", 0);
        this.registerPrimitive("YSIZE", "pYSIZE", 0);
        this._mach = machine;
        this._graphWind = null;
        this._thread = null;
        this._redisplayInterval = 0;
        this.resetPalette();
        console.putStatusMessage("Turtle Tracks turtle graphics primitives v1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exiting() {
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._graphWind != null) {
                this._graphWind.dispose();
                this._graphWind = null;
                this._thread.kill();
                this._thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pBACK(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = -logoObjectArray[0].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            double d2 = (90.0 - this._heading) / 180.0 * Math.PI;
            this.moveTo(this._xpos + d * Math.cos(d2), this._ypos + d * Math.sin(d2));
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pCLEAN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._graphWind != null) {
                this._graphWind.reset();
            }
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pCLEARSCREEN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._graphWind != null) {
                this._graphWind.reset();
            }
            this._xpos = 0.0;
            this._ypos = 0.0;
            this._heading = 0.0;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pDISTANCETO(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoList)) {
            throw new LanguageException("Position list expected");
        }
        if (logoObjectArray[0].length() != 2) {
            throw new LanguageException("Position list expected");
        }
        double d2 = ((LogoList)logoObjectArray[0]).pickInPlace(0).toNumber();
        double d3 = ((LogoList)logoObjectArray[0]).pickInPlace(1).toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = Math.sqrt((d2 - this._xpos) * (d2 - this._xpos) + (d3 - this._ypos) * (d3 - this._ypos));
        }
        return new LogoWord(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pDISTANCETOXY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 2);
        double d2 = logoObjectArray[0].toNumber();
        double d3 = logoObjectArray[1].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = Math.sqrt((d2 - this._xpos) * (d2 - this._xpos) + (d3 - this._ypos) * (d3 - this._ypos));
        }
        return new LogoWord(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pDRAW(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        int n;
        int n2;
        if (logoObjectArray.length == 2) {
            n2 = logoObjectArray[0].toInteger();
            n = logoObjectArray[1].toInteger();
        } else if (logoObjectArray.length == 0) {
            n2 = 200;
            n = 200;
        } else {
            throw new LanguageException("Wrong number of arguments");
        }
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._xhalfsize = n2;
            this._yhalfsize = n;
            if (this._graphWind != null) {
                this._graphWind.reset();
            } else {
                try {
                    this._graphWind = new TurtleWind();
                    this._thread = new RedisplayThread();
                    this._thread.start();
                }
                catch (InternalError internalError) {
                    // empty catch block
                }
            }
            if (this._graphWind == null) {
                throw new LanguageException("Unable to open graphics window");
            }
            this._backColor = Color.black;
            this._penColor = Color.white;
            this._penState = 1;
            this._xpos = 0.0;
            this._ypos = 0.0;
            this._heading = 0.0;
            this._turtleVisible = true;
            this._wrapState = 1;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pFENCE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._xpos < (double)(-this._xhalfsize) || this._xpos > (double)(this._xhalfsize - 1) || this._ypos < (double)(-this._yhalfsize) || this._ypos > (double)(this._yhalfsize - 1)) {
                throw new LanguageException("Turtle out of bounds in FENCE");
            }
            this._wrapState = (byte)2;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pFORWARD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            double d2 = (90.0 - this._heading) / 180.0 * Math.PI;
            this.moveTo(this._xpos + d * Math.cos(d2), this._ypos + d * Math.sin(d2));
        }
        return LogoVoid.obj;
    }

    public final LogoObject pGETBACKGROUND(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LogoObject[] logoObjectArray2 = new LogoObject[]{new LogoWord(this._backColor.getRed()), new LogoWord(this._backColor.getGreen()), new LogoWord(this._backColor.getBlue())};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pGETPENCOLOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LogoObject[] logoObjectArray2 = new LogoObject[]{new LogoWord(this._penColor.getRed()), new LogoWord(this._penColor.getGreen()), new LogoWord(this._penColor.getBlue())};
        return new LogoList(logoObjectArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pHEADING(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = this._heading;
        }
        return new LogoWord(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pHIDETURTLE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._turtleVisible = false;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pHOME(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this.drawLineTo(0.0, 0.0);
            this._xpos = 0.0;
            this._ypos = 0.0;
            this._heading = 0.0;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pLABEL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        String string = null;
        string = logoObjectArray[0] instanceof LogoList ? ((LogoList)logoObjectArray[0]).toStringOpen() : logoObjectArray[0].toString();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._graphWind != null && this._penState != 2) {
                if (this._penState == 1) {
                    this._graphContext.setColor(this._penColor);
                } else {
                    this._graphContext.setColor(this._backColor);
                }
                this._graphContext.drawString(string, (int)Math.round((double)this._xhalfsize + this._xpos), (int)Math.round((double)this._yhalfsize - this._ypos));
                this._graphWind.redisplay();
            }
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pLEFT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._heading = this.fixAngle(this._heading - d);
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pNODRAW(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._graphWind != null) {
                this._graphWind.dispose();
                this._graphWind = null;
                this._graphContext = null;
                this._thread.kill();
                this._thread = null;
                this._redisplayInterval = 0;
            }
        }
        return LogoVoid.obj;
    }

    public final LogoObject pPALETTE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Color name expected");
        }
        Color color = (Color)this._colorNames.get(logoObjectArray[0].toCaselessString());
        if (color == null) {
            return new LogoList();
        }
        LogoObject[] logoObjectArray2 = new LogoObject[]{new LogoWord(color.getRed()), new LogoWord(color.getGreen()), new LogoWord(color.getBlue())};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pPALETTEP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Color name expected");
        }
        return new LogoWord(this._colorNames.get(logoObjectArray[0].toCaselessString()) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pPENDOWN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._penState = 1;
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pPENERASE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._penState = (byte)3;
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pPENUP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._penState = (byte)2;
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pPOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LogoObject[] logoObjectArray2 = this;
        synchronized (this) {
            double d = this._xpos;
            double d2 = this._ypos;
            // ** MonitorExit[var7_3] (shouldn't be in output)
            logoObjectArray2 = new LogoObject[]{new LogoWord(d), new LogoWord(d2)};
            return new LogoList(logoObjectArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pREFRESH(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._graphWind != null) {
                this._graphWind.update();
            }
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pREFRESHINTERVAL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._graphWind != null) {
                this._redisplayInterval = logoObjectArray[0].toInteger();
                this._thread.setInterval(this._redisplayInterval);
            }
        }
        return LogoVoid.obj;
    }

    public final LogoObject pRESETPALETTE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        this.resetPalette();
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pRIGHT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._heading = this.fixAngle(this._heading + d);
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSETBACKGROUND(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        Color color = this.findColor(logoObjectArray[0]);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._backColor = color;
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSETHEADING(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._heading = this.fixAngle(d);
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    public final LogoObject pSETPALETTE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Color name expected");
        }
        this._colorNames.put(logoObjectArray[0].toCaselessString(), this.findColor(logoObjectArray[1]));
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSETPENCOLOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        Color color = this.findColor(logoObjectArray[0]);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._penColor = color;
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSETPOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoList)) {
            throw new LanguageException("Position list expected");
        }
        if (logoObjectArray[0].length() != 2) {
            throw new LanguageException("Position list expected");
        }
        double d = ((LogoList)logoObjectArray[0]).pickInPlace(0).toNumber();
        double d2 = ((LogoList)logoObjectArray[0]).pickInPlace(1).toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this.moveTo(d, d2);
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSETX(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._wrapState == 2 && (d < (double)(-this._xhalfsize) || d > (double)(this._xhalfsize - 1))) {
                throw new LanguageException("Turtle out of bounds");
            }
            if (this._wrapState == 1) {
                while (true) {
                    if (d < (double)(-this._xhalfsize) - 0.5) {
                        d = this.wrapXMinus(d, this._ypos);
                        continue;
                    }
                    if (!(d > (double)this._xhalfsize - 0.5)) break;
                    d = this.wrapXPlus(d, this._ypos);
                }
            }
            this.drawLineTo(d, this._ypos);
            this._xpos = d;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSETXY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        double d = logoObjectArray[0].toNumber();
        double d2 = logoObjectArray[1].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this.moveTo(d, d2);
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSETY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            if (this._wrapState == 2 && (d < (double)(-this._yhalfsize) || d > (double)(this._yhalfsize - 1))) {
                throw new LanguageException("Turtle out of bounds");
            }
            if (this._wrapState == 1) {
                while (true) {
                    if (d < (double)(-this._yhalfsize) - 0.5) {
                        d = this.wrapYMinus(this._xpos, d);
                        continue;
                    }
                    if (!(d > (double)this._yhalfsize - 0.5)) break;
                    d = this.wrapYPlus(this._xpos, d);
                }
            }
            this.drawLineTo(this._xpos, d);
            this._ypos = d;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSHOWTURTLE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._turtleVisible = true;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pTOWARDS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoList)) {
            throw new LanguageException("Position list expected");
        }
        if (logoObjectArray[0].length() != 2) {
            throw new LanguageException("Position list expected");
        }
        double d2 = ((LogoList)logoObjectArray[0]).pickInPlace(0).toNumber();
        double d3 = ((LogoList)logoObjectArray[0]).pickInPlace(1).toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = this.fixAngle(90.0 - Math.atan2(d3 - this._ypos, d2 - this._xpos) / Math.PI * 180.0);
        }
        return new LogoWord(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pTOWARDSXY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 2);
        double d2 = logoObjectArray[0].toNumber();
        double d3 = logoObjectArray[1].toNumber();
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = this.fixAngle(90.0 - Math.atan2(d3 - this._ypos, d2 - this._xpos) / Math.PI * 180.0);
        }
        return new LogoWord(d);
    }

    public final LogoObject pUNSETPALETTE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Color name expected");
        }
        this._colorNames.remove(logoObjectArray[0].toCaselessString());
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pWINDOW(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._wrapState = (byte)3;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pWRAP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            this._xpos = this.wrapCoordinate(this._xpos, this._xhalfsize);
            this._ypos = this.wrapCoordinate(this._ypos, this._yhalfsize);
            this._wrapState = 1;
            this.updateTurtle();
        }
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pXCOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = this._xpos;
        }
        return new LogoWord(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pXSIZE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = this._xhalfsize;
        }
        return new LogoWord(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pYCOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = this._ypos;
        }
        return new LogoWord(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pYSIZE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d;
        this.testNumParams(logoObjectArray, 0);
        TurtlePrimitives turtlePrimitives = this;
        synchronized (turtlePrimitives) {
            d = this._yhalfsize;
        }
        return new LogoWord(d);
    }

    private final Color findColor(LogoObject logoObject) throws LanguageException {
        if (logoObject instanceof LogoWord) {
            Color color = (Color)this._colorNames.get(logoObject.toCaselessString());
            if (color == null) {
                throw new LanguageException("Color not found");
            }
            return color;
        }
        if (logoObject.length() != 3) {
            throw new LanguageException("Three elements expected in color list");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = ((LogoList)logoObject).pickInPlace(0).toInteger();
        }
        catch (LanguageException languageException) {
            throw new LanguageException(languageException.getMessage() + " in red value of color list");
        }
        try {
            n2 = ((LogoList)logoObject).pickInPlace(1).toInteger();
        }
        catch (LanguageException languageException) {
            throw new LanguageException(languageException.getMessage() + " in green value of color list");
        }
        try {
            n3 = ((LogoList)logoObject).pickInPlace(2).toInteger();
        }
        catch (LanguageException languageException) {
            throw new LanguageException(languageException.getMessage() + " in blue value of color list");
        }
        if (n < 0 || n > 255) {
            throw new LanguageException("Bad color (red value out of range)");
        }
        if (n2 < 0 || n2 > 255) {
            throw new LanguageException("Bad color (green value out of range)");
        }
        if (n3 < 0 || n3 > 255) {
            throw new LanguageException("Bad color (blue value out of range)");
        }
        return new Color(n, n2, n3);
    }

    private final void updateTurtle() {
        if (this._graphWind != null) {
            this._graphWind.setTurtleState(this._xpos, this._ypos, (90.0 - this._heading) / 180.0 * Math.PI, this._turtleVisible, this._wrapState == 1);
        }
    }

    private final void drawLineTo(double d, double d2) {
        if (this._graphWind != null && this._penState != 2) {
            if (this._penState == 1) {
                this._graphContext.setColor(this._penColor);
            } else {
                this._graphContext.setColor(this._backColor);
            }
            this._graphContext.drawLine((int)Math.round((double)this._xhalfsize + this._xpos), (int)Math.round((double)this._yhalfsize - this._ypos), (int)Math.round((double)this._xhalfsize + d), (int)Math.round((double)this._yhalfsize - d2));
        }
    }

    private final double wrapCoordinate(double d, double d2) {
        double d3 = d2 * 2.0;
        double d4 = d < 0.0 ? d + d3 * Math.floor(-d / d3) + d3 : d - d3 * Math.floor(d / d3);
        if (d4 > d2 - 0.5) {
            return d4 - d3;
        }
        return d4;
    }

    private final double fixAngle(double d) {
        if (d < 0.0) {
            return d + 360.0 * Math.floor(-d / 360.0) + 360.0;
        }
        return d - 360.0 * Math.floor(d / 360.0);
    }

    private final double wrapXMinus(double d, double d2) {
        double d3 = this._ypos + ((double)(-this._xhalfsize) - 0.5 - this._xpos) / (d - this._xpos) * (d2 - this._ypos);
        this.drawLineTo((double)(-this._xhalfsize) - 0.5, d3);
        this._xpos = (double)this._xhalfsize - 0.5;
        this._ypos = d3;
        this.updateTurtle();
        return d + (double)this._xhalfsize * 2.0;
    }

    private final double wrapYMinus(double d, double d2) {
        double d3 = this._xpos + ((double)(-this._yhalfsize) - 0.5 - this._ypos) / (d2 - this._ypos) * (d - this._xpos);
        this.drawLineTo(d3, (double)(-this._yhalfsize) - 0.5);
        this._ypos = (double)this._yhalfsize - 0.5;
        this._xpos = d3;
        this.updateTurtle();
        return d2 + (double)this._yhalfsize * 2.0;
    }

    private final double wrapXPlus(double d, double d2) {
        double d3 = this._ypos + ((double)this._xhalfsize - 0.5 - this._xpos) / (d - this._xpos) * (d2 - this._ypos);
        this.drawLineTo((double)this._xhalfsize - 0.5, d3);
        this._xpos = (double)(-this._xhalfsize) - 0.5;
        this._ypos = d3;
        this.updateTurtle();
        return d - (double)this._xhalfsize * 2.0;
    }

    private final double wrapYPlus(double d, double d2) {
        double d3 = this._xpos + ((double)this._yhalfsize - 0.5 - this._ypos) / (d2 - this._ypos) * (d - this._xpos);
        this.drawLineTo(d3, (double)this._yhalfsize - 0.5);
        this._ypos = (double)(-this._yhalfsize) - 0.5;
        this._xpos = d3;
        this.updateTurtle();
        return d2 - (double)this._yhalfsize * 2.0;
    }

    private final void moveTo(double d, double d2) throws LanguageException {
        if (this._wrapState == 2 && (d < (double)(-this._xhalfsize) || d > (double)(this._xhalfsize - 1) || d2 < (double)(-this._yhalfsize) || d2 > (double)(this._yhalfsize - 1))) {
            throw new LanguageException("Turtle out of bounds");
        }
        if (this._wrapState == 1) {
            while (true) {
                if (d < (double)(-this._xhalfsize) - 0.5) {
                    if (d2 < (double)(-this._yhalfsize) - 0.5) {
                        if (((double)(-this._xhalfsize) - 0.5 - this._xpos) * (d2 - this._ypos) > ((double)(-this._yhalfsize) - 0.5 - this._ypos) * (d - this._xpos)) {
                            d2 = this.wrapYMinus(d, d2);
                            continue;
                        }
                        d = this.wrapXMinus(d, d2);
                        continue;
                    }
                    if (d2 > (double)this._yhalfsize - 0.5) {
                        if (((double)(-this._xhalfsize) - 0.5 - this._xpos) * (d2 - this._ypos) < ((double)this._yhalfsize - 0.5 - this._ypos) * (d - this._xpos)) {
                            d2 = this.wrapYPlus(d, d2);
                            continue;
                        }
                        d = this.wrapXMinus(d, d2);
                        continue;
                    }
                    d = this.wrapXMinus(d, d2);
                    continue;
                }
                if (d > (double)this._xhalfsize - 0.5) {
                    if (d2 < (double)(-this._yhalfsize) - 0.5) {
                        if (((double)this._xhalfsize - 0.5 - this._xpos) * (d2 - this._ypos) < ((double)(-this._yhalfsize) - 0.5 - this._ypos) * (d - this._xpos)) {
                            d2 = this.wrapYMinus(d, d2);
                            continue;
                        }
                        d = this.wrapXPlus(d, d2);
                        continue;
                    }
                    if (d2 > (double)this._yhalfsize - 0.5) {
                        if (((double)this._xhalfsize - 0.5 - this._xpos) * (d2 - this._ypos) > ((double)this._yhalfsize - 0.5 - this._ypos) * (d - this._xpos)) {
                            d2 = this.wrapYPlus(d, d2);
                            continue;
                        }
                        d = this.wrapXPlus(d, d2);
                        continue;
                    }
                    d = this.wrapXPlus(d, d2);
                    continue;
                }
                if (d2 < (double)(-this._yhalfsize) - 0.5) {
                    d2 = this.wrapYMinus(d, d2);
                    continue;
                }
                if (!(d2 > (double)this._yhalfsize - 0.5)) break;
                d2 = this.wrapYPlus(d, d2);
            }
        }
        this.drawLineTo(d, d2);
        this._xpos = d;
        this._ypos = d2;
        this.updateTurtle();
    }

    private final void resetPalette() {
        this._colorNames = new Hashtable();
        this._colorNames.put(new CaselessString("0"), Color.black);
        this._colorNames.put(new CaselessString("1"), Color.blue);
        this._colorNames.put(new CaselessString("2"), Color.green);
        this._colorNames.put(new CaselessString("3"), Color.cyan);
        this._colorNames.put(new CaselessString("4"), Color.red);
        this._colorNames.put(new CaselessString("5"), Color.magenta);
        this._colorNames.put(new CaselessString("6"), Color.yellow);
        this._colorNames.put(new CaselessString("7"), Color.white);
        this._colorNames.put(new CaselessString("black"), Color.black);
        this._colorNames.put(new CaselessString("blue"), Color.blue);
        this._colorNames.put(new CaselessString("cyan"), Color.cyan);
        this._colorNames.put(new CaselessString("darkgray"), Color.darkGray);
        this._colorNames.put(new CaselessString("gray"), Color.gray);
        this._colorNames.put(new CaselessString("green"), Color.green);
        this._colorNames.put(new CaselessString("lightgray"), Color.lightGray);
        this._colorNames.put(new CaselessString("magenta"), Color.magenta);
        this._colorNames.put(new CaselessString("orange"), Color.orange);
        this._colorNames.put(new CaselessString("pink"), Color.pink);
        this._colorNames.put(new CaselessString("red"), Color.red);
        this._colorNames.put(new CaselessString("white"), Color.white);
        this._colorNames.put(new CaselessString("yellow"), Color.yellow);
    }

    final synchronized void updateWind() {
        if (this._graphWind != null) {
            this._graphWind.update();
        }
    }

    final class TurtleWind
    extends Frame {
        private Image _offImage;
        private int _xsize;
        private int _ysize;
        private double _turtleX;
        private double _turtleY;
        private double _turtleHead;
        private boolean _turtleVis;
        private boolean _turtleWrap;

        TurtleWind() throws LanguageException {
            this.setLayout(new BorderLayout());
            this.setResizable(false);
            this.setTitle("Logo Graphics");
            this._xsize = TurtlePrimitives.this._xhalfsize * 2;
            this._ysize = TurtlePrimitives.this._yhalfsize * 2;
            this.setSize(this._xsize, this._ysize);
            this.show();
            this._offImage = this.createImage(this._xsize, this._ysize);
            if (this._offImage == null) {
                throw new LanguageException("Unable to open graphics window");
            }
            TurtlePrimitives.this._graphContext = this._offImage.getGraphics();
            TurtlePrimitives.this._graphContext.setColor(Color.black);
            TurtlePrimitives.this._graphContext.fillRect(0, 0, this._xsize, this._ysize);
            TurtlePrimitives.this._graphContext.setFont(Font.decode("Monospaced"));
        }

        final void reset() throws LanguageException {
            if (this._xsize != TurtlePrimitives.this._xhalfsize * 2 || this._ysize != TurtlePrimitives.this._yhalfsize * 2) {
                this._offImage = this.createImage(TurtlePrimitives.this._xhalfsize * 2, TurtlePrimitives.this._yhalfsize * 2);
                if (this._offImage == null) {
                    throw new LanguageException("Unable to resize graphics window");
                }
                this._xsize = TurtlePrimitives.this._xhalfsize * 2;
                this._ysize = TurtlePrimitives.this._yhalfsize * 2;
                this.setResizable(true);
                this.setSize(this._xsize, this._ysize);
                this.setResizable(false);
                TurtlePrimitives.this._graphContext = this._offImage.getGraphics();
            }
            TurtlePrimitives.this._graphContext.setColor(Color.black);
            TurtlePrimitives.this._graphContext.fillRect(0, 0, this._xsize, this._ysize);
            this.update();
        }

        @Override
        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        public synchronized void update() {
            this.update(this.getGraphics());
        }

        @Override
        public synchronized void update(Graphics graphics) {
            graphics.drawImage(this._offImage, 0, 0, this);
            if (this._turtleVis) {
                graphics.setColor(Color.white);
                this.drawTurtle(graphics, this._turtleX, this._turtleY);
                if (this._turtleWrap) {
                    if (this._turtleX > (double)(TurtlePrimitives.this._xhalfsize - 20)) {
                        this.drawTurtle(graphics, this._turtleX - (double)this._xsize, this._turtleY);
                        if (this._turtleY > (double)(TurtlePrimitives.this._yhalfsize - 20)) {
                            this.drawTurtle(graphics, this._turtleX, this._turtleY - (double)this._ysize);
                            this.drawTurtle(graphics, this._turtleX - (double)this._xsize, this._turtleY - (double)this._ysize);
                        } else if (this._turtleY < (double)(-TurtlePrimitives.this._yhalfsize + 20)) {
                            this.drawTurtle(graphics, this._turtleX, this._turtleY + (double)this._ysize);
                            this.drawTurtle(graphics, this._turtleX - (double)this._xsize, this._turtleY + (double)this._ysize);
                        }
                    } else if (this._turtleX < (double)(-TurtlePrimitives.this._xhalfsize + 20)) {
                        this.drawTurtle(graphics, this._turtleX + (double)this._xsize, this._turtleY);
                        if (this._turtleY > (double)(TurtlePrimitives.this._yhalfsize - 20)) {
                            this.drawTurtle(graphics, this._turtleX, this._turtleY - (double)this._ysize);
                            this.drawTurtle(graphics, this._turtleX + (double)this._xsize, this._turtleY - (double)this._ysize);
                        } else if (this._turtleY < (double)(-TurtlePrimitives.this._yhalfsize + 20)) {
                            this.drawTurtle(graphics, this._turtleX, this._turtleY + (double)this._ysize);
                            this.drawTurtle(graphics, this._turtleX + (double)this._xsize, this._turtleY + (double)this._ysize);
                        }
                    } else if (this._turtleY > (double)(TurtlePrimitives.this._yhalfsize - 20)) {
                        this.drawTurtle(graphics, this._turtleX, this._turtleY - (double)this._ysize);
                    } else if (this._turtleY < (double)(-TurtlePrimitives.this._yhalfsize + 20)) {
                        this.drawTurtle(graphics, this._turtleX, this._turtleY + (double)this._ysize);
                    }
                }
            }
        }

        final void drawTurtle(Graphics graphics, double d, double d2) {
            int n = TurtlePrimitives.this._xhalfsize + (int)Math.round(d + 16.0 * Math.cos(this._turtleHead));
            int n2 = TurtlePrimitives.this._yhalfsize - (int)Math.round(d2 + 16.0 * Math.sin(this._turtleHead));
            int n3 = TurtlePrimitives.this._xhalfsize + (int)Math.round(d + 6.0 * Math.sin(this._turtleHead));
            int n4 = TurtlePrimitives.this._yhalfsize - (int)Math.round(d2 - 6.0 * Math.cos(this._turtleHead));
            int n5 = TurtlePrimitives.this._xhalfsize + (int)Math.round(d - 6.0 * Math.sin(this._turtleHead));
            int n6 = TurtlePrimitives.this._yhalfsize - (int)Math.round(d2 + 6.0 * Math.cos(this._turtleHead));
            graphics.drawLine(n, n2, n3, n4);
            graphics.drawLine(n3, n4, n5, n6);
            graphics.drawLine(n5, n6, n, n2);
        }

        final void setTurtleState(double d, double d2, double d3, boolean bl, boolean bl2) {
            this._turtleX = d;
            this._turtleY = d2;
            this._turtleHead = d3;
            this._turtleVis = bl;
            this._turtleWrap = bl2;
            this.redisplay();
        }

        final void redisplay() {
            if (TurtlePrimitives.this._redisplayInterval == 0) {
                this.update();
            } else if (TurtlePrimitives.this._redisplayInterval > 0) {
                TurtlePrimitives.this._thread.toggle();
            }
        }
    }

    final class RedisplayThread
    extends Thread {
        private boolean _toggle = false;
        private boolean _alive = true;
        private int _interval = 0;

        RedisplayThread() {
        }

        final synchronized void toggle() {
            this._toggle = true;
        }

        final synchronized void kill() {
            this._alive = false;
            this.notifyAll();
        }

        final synchronized void setInterval(int n) {
            this._interval = n;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            while (this._alive) {
                RedisplayThread redisplayThread = this;
                synchronized (redisplayThread) {
                    try {
                        if (this._interval > 0) {
                            this.wait(this._interval);
                        } else {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = this._alive && this._toggle;
                    this._toggle = false;
                }
                if (!bl) continue;
                TurtlePrimitives.this.updateWind();
            }
        }
    }
}

