/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpreterThread;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParsePrimitive;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseProcedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseTree;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveSpec;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Procedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SymbolTable;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ThrowException;
import java.util.Hashtable;

public final class ThreadPrimitives
extends PrimitiveGroup {
    private Hashtable _barriers;
    private Hashtable _locks;

    @Override
    protected void setup(Machine machine, Console console) throws SetupException {
        this.registerPrimitive("BARRIER", "pBARRIER", 2);
        this.registerPrimitive("CRITICAL", "pCRITICAL", 2);
        this.registerPrimitive("CURRENTTHREAD", "pCURRENTTHREAD", 0);
        this.registerPrimitive("STOPTHREAD", "pSTOPTHREAD", 0);
        this.registerPrimitive("THREAD", "pTHREAD", 1);
        this.registerPrimitive("THREADAPPLY", "pTHREADAPPLY", 2);
        this.registerPrimitive("THREADAPPLYID", "pTHREADAPPLYID", 2);
        this.registerPrimitive("THREADRUN", "pTHREADRUN", 1);
        this.registerPrimitive("THREADRUNID", "pTHREADRUNID", 1);
        this.registerPrimitive("THREADTERMINATE", "pTHREADTERMINATE", 1);
        this._barriers = new Hashtable();
        this._locks = new Hashtable();
        console.putStatusMessage("Turtle Tracks thread primitives v1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pBARRIER(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        Barrier barrier;
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Barrier name expected");
        }
        CaselessString caselessString = logoObjectArray[0].toCaselessString();
        int n = logoObjectArray[1].toInteger();
        Hashtable hashtable = this._barriers;
        synchronized (hashtable) {
            barrier = (Barrier)this._barriers.get(caselessString);
            if (barrier == null) {
                barrier = new Barrier(n);
                this._barriers.put(caselessString, barrier);
            }
            if (barrier.checkRequest(n)) {
                this._barriers.remove(caselessString);
            }
        }
        barrier.hit();
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pCRITICAL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        CriticalLock criticalLock;
        this.testNumParams(logoObjectArray, 2);
        LogoObject logoObject = LogoVoid.obj;
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Lock name expected");
        }
        CaselessString caselessString = logoObjectArray[0].toCaselessString();
        Object object = this._locks;
        synchronized (object) {
            criticalLock = (CriticalLock)this._locks.get(caselessString);
            if (criticalLock == null) {
                criticalLock = new CriticalLock();
                this._locks.put(caselessString, criticalLock);
            }
            criticalLock.promote();
        }
        try {
            object = criticalLock;
            synchronized (object) {
                logoObject = logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron);
            }
        }
        finally {
            object = this._locks;
            synchronized (object) {
                criticalLock.demote();
                if (criticalLock.unused()) {
                    this._locks.remove(caselessString);
                }
            }
        }
        return logoObject;
    }

    public final LogoObject pCURRENTTHREAD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(interpEnviron.thread().threadID());
    }

    public final LogoObject pSTOPTHREAD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 0);
        throw new ThrowException("STOPTHREAD");
    }

    public final LogoObject pTHREAD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1, 2);
        if (logoObjectArray.length == 1) {
            this.threadRunHelper(interpEnviron, logoObjectArray);
        } else {
            this.threadApplyHelper(interpEnviron, logoObjectArray);
        }
        return LogoVoid.obj;
    }

    public final LogoObject pTHREADAPPLY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.threadApplyHelper(interpEnviron, logoObjectArray);
        return LogoVoid.obj;
    }

    public final LogoObject pTHREADAPPLYID(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        return new LogoWord(this.threadApplyHelper(interpEnviron, logoObjectArray));
    }

    public final LogoObject pTHREADRUN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.threadRunHelper(interpEnviron, logoObjectArray);
        return LogoVoid.obj;
    }

    public final LogoObject pTHREADRUNID(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        return new LogoWord(this.threadRunHelper(interpEnviron, logoObjectArray));
    }

    public final LogoObject pTHREADTERMINATE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Thread name expected");
        }
        interpEnviron.mach().terminateOneThread(logoObjectArray[0].toCaselessString());
        return LogoVoid.obj;
    }

    private final String threadRunHelper(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1, 2);
        String string = null;
        LogoList logoList = null;
        if (logoObjectArray.length == 1) {
            if (!(logoObjectArray[0] instanceof LogoList)) {
                throw new LanguageException("Runnable list expected");
            }
            logoList = (LogoList)logoObjectArray[0];
        } else {
            if (!(logoObjectArray[0] instanceof LogoWord)) {
                throw new LanguageException("Thread ID expected");
            }
            string = logoObjectArray[0].toString();
            if (!(logoObjectArray[1] instanceof LogoList)) {
                throw new LanguageException("Runnable list expected");
            }
            logoList = (LogoList)logoObjectArray[1];
        }
        return this.makeThread(interpEnviron, string, logoList, null, null, null);
    }

    private final String threadApplyHelper(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2, 3);
        String string = null;
        LogoObject logoObject = null;
        LogoList logoList = null;
        if (logoObjectArray.length == 2) {
            logoObject = logoObjectArray[0];
            if (!(logoObjectArray[1] instanceof LogoList)) {
                throw new LanguageException("Argument list expected");
            }
            logoList = (LogoList)logoObjectArray[1];
        } else {
            if (!(logoObjectArray[0] instanceof LogoWord)) {
                throw new LanguageException("Thread ID expected");
            }
            string = logoObjectArray[0].toString();
            logoObject = logoObjectArray[1];
            if (!(logoObjectArray[2] instanceof LogoList)) {
                throw new LanguageException("Argument list expected");
            }
            logoList = (LogoList)logoObjectArray[2];
        }
        LogoList logoList2 = null;
        ParseTree parseTree = null;
        LogoList logoList3 = null;
        LogoList logoList4 = null;
        if (logoObject instanceof LogoWord) {
            ParseObject[] parseObjectArray = new ParseObject[1];
            int n = logoList.length();
            ParseObject[] parseObjectArray2 = new LogoObject[n];
            for (int i = 0; i < n; ++i) {
                parseObjectArray2[i] = logoList.pickInPlace(i);
            }
            CaselessString caselessString = logoObject.toCaselessString();
            Procedure procedure = interpEnviron.mach().resolveProc(caselessString);
            if (procedure != null) {
                parseObjectArray[0] = new ParseProcedure(procedure, parseObjectArray2);
            } else {
                PrimitiveSpec primitiveSpec = interpEnviron.mach().findPrimitive(caselessString);
                if (primitiveSpec != null) {
                    parseObjectArray[0] = new ParsePrimitive(primitiveSpec, caselessString.str, parseObjectArray2);
                } else {
                    throw new LanguageException("I don't know how to " + caselessString);
                }
            }
            parseTree = new ParseTree(0, parseObjectArray);
        } else {
            LogoList logoList5 = (LogoList)logoObject;
            if (logoList5.length() == 0 || !(logoList5.pickInPlace(0) instanceof LogoList)) {
                throw new LanguageException("Lambda list expected");
            }
            logoList3 = (LogoList)logoList5.pickInPlace(0);
            logoList2 = logoList5.length() == 2 && logoList5.pickInPlace(1) instanceof LogoList ? (LogoList)logoList5.pickInPlace(1) : (LogoList)logoList5.butFirst();
            logoList4 = logoList;
        }
        return this.makeThread(interpEnviron, string, logoList2, logoList3, logoList4, parseTree);
    }

    private final String makeThread(InterpEnviron interpEnviron, String string, LogoList logoList, LogoList logoList2, LogoList logoList3, ParseTree parseTree) throws LanguageException {
        SymbolTable symbolTable = new SymbolTable();
        if (logoList2 != null) {
            for (int i = 0; i < logoList3.length(); ++i) {
                if (!(logoList2.pickInPlace(i) instanceof LogoWord)) {
                    throw new LanguageException("Bad symbol list in lambda expression");
                }
                symbolTable.makeForced(logoList2.pickInPlace(i).toCaselessString(), logoList3.pickInPlace(i));
            }
        }
        if (string == null) {
            string = "__t" + interpEnviron.mach().getUniqueNum();
        }
        InterpreterThread interpreterThread = interpEnviron.thread();
        if (logoList != null) {
            interpEnviron.mach().spawnThread(new CaselessString(string), logoList, interpreterThread.inStreamID(), interpreterThread.inStream(), interpreterThread.outStreamID(), interpreterThread.outStream(), symbolTable);
        } else {
            interpEnviron.mach().spawnThread(new CaselessString(string), parseTree, interpreterThread.inStreamID(), interpreterThread.inStream(), interpreterThread.outStreamID(), interpreterThread.outStream(), symbolTable);
        }
        return string;
    }

    final class CriticalLock {
        private int _refCount = 0;

        CriticalLock() {
        }

        final synchronized void promote() {
            ++this._refCount;
        }

        final synchronized void demote() {
            --this._refCount;
        }

        final synchronized boolean unused() {
            return this._refCount == 0;
        }
    }

    final class Barrier {
        private int _maxThreads;
        private int _numThreads;
        private int _reqCount;

        Barrier(int n) {
            this._maxThreads = n;
            this._numThreads = 0;
            this._reqCount = 0;
        }

        final boolean checkRequest(int n) throws LanguageException {
            if (n != this._maxThreads) {
                throw new LanguageException("Mismatch in thread count");
            }
            ++this._reqCount;
            return this._reqCount >= this._maxThreads;
        }

        final synchronized void hit() {
            ++this._numThreads;
            if (this._numThreads >= this._maxThreads) {
                this.notifyAll();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

