/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOBase;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IORandom;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOStream;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Procedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ThrowException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Tokenizer;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.util.Vector;

public final class StandardPrimitives
extends PrimitiveGroup {
    private static final double _radToDeg = 57.29577951308232;
    private static final double _degToRad = Math.PI / 180;

    @Override
    protected void setup(Machine machine, Console console) throws SetupException {
        this.registerPrimitive("=", "pEQUALP", 2);
        this.registerPrimitive(">", "pGREATERP", 2);
        this.registerPrimitive("<", "pLESSP", 2);
        this.registerPrimitive(">=", "pGREATEREQUALP", 2);
        this.registerPrimitive("<=", "pLESSEQUALP", 2);
        this.registerPrimitive("+", "pSUM", 2);
        this.registerPrimitive("-", "pDIFFERENCE", 2);
        this.registerPrimitive("*", "pPRODUCT", 2);
        this.registerPrimitive("/", "pQUOTIENT", 2);
        this.registerPrimitive("ABS", "pABS", 1);
        this.registerPrimitive("ALLOF", "pALLOF", 2);
        this.registerPrimitive("ALLOPEN", "pALLOPEN", 0);
        this.registerPrimitive("AND", "pALLOF", 2);
        this.registerPrimitive("ANYOF", "pANYOF", 2);
        this.registerPrimitive("APPLY", "pAPPLY", 2);
        this.registerPrimitive("APPLYRESULT", "pAPPLYRESULT", 2);
        this.registerPrimitive("ARCCOS", "pARCCOS", 1);
        this.registerPrimitive("ARCSIN", "pARCSIN", 1);
        this.registerPrimitive("ARCTAN", "pARCTAN", 1);
        this.registerPrimitive("ARCTAN2", "pARCTAN2", 2);
        this.registerPrimitive("ASCII", "pASCII", 1);
        this.registerPrimitive("ASHIFT", "pASHIFT", 2);
        this.registerPrimitive("BEFORE?", "pBEFOREP", 2);
        this.registerPrimitive("BEFOREP", "pBEFOREP", 2);
        this.registerPrimitive("BF", "pBUTFIRST", 1);
        this.registerPrimitive("BITAND", "pBITAND", 2);
        this.registerPrimitive("BITNOT", "pBITNOT", 1);
        this.registerPrimitive("BITOR", "pBITOR", 2);
        this.registerPrimitive("BITXOR", "pBITXOR", 2);
        this.registerPrimitive("BL", "pBUTLAST", 1);
        this.registerPrimitive("BUTFIRST", "pBUTFIRST", 1);
        this.registerPrimitive("BUTLAST", "pBUTLAST", 1);
        this.registerPrimitive("BYE", "pGOODBYE", 0);
        this.registerPrimitive("CATCH", "pCATCH", 2);
        this.registerPrimitive("CHAR", "pCHAR", 1);
        this.registerPrimitive("CLOSE", "pCLOSE", 1);
        this.registerPrimitive("CONTENTS", "pCONTENTS", 0);
        this.registerPrimitive("COS", "pCOS", 1);
        this.registerPrimitive("DEFINE", "pDEFINE", 2);
        this.registerPrimitive("DEFINED?", "pDEFINEDP", 1);
        this.registerPrimitive("DEFINEDP", "pDEFINEDP", 1);
        this.registerPrimitive("DIFFERENCE", "pDIFFERENCE", 2);
        this.registerPrimitive("EDIT", "pEDIT", 1);
        this.registerPrimitive("EMPTY?", "pEMPTYP", 1);
        this.registerPrimitive("EMPTYP", "pEMPTYP", 1);
        this.registerPrimitive("EOF?", "pEOFP", 0);
        this.registerPrimitive("EOFP", "pEOFP", 0);
        this.registerPrimitive("EQUAL?", "pEQUALP", 2);
        this.registerPrimitive("EQUALP", "pEQUALP", 2);
        this.registerPrimitive("ERASE", "pERASE", 1);
        this.registerPrimitive("ERASENAME", "pERASENAME", 1);
        this.registerPrimitive("ERASEPLIST", "pERASEPLIST", 1);
        this.registerPrimitive("ERASEPROCEDURE", "pERASEPROCEDURE", 1);
        this.registerPrimitive("ERN", "pERASENAME", 1);
        this.registerPrimitive("ERP", "pERASEPROCEDURE", 1);
        this.registerPrimitive("ERPL", "pERASEPLIST", 1);
        this.registerPrimitive("EXP", "pEXP", 1);
        this.registerPrimitive("FALSE", "pFALSE", 0);
        this.registerPrimitive("FIRST", "pFIRST", 1);
        this.registerPrimitive("FPUT", "pFPUT", 2);
        this.registerPrimitive("GC", "pGC", 0);
        this.registerPrimitive("GOODBYE", "pGOODBYE", 0);
        this.registerPrimitive("GPROP", "pGPROP", 2);
        this.registerPrimitive("GREATER?", "pGREATERP", 2);
        this.registerPrimitive("GREATEREQUAL?", "pGREATEREQUALP", 2);
        this.registerPrimitive("GREATEREQUALP", "pGREATEREQUALP", 2);
        this.registerPrimitive("GREATERP", "pGREATERP", 2);
        this.registerPrimitive("IF", "pIF", 2);
        this.registerPrimitive("IFELSE", "pIFELSE", 3);
        this.registerPrimitive("IFF", "pIFFALSE", 1);
        this.registerPrimitive("IFFALSE", "pIFFALSE", 1);
        this.registerPrimitive("IFT", "pIFTRUE", 1);
        this.registerPrimitive("IFTRUE", "pIFTRUE", 1);
        this.registerPrimitive("IGNORE", "pIGNORE", 1);
        this.registerPrimitive("INTEGER", "pINTEGER", 1);
        this.registerPrimitive("INVOKE", "pINVOKE", 2);
        this.registerPrimitive("INVOKERESULT", "pINVOKERESULT", 2);
        this.registerPrimitive("ITEM", "pITEM", 2);
        this.registerPrimitive("KEY?", "pKEYP", 0);
        this.registerPrimitive("KEYP", "pKEYP", 0);
        this.registerPrimitive("LAST", "pLAST", 1);
        this.registerPrimitive("LENGTH", "pLENGTH", 1);
        this.registerPrimitive("LESS?", "pLESSP", 2);
        this.registerPrimitive("LESSEQUAL?", "pLESSEQUALP", 2);
        this.registerPrimitive("LESSEQUALP", "pLESSEQUALP", 2);
        this.registerPrimitive("LESSP", "pLESSP", 2);
        this.registerPrimitive("LIST", "pLIST", 2);
        this.registerPrimitive("LIST?", "pLISTP", 1);
        this.registerPrimitive("LISTP", "pLISTP", 1);
        this.registerPrimitive("LOCAL", "pLOCAL", 1);
        this.registerPrimitive("LOG", "pLOG", 1);
        this.registerPrimitive("LOWERCASE", "pLOWERCASE", 1);
        this.registerPrimitive("LPUT", "pLPUT", 2);
        this.registerPrimitive("LSHIFT", "pLSHIFT", 2);
        this.registerPrimitive("MACRO?", "pMACROP", 1);
        this.registerPrimitive("MACROP", "pMACROP", 1);
        this.registerPrimitive("MAKE", "pMAKE", 2);
        this.registerPrimitive("MEMBER?", "pMEMBERP", 2);
        this.registerPrimitive("MEMBERP", "pMEMBERP", 2);
        this.registerPrimitive("MINUS", "pMINUS", 1);
        this.registerPrimitive("NAME?", "pNAMEP", 1);
        this.registerPrimitive("NAMEP", "pNAMEP", 1);
        this.registerPrimitive("NAMES", "pNAMES", 0);
        this.registerPrimitive("NOT", "pNOT", 1);
        this.registerPrimitive("NUMBER?", "pNUMBERP", 1);
        this.registerPrimitive("NUMBERP", "pNUMBERP", 1);
        this.registerPrimitive("OP", "pOUTPUT", 1);
        this.registerPrimitive("OR", "pANYOF", 2);
        this.registerPrimitive("OUTPUT", "pOUTPUT", 1);
        this.registerPrimitive("PARSE", "pPARSE", 1);
        this.registerPrimitive("PI", "pPI", 0);
        this.registerPrimitive("PLISTS", "pPLISTS", 0);
        this.registerPrimitive("PO", "pPRINTOUT", 1);
        this.registerPrimitive("PON", "pPRINTOUTNAME", 1);
        this.registerPrimitive("POP", "pPRINTOUTPROCEDURE", 1);
        this.registerPrimitive("POPL", "pPRINTOUTPLIST", 1);
        this.registerPrimitive("POWER", "pPOWER", 2);
        this.registerPrimitive("PPROP", "pPPROP", 3);
        this.registerPrimitive("PR", "pPRINT", 1);
        this.registerPrimitive("PRIMITIVE?", "pPRIMITIVEP", 1);
        this.registerPrimitive("PRIMITIVEP", "pPRIMITIVEP", 1);
        this.registerPrimitive("PRINT", "pPRINT", 1);
        this.registerPrimitive("PRINT1", "pPRINT1", 1);
        this.registerPrimitive("PRINTOUT", "pPRINTOUT", 1);
        this.registerPrimitive("PRINTOUTNAME", "pPRINTOUTNAME", 1);
        this.registerPrimitive("PRINTOUTPLIST", "pPRINTOUTPLIST", 1);
        this.registerPrimitive("PRINTOUTPROCEDURE", "pPRINTOUTPROCEDURE", 1);
        this.registerPrimitive("PROCEDURE?", "pPROCEDUREP", 1);
        this.registerPrimitive("PROCEDUREP", "pPROCEDUREP", 1);
        this.registerPrimitive("PROCEDURES", "pPROCEDURES", 0);
        this.registerPrimitive("PRODUCT", "pPRODUCT", 2);
        this.registerPrimitive("QUOTIENT", "pQUOTIENT", 2);
        this.registerPrimitive("RADARCCOS", "pRADARCCOS", 1);
        this.registerPrimitive("RADARCSIN", "pRADARCSIN", 1);
        this.registerPrimitive("RADARCTAN", "pRADARCTAN", 1);
        this.registerPrimitive("RADARCTAN2", "pRADARCTAN2", 2);
        this.registerPrimitive("RADCOS", "pRADCOS", 1);
        this.registerPrimitive("RADSIN", "pRADSIN", 1);
        this.registerPrimitive("RADTAN", "pRADTAN", 1);
        this.registerPrimitive("RANDOM", "pRANDOM", 1);
        this.registerPrimitive("RANDOMIZE", "pRANDOMIZE", 0);
        this.registerPrimitive("RC", "pREADCHARACTER", 0);
        this.registerPrimitive("READCHARACTER", "pREADCHARACTER", 0);
        this.registerPrimitive("READER", "pREADER", 0);
        this.registerPrimitive("READLIST", "pREADLIST", 0);
        this.registerPrimitive("READWORD", "pREADWORD", 0);
        this.registerPrimitive("REMAINDER", "pREMAINDER", 2);
        this.registerPrimitive("REMPROP", "pREMPROP", 2);
        this.registerPrimitive("REPCOUNT", "pREPCOUNT", 0);
        this.registerPrimitive("REPEAT", "pREPEAT", 2);
        this.registerPrimitive("RERANDOM", "pRANDOMIZE", 0);
        this.registerPrimitive("RL", "pREADLIST", 0);
        this.registerPrimitive("ROUND", "pROUND", 1);
        this.registerPrimitive("RUN", "pRUN", 1);
        this.registerPrimitive("RUNRESULT", "pRUNRESULT", 1);
        this.registerPrimitive("RW", "pREADWORD", 0);
        this.registerPrimitive("SE", "pSENTENCE", 2);
        this.registerPrimitive("SENTENCE", "pSENTENCE", 2);
        this.registerPrimitive("SETREAD", "pSETREAD", 1);
        this.registerPrimitive("SETSTREAMPOS", "pSETSTREAMPOS", 2);
        this.registerPrimitive("SETWRITE", "pSETWRITE", 1);
        this.registerPrimitive("SHOW", "pSHOW", 1);
        this.registerPrimitive("SHOW1", "pSHOW1", 1);
        this.registerPrimitive("SIN", "pSIN", 1);
        this.registerPrimitive("SQRT", "pSQRT", 1);
        this.registerPrimitive("STOP", "pSTOP", 0);
        this.registerPrimitive("STREAMRANDOM?", "pSTREAMRANDOMP", 1);
        this.registerPrimitive("STREAMRANDOMP", "pSTREAMRANDOMP", 1);
        this.registerPrimitive("STREAMKIND", "pSTREAMKIND", 1);
        this.registerPrimitive("STREAMLENGTH", "pSTREAMLENGTH", 1);
        this.registerPrimitive("STREAMNAME", "pSTREAMNAME", 1);
        this.registerPrimitive("STREAMPOS", "pSTREAMPOS", 1);
        this.registerPrimitive("SUM", "pSUM", 2);
        this.registerPrimitive("TAN", "pTAN", 1);
        this.registerPrimitive("TEST", "pTEST", 1);
        this.registerPrimitive("TEXT", "pTEXT", 1);
        this.registerPrimitive("THING", "pTHING", 1);
        this.registerPrimitive("THROW", "pTHROW", 1);
        this.registerPrimitive("TOPLEVEL", "pTOPLEVEL", 0);
        this.registerPrimitive("TRUE", "pTRUE", 0);
        this.registerPrimitive("TRY", "pTRY", 3);
        this.registerPrimitive("TYPE", "pPRINT1", 1);
        this.registerPrimitive("UPPERCASE", "pUPPERCASE", 1);
        this.registerPrimitive("WAIT", "pWAIT", 1);
        this.registerPrimitive("WORD", "pWORD", 2);
        this.registerPrimitive("WORD?", "pWORDP", 1);
        this.registerPrimitive("WORDP", "pWORDP", 1);
        this.registerPrimitive("WRITER", "pWRITER", 0);
        console.putStatusMessage("Turtle Tracks standard primitives v1.0");
    }

    public final LogoObject pABS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.abs(logoObjectArray[0].toNumber()));
    }

    public final LogoObject pALLOF(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        boolean bl = true;
        for (int i = 0; i < logoObjectArray.length && bl; ++i) {
            bl = logoObjectArray[i].toBoolean() && bl;
        }
        return new LogoWord(bl);
    }

    public final LogoObject pALLOPEN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return interpEnviron.mach().getFileidList();
    }

    public final LogoObject pANYOF(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        boolean bl = false;
        for (int i = 0; i < logoObjectArray.length && !bl; ++i) {
            bl = logoObjectArray[i].toBoolean() || bl;
        }
        return new LogoWord(bl);
    }

    public final LogoObject pAPPLY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[1] instanceof LogoList)) {
            throw new LanguageException("Argument list expected");
        }
        if (logoObjectArray[0] instanceof LogoWord) {
            return StandardPrimitives.applyProc(interpEnviron, logoObjectArray[0].toCaselessString(), (LogoList)logoObjectArray[1]);
        }
        return StandardPrimitives.applyAnonymous(interpEnviron, (LogoList)logoObjectArray[0], (LogoList)logoObjectArray[1], true);
    }

    public final LogoObject pAPPLYRESULT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[1] instanceof LogoList)) {
            throw new LanguageException("Argument list expected");
        }
        LogoObject logoObject = logoObjectArray[0] instanceof LogoWord ? StandardPrimitives.applyProc(interpEnviron, logoObjectArray[0].toCaselessString(), (LogoList)logoObjectArray[1]) : StandardPrimitives.applyAnonymous(interpEnviron, (LogoList)logoObjectArray[0], (LogoList)logoObjectArray[1], true);
        if (logoObject == LogoVoid.obj) {
            return new LogoList();
        }
        LogoObject[] logoObjectArray2 = new LogoObject[]{logoObject};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pARCCOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        if (d < -1.0 || d > 1.0) {
            throw new LanguageException("Value out of range");
        }
        return new LogoWord(Math.acos(d) * 57.29577951308232);
    }

    public final LogoObject pARCSIN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        if (d < -1.0 || d > 1.0) {
            throw new LanguageException("Value out of range");
        }
        return new LogoWord(Math.asin(d) * 57.29577951308232);
    }

    public final LogoObject pARCTAN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.atan(logoObjectArray[0].toNumber()) * 57.29577951308232);
    }

    public final LogoObject pARCTAN2(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        return new LogoWord(Math.atan2(logoObjectArray[0].toNumber(), logoObjectArray[1].toNumber()) * 57.29577951308232);
    }

    public final LogoObject pASCII(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord) || logoObjectArray[0].length() != 1) {
            throw new LanguageException("Character expected");
        }
        return new LogoWord((double)logoObjectArray[0].toString().charAt(0));
    }

    public final LogoObject pASHIFT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        int n = logoObjectArray[0].toInteger();
        int n2 = logoObjectArray[1].toInteger();
        if (n2 > 0) {
            return new LogoWord(n << n2);
        }
        if (n2 < 0) {
            return new LogoWord(n >> -n2);
        }
        return logoObjectArray[0];
    }

    public final LogoObject pBEFOREP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoWord) || !(logoObjectArray[1] instanceof LogoWord)) {
            throw new LanguageException("Words expected");
        }
        return new LogoWord(CaselessString.staticCompare(logoObjectArray[0].toString(), logoObjectArray[1].toString()) < 0);
    }

    public final LogoObject pBITAND(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        int n = -1;
        for (int i = 0; i < logoObjectArray.length; ++i) {
            n &= logoObjectArray[i].toInteger();
        }
        return new LogoWord(n);
    }

    public final LogoObject pBITNOT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(~logoObjectArray[0].toInteger());
    }

    public final LogoObject pBITOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        int n = 0;
        for (int i = 0; i < logoObjectArray.length; ++i) {
            n |= logoObjectArray[i].toInteger();
        }
        return new LogoWord(n);
    }

    public final LogoObject pBITXOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        int n = 0;
        for (int i = 0; i < logoObjectArray.length; ++i) {
            n ^= logoObjectArray[i].toInteger();
        }
        return new LogoWord(n);
    }

    public final LogoObject pBUTFIRST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return logoObjectArray[0].butFirst();
    }

    public final LogoObject pBUTLAST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return logoObjectArray[0].butLast();
    }

    public final LogoObject pCATCH(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        try {
            return logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron);
        }
        catch (ThrowException throwException) {
            LogoWord logoWord = new LogoWord(throwException.getTag());
            if (logoObjectArray[0] instanceof LogoWord ? logoObjectArray[0].equals(logoWord) : logoObjectArray[0].length() == 0 || ((LogoList)logoObjectArray[0]).isMember(logoWord)) {
                return throwException.getObj();
            }
            throw throwException;
        }
        catch (LanguageException languageException) {
            LogoWord logoWord = new LogoWord("ERROR");
            if (logoObjectArray[0] instanceof LogoWord ? logoObjectArray[0].equals(logoWord) : logoObjectArray[0].length() == 0 || ((LogoList)logoObjectArray[0]).isMember(logoWord)) {
                return new Tokenizer(0).tokenize(languageException.getMessage());
            }
            throw languageException;
        }
    }

    public final LogoObject pCHAR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        int n = logoObjectArray[0].toInteger();
        if (n < 0 || n > 255) {
            throw new LanguageException("Value out of range");
        }
        char[] cArray = new char[]{(char)n};
        return new LogoWord(new String(cArray));
    }

    public final LogoObject pCLOSE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("File id expected");
        }
        interpEnviron.mach().closeIO(logoObjectArray[0].toCaselessString());
        return LogoVoid.obj;
    }

    public final LogoObject pCONTENTS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LogoObject[] logoObjectArray2 = new LogoObject[]{interpEnviron.mach().getProcList(), interpEnviron.mach().getNameList(), interpEnviron.mach().getPLists()};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pCOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.cos(logoObjectArray[0].toNumber() * (Math.PI / 180)));
    }

    public final LogoObject pDEFINE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Procedure name expected");
        }
        CaselessString caselessString = logoObjectArray[0].toCaselessString();
        Procedure.checkName(caselessString.str);
        if (!interpEnviron.mach().isOverridePrimitives() && interpEnviron.mach().isReserved(caselessString)) {
            throw new LanguageException("The name " + caselessString + " is a primitive");
        }
        if (!(logoObjectArray[1] instanceof LogoList) || logoObjectArray[1].length() < 2) {
            throw new LanguageException("Lambda list expected");
        }
        LogoList logoList = (LogoList)logoObjectArray[1];
        if (!(logoList.pickInPlace(0) instanceof LogoList)) {
            throw new LanguageException("First element in lambda list must be a parameter list");
        }
        Procedure.checkParamNames((LogoList)logoList.pickInPlace(0));
        if (logoList.pickInPlace(1) instanceof LogoList) {
            if (logoObjectArray[1].length() > 2) {
                throw new LanguageException("Too many elements in lambda list");
            }
            interpEnviron.mach().defineProc(new Procedure(interpEnviron.mach(), caselessString, (LogoList)logoList.pickInPlace(0), (LogoList)logoList.pickInPlace(1), false));
        } else {
            interpEnviron.mach().defineProc(new Procedure(interpEnviron.mach(), caselessString, (LogoList)logoList.pickInPlace(0), (LogoList)logoList.butFirst(), true));
        }
        return LogoVoid.obj;
    }

    public final LogoObject pDEFINEDP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(interpEnviron.mach().resolveProc(logoObjectArray[0].toCaselessString()) != null);
    }

    public final LogoObject pDIFFERENCE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        return new LogoWord(logoObjectArray[0].toNumber() - logoObjectArray[1].toNumber());
    }

    public final LogoObject pEDIT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0, 1);
        if (logoObjectArray.length == 0) {
            interpEnviron.mach().console().createEditor("");
        } else if (logoObjectArray[0] instanceof LogoWord) {
            CaselessString caselessString = logoObjectArray[0].toCaselessString();
            Procedure procedure = interpEnviron.mach().resolveProc(caselessString);
            if (procedure != null) {
                interpEnviron.mach().console().createEditor(procedure.toString());
            } else {
                Procedure.checkName(caselessString.str);
                interpEnviron.mach().console().createEditor("TO " + caselessString.str + Machine.LINE_SEPARATOR);
            }
        } else {
            if (logoObjectArray[0].length() != 3) {
                throw new LanguageException("Contents list expected");
            }
            StringWriter stringWriter = new StringWriter();
            IOStream iOStream = new IOStream(new BufferedWriter(stringWriter));
            interpEnviron.mach().printout(iOStream, ((LogoList)logoObjectArray[0]).pickInPlace(0), ((LogoList)logoObjectArray[0]).pickInPlace(1), ((LogoList)logoObjectArray[0]).pickInPlace(2));
            iOStream.close();
            interpEnviron.mach().console().createEditor(stringWriter.toString());
        }
        return LogoVoid.obj;
    }

    public final LogoObject pEMPTYP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(logoObjectArray[0].length() == 0);
    }

    public final LogoObject pEOFP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(interpEnviron.thread().inStream().eof());
    }

    public final LogoObject pEQUALP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        return new LogoWord(logoObjectArray[0].equals(logoObjectArray[1]));
    }

    public final LogoObject pERASE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoList) || logoObjectArray[0].length() != 3) {
            throw new LanguageException("Contents list expected");
        }
        this.eraseProcs(interpEnviron, ((LogoList)logoObjectArray[0]).pickInPlace(0));
        this.eraseNames(interpEnviron, ((LogoList)logoObjectArray[0]).pickInPlace(1));
        this.erasePLists(interpEnviron, ((LogoList)logoObjectArray[0]).pickInPlace(2));
        return LogoVoid.obj;
    }

    public final LogoObject pERASENAME(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        this.eraseNames(interpEnviron, logoObjectArray[0]);
        return LogoVoid.obj;
    }

    public final LogoObject pERASEPROCEDURE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        this.eraseProcs(interpEnviron, logoObjectArray[0]);
        return LogoVoid.obj;
    }

    public final LogoObject pERASEPLIST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        this.erasePLists(interpEnviron, logoObjectArray[0]);
        return LogoVoid.obj;
    }

    public final LogoObject pEXP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.exp(logoObjectArray[0].toNumber()));
    }

    public final LogoObject pFALSE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(false);
    }

    public final LogoObject pFIRST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return logoObjectArray[0].first();
    }

    public final LogoObject pFPUT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[1] instanceof LogoList)) {
            throw new LanguageException("List expected for inserting into");
        }
        return ((LogoList)logoObjectArray[1]).fput(logoObjectArray[0]);
    }

    public final LogoObject pGC(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        System.gc();
        return LogoVoid.obj;
    }

    public final LogoObject pGOODBYE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 0);
        throw new ThrowException("GOODBYE");
    }

    public final LogoObject pGPROP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Property list name expected");
        }
        if (!(logoObjectArray[1] instanceof LogoWord)) {
            throw new LanguageException("Property key expected");
        }
        return interpEnviron.mach().getProp(logoObjectArray[0].toCaselessString(), logoObjectArray[1].toCaselessString());
    }

    public final LogoObject pGREATERP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        return new LogoWord(logoObjectArray[0].toNumber() > logoObjectArray[1].toNumber());
    }

    public final LogoObject pGREATEREQUALP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        return new LogoWord(logoObjectArray[0].toNumber() >= logoObjectArray[1].toNumber());
    }

    public final LogoObject pIF(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2, 3);
        if (logoObjectArray[0].toBoolean()) {
            return logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron);
        }
        if (logoObjectArray.length == 3) {
            return logoObjectArray[2].getRunnable(interpEnviron.mach()).execute(interpEnviron);
        }
        return LogoVoid.obj;
    }

    public final LogoObject pIFELSE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 3);
        if (logoObjectArray[0].toBoolean()) {
            return logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron);
        }
        return logoObjectArray[2].getRunnable(interpEnviron.mach()).execute(interpEnviron);
    }

    public final LogoObject pIFFALSE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 1);
        if (!interpEnviron.getTestResult()) {
            return logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron);
        }
        return LogoVoid.obj;
    }

    public final LogoObject pIFTRUE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 1);
        if (interpEnviron.getTestResult()) {
            return logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron);
        }
        return LogoVoid.obj;
    }

    public final LogoObject pIGNORE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) {
        return LogoVoid.obj;
    }

    public final LogoObject pINTEGER(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        if (d < 0.0) {
            return new LogoWord(Math.ceil(d));
        }
        return new LogoWord(Math.floor(d));
    }

    public final LogoObject pINVOKE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testMinParams(logoObjectArray, 1);
        LogoObject[] logoObjectArray2 = new LogoObject[logoObjectArray.length - 1];
        for (int i = 1; i < logoObjectArray.length; ++i) {
            logoObjectArray2[i - 1] = logoObjectArray[i];
        }
        if (logoObjectArray[0] instanceof LogoWord) {
            return StandardPrimitives.applyProc(interpEnviron, logoObjectArray[0].toCaselessString(), new LogoList(logoObjectArray2));
        }
        return StandardPrimitives.applyAnonymous(interpEnviron, (LogoList)logoObjectArray[0], new LogoList(logoObjectArray2), true);
    }

    public final LogoObject pINVOKERESULT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testMinParams(logoObjectArray, 1);
        LogoObject[] logoObjectArray2 = new LogoObject[logoObjectArray.length - 1];
        for (int i = 1; i < logoObjectArray.length; ++i) {
            logoObjectArray2[i - 1] = logoObjectArray[i];
        }
        LogoObject logoObject = logoObjectArray[0] instanceof LogoWord ? StandardPrimitives.applyProc(interpEnviron, logoObjectArray[0].toCaselessString(), new LogoList(logoObjectArray2)) : StandardPrimitives.applyAnonymous(interpEnviron, (LogoList)logoObjectArray[0], new LogoList(logoObjectArray2), true);
        if (logoObject == LogoVoid.obj) {
            return new LogoList();
        }
        logoObjectArray2 = new LogoObject[]{logoObject};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pITEM(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        int n = logoObjectArray[0].toInteger();
        return logoObjectArray[1].pick(n);
    }

    public final LogoObject pKEYP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(interpEnviron.thread().inStream().charAvail());
    }

    public final LogoObject pLAST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return logoObjectArray[0].last();
    }

    public final LogoObject pLENGTH(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(logoObjectArray[0].length());
    }

    public final LogoObject pLESSP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        return new LogoWord(logoObjectArray[0].toNumber() < logoObjectArray[1].toNumber());
    }

    public final LogoObject pLESSEQUALP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        return new LogoWord(logoObjectArray[0].toNumber() <= logoObjectArray[1].toNumber());
    }

    public final LogoObject pLIST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        LogoObject[] logoObjectArray2 = new LogoObject[logoObjectArray.length];
        for (int i = 0; i < logoObjectArray.length; ++i) {
            logoObjectArray2[i] = logoObjectArray[i];
        }
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pLISTP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(logoObjectArray[0] instanceof LogoList);
    }

    public final LogoObject pLOCAL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testMinParams(logoObjectArray, 1);
        for (int i = 0; i < logoObjectArray.length; ++i) {
            if (logoObjectArray[i] instanceof LogoWord) {
                interpEnviron.thread().localName(logoObjectArray[i].toCaselessString());
                continue;
            }
            for (int j = 0; j < logoObjectArray[i].length(); ++j) {
                LogoObject logoObject = ((LogoList)logoObjectArray[i]).pickInPlace(j);
                if (!(logoObject instanceof LogoWord)) {
                    throw new LanguageException("Elements of list must be names");
                }
                interpEnviron.thread().localName(logoObject.toCaselessString());
            }
        }
        return LogoVoid.obj;
    }

    public final LogoObject pLOG(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        if (d <= 0.0) {
            throw new LanguageException("Value must be positive");
        }
        return new LogoWord(Math.log(d));
    }

    public final LogoObject pLOWERCASE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Word expected");
        }
        return new LogoWord(logoObjectArray[0].toString().toLowerCase());
    }

    public final LogoObject pLPUT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[1] instanceof LogoList)) {
            throw new LanguageException("List expected for inserting into");
        }
        return ((LogoList)logoObjectArray[1]).lput(logoObjectArray[0]);
    }

    public final LogoObject pLSHIFT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        int n = logoObjectArray[0].toInteger();
        int n2 = logoObjectArray[1].toInteger();
        if (n2 > 0) {
            return new LogoWord(n << n2);
        }
        if (n2 < 0) {
            return new LogoWord(n >>> -n2);
        }
        return logoObjectArray[0];
    }

    public final LogoObject pMACROP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        Procedure procedure = interpEnviron.mach().resolveProc(logoObjectArray[0].toCaselessString());
        if (procedure == null) {
            return new LogoWord(false);
        }
        return new LogoWord(procedure.isMacro());
    }

    public final LogoObject pMAKE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Name expected");
        }
        interpEnviron.thread().makeName(logoObjectArray[0].toCaselessString(), logoObjectArray[1]);
        return LogoVoid.obj;
    }

    public final LogoObject pMEMBERP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[1] instanceof LogoList)) {
            throw new LanguageException("List expected");
        }
        return new LogoWord(((LogoList)logoObjectArray[1]).isMember(logoObjectArray[0]));
    }

    public final LogoObject pMINUS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(-logoObjectArray[0].toNumber());
    }

    public final LogoObject pNAMEP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Name expected");
        }
        CaselessString caselessString = logoObjectArray[0].toCaselessString();
        LogoObject logoObject = interpEnviron.thread().resolveName(caselessString);
        if (logoObject == null) {
            return new LogoWord(false);
        }
        return new LogoWord(true);
    }

    public final LogoObject pNAMES(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LogoObject[] logoObjectArray2 = new LogoObject[]{new LogoList(), interpEnviron.mach().getNameList(), new LogoList()};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pNOT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(!logoObjectArray[0].toBoolean());
    }

    public final LogoObject pNUMBERP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        try {
            double d = logoObjectArray[0].toNumber();
            return new LogoWord(true);
        }
        catch (LanguageException languageException) {
            return new LogoWord(false);
        }
    }

    public final LogoObject pOUTPUT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 1);
        throw new ThrowException("STOP", logoObjectArray[0]);
    }

    public final LogoObject pPARSE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Word expected");
        }
        return new Tokenizer(0).tokenize(logoObjectArray[0].toString());
    }

    public final LogoObject pPI(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(Math.PI);
    }

    public final LogoObject pPLISTS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LogoObject[] logoObjectArray2 = new LogoObject[]{new LogoList(), new LogoList(), interpEnviron.mach().getPLists()};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pPOWER(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        try {
            double d = logoObjectArray[0].toNumber();
            double d2 = logoObjectArray[1].toNumber();
            if (d == 0.0 && d2 == 0.0 || d < 0.0 && d2 != (double)((int)d2)) {
                throw new LanguageException("Mathematically invalid exponent");
            }
            return new LogoWord(Math.pow(logoObjectArray[0].toNumber(), logoObjectArray[1].toNumber()));
        }
        catch (ArithmeticException arithmeticException) {
            throw new LanguageException(arithmeticException.toString());
        }
    }

    public final LogoObject pPPROP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 3);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Property list name expected");
        }
        CaselessString caselessString = logoObjectArray[0].toCaselessString();
        if (!(logoObjectArray[1] instanceof LogoWord)) {
            throw new LanguageException("Property key expected");
        }
        CaselessString caselessString2 = logoObjectArray[1].toCaselessString();
        interpEnviron.mach().putProp(caselessString, caselessString2, logoObjectArray[2]);
        return LogoVoid.obj;
    }

    public final LogoObject pPRIMITIVEP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(interpEnviron.mach().isReserved(logoObjectArray[0].toCaselessString()));
    }

    public final LogoObject pPRINT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < logoObjectArray.length; ++i) {
            if (logoObjectArray[i] instanceof LogoList) {
                stringBuffer.append(((LogoList)logoObjectArray[i]).toStringOpen());
            } else {
                stringBuffer.append(((LogoWord)logoObjectArray[i]).toString());
            }
            if (i >= logoObjectArray.length - 1) continue;
            stringBuffer.append(' ');
        }
        interpEnviron.thread().outStream().putLine(stringBuffer.toString());
        return LogoVoid.obj;
    }

    public final LogoObject pPRINT1(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < logoObjectArray.length; ++i) {
            if (logoObjectArray[i] instanceof LogoList) {
                stringBuffer.append(((LogoList)logoObjectArray[i]).toStringOpen());
                continue;
            }
            stringBuffer.append(((LogoWord)logoObjectArray[i]).toString());
        }
        interpEnviron.thread().outStream().put(stringBuffer.toString());
        return LogoVoid.obj;
    }

    public final LogoObject pPRINTOUT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoList) || logoObjectArray[0].length() != 3) {
            throw new LanguageException("Contents list expected");
        }
        interpEnviron.mach().printout(interpEnviron.thread().outStream(), ((LogoList)logoObjectArray[0]).pickInPlace(0), ((LogoList)logoObjectArray[0]).pickInPlace(1), ((LogoList)logoObjectArray[0]).pickInPlace(2));
        return LogoVoid.obj;
    }

    public final LogoObject pPRINTOUTNAME(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        interpEnviron.mach().printout(interpEnviron.thread().outStream(), LogoVoid.obj, logoObjectArray[0], LogoVoid.obj);
        return LogoVoid.obj;
    }

    public final LogoObject pPRINTOUTPROCEDURE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        interpEnviron.mach().printout(interpEnviron.thread().outStream(), logoObjectArray[0], LogoVoid.obj, LogoVoid.obj);
        return LogoVoid.obj;
    }

    public final LogoObject pPRINTOUTPLIST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        interpEnviron.mach().printout(interpEnviron.thread().outStream(), LogoVoid.obj, LogoVoid.obj, logoObjectArray[0]);
        return LogoVoid.obj;
    }

    public final LogoObject pPROCEDUREP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (interpEnviron.mach().isReserved(logoObjectArray[0].toCaselessString())) {
            return new LogoWord(true);
        }
        if (interpEnviron.mach().resolveProc(logoObjectArray[0].toCaselessString()) != null) {
            return new LogoWord(true);
        }
        return new LogoWord(false);
    }

    public final LogoObject pPROCEDURES(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LogoObject[] logoObjectArray2 = new LogoObject[]{interpEnviron.mach().getProcList(), new LogoList(), new LogoList()};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pPRODUCT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d = 1.0;
        for (int i = 0; i < logoObjectArray.length; ++i) {
            d *= logoObjectArray[i].toNumber();
        }
        return new LogoWord(d);
    }

    public final LogoObject pQUOTIENT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        double d = logoObjectArray[1].toNumber();
        if (d == 0.0) {
            throw new LanguageException("Division by zero");
        }
        return new LogoWord(logoObjectArray[0].toNumber() / d);
    }

    public final LogoObject pRADARCCOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        if (d < -1.0 || d > 1.0) {
            throw new LanguageException("Value out of range");
        }
        return new LogoWord(Math.acos(d));
    }

    public final LogoObject pRADARCSIN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        if (d < -1.0 || d > 1.0) {
            throw new LanguageException("Value out of range");
        }
        return new LogoWord(Math.asin(d));
    }

    public final LogoObject pRADARCTAN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.atan(logoObjectArray[0].toNumber()));
    }

    public final LogoObject pRADARCTAN2(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        return new LogoWord(Math.atan2(logoObjectArray[0].toNumber(), logoObjectArray[1].toNumber()));
    }

    public final LogoObject pRADCOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.cos(logoObjectArray[0].toNumber()));
    }

    public final LogoObject pRADSIN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.sin(logoObjectArray[0].toNumber()));
    }

    public final LogoObject pRADTAN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.tan(logoObjectArray[0].toNumber()));
    }

    public final LogoObject pRANDOM(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = interpEnviron.mach().random().nextDouble();
        return new LogoWord(Math.floor(d * (double)logoObjectArray[0].toInteger()));
    }

    public final LogoObject pRANDOMIZE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0, 1);
        long l = logoObjectArray.length == 1 ? (long)logoObjectArray[0].toInteger() : System.currentTimeMillis();
        interpEnviron.mach().random().setSeed(l);
        return LogoVoid.obj;
    }

    public final LogoObject pREADCHARACTER(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(new CaselessString(interpEnviron.thread().inStream().getChar()));
    }

    public final LogoObject pREADER(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        CaselessString caselessString = interpEnviron.thread().inStreamID();
        if (caselessString == null) {
            return new LogoWord(".CONSOLE");
        }
        return new LogoWord(caselessString);
    }

    public final LogoObject pREADLIST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        Console console = null;
        if (interpEnviron.thread().inStream() instanceof Console) {
            console = (Console)interpEnviron.thread().inStream();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Tokenizer tokenizer = new Tokenizer(0);
        while (true) {
            try {
                while (true) {
                    if (console != null && n != 0) {
                        stringBuffer.append(console.promptGetLine((char)n));
                    } else {
                        stringBuffer.append(interpEnviron.thread().inStream().getLine());
                    }
                    if (stringBuffer.length() == 0) {
                        return new LogoList();
                    }
                    if (stringBuffer.charAt(stringBuffer.length() - 1) != '~') break;
                    stringBuffer.setCharAt(stringBuffer.length() - 1, ' ');
                    n = 126;
                }
                return tokenizer.tokenize(stringBuffer.toString());
            }
            catch (LanguageException languageException) {
                n = languageException.getContChar();
                if (n == 124 || n == 92) {
                    stringBuffer.append(Machine.LINE_SEPARATOR);
                    continue;
                }
                if (n == 126) {
                    stringBuffer.append(' ');
                    continue;
                }
                throw languageException;
            }
            break;
        }
    }

    public final LogoObject pREADWORD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(interpEnviron.thread().inStream().getLine());
    }

    public final LogoObject pREMAINDER(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        int n = (int)Math.round(logoObjectArray[0].toNumber());
        int n2 = (int)Math.round(logoObjectArray[1].toNumber());
        if (n2 == 0) {
            throw new LanguageException("Division by zero");
        }
        return new LogoWord(n % n2);
    }

    public final LogoObject pREMPROP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Property list name expected");
        }
        if (!(logoObjectArray[1] instanceof LogoWord)) {
            throw new LanguageException("Property key expected");
        }
        interpEnviron.mach().remProp(logoObjectArray[0].toCaselessString(), logoObjectArray[1].toCaselessString());
        return LogoVoid.obj;
    }

    public final LogoObject pREPCOUNT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(interpEnviron.getLoopIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pREPEAT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        int n = logoObjectArray[0].toInteger();
        for (int i = 1; i <= n; ++i) {
            InterpEnviron interpEnviron2 = new InterpEnviron(interpEnviron.getTestState(), i, interpEnviron.thread());
            LogoObject logoObject = LogoVoid.obj;
            try {
                logoObject = logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron2);
            }
            finally {
                interpEnviron.setTestState(interpEnviron2.getTestState());
            }
            if (interpEnviron.mach().isAutoIgnore() || logoObject == LogoVoid.obj) continue;
            throw new LanguageException("You don't say what to do with " + logoObject.toString());
        }
        return LogoVoid.obj;
    }

    public final LogoObject pROUND(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.round(logoObjectArray[0].toNumber()));
    }

    public final LogoObject pRUN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 1);
        return logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron);
    }

    public final LogoObject pRUNRESULT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 1);
        LogoObject logoObject = logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron);
        if (logoObject == LogoVoid.obj) {
            return new LogoList();
        }
        LogoObject[] logoObjectArray2 = new LogoObject[]{logoObject};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pSENTENCE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        Vector<LogoObject> vector = new Vector<LogoObject>();
        for (int i = 0; i < logoObjectArray.length; ++i) {
            if (logoObjectArray[i] instanceof LogoWord) {
                vector.addElement(logoObjectArray[i]);
                continue;
            }
            for (int j = 0; j < logoObjectArray[i].length(); ++j) {
                vector.addElement(((LogoList)logoObjectArray[i]).pickInPlace(j));
            }
        }
        return new LogoList(vector);
    }

    public final LogoObject pSETREAD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (logoObjectArray[0] instanceof LogoList) {
            if (logoObjectArray[0].length() == 0) {
                interpEnviron.thread().setInStream(null, interpEnviron.mach().console());
                return LogoVoid.obj;
            }
        } else {
            CaselessString caselessString = logoObjectArray[0].toCaselessString();
            if (caselessString.equals(".CONSOLE")) {
                interpEnviron.thread().setInStream(null, interpEnviron.mach().console());
            } else {
                IOBase iOBase = interpEnviron.mach().getIO(caselessString);
                if (iOBase == null) {
                    throw new LanguageException("No such file");
                }
                interpEnviron.thread().setInStream(caselessString, iOBase);
            }
            return LogoVoid.obj;
        }
        throw new LanguageException("File id expected");
    }

    public final LogoObject pSETSTREAMPOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (logoObjectArray[0] instanceof LogoList && logoObjectArray[0].length() == 0) {
            throw new LanguageException("Stream .CONSOLE is not random access");
        }
        if (logoObjectArray[0] instanceof LogoWord) {
            IOBase iOBase = interpEnviron.mach().getIO(logoObjectArray[0].toCaselessString());
            if (iOBase == null) {
                throw new LanguageException("Stream " + logoObjectArray[0].toString() + " is closed");
            }
            if (!(iOBase instanceof IORandom)) {
                throw new LanguageException("Stream " + logoObjectArray[0].toString() + " is not random access");
            }
            ((IORandom)iOBase).seek(logoObjectArray[1].toInteger());
            return LogoVoid.obj;
        }
        throw new LanguageException("Stream id expected");
    }

    public final LogoObject pSETWRITE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (logoObjectArray[0] instanceof LogoList) {
            if (logoObjectArray[0].length() == 0) {
                interpEnviron.thread().setOutStream(null, interpEnviron.mach().console());
                return LogoVoid.obj;
            }
        } else {
            CaselessString caselessString = logoObjectArray[0].toCaselessString();
            if (caselessString.equals(".CONSOLE")) {
                interpEnviron.thread().setOutStream(null, interpEnviron.mach().console());
            } else {
                IOBase iOBase = interpEnviron.mach().getIO(caselessString);
                if (iOBase == null) {
                    throw new LanguageException("No such file");
                }
                interpEnviron.thread().setOutStream(caselessString, iOBase);
            }
            return LogoVoid.obj;
        }
        throw new LanguageException("File id expected");
    }

    public final LogoObject pSHOW(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < logoObjectArray.length; ++i) {
            stringBuffer.append(logoObjectArray[i].toString());
            if (i >= logoObjectArray.length - 1) continue;
            stringBuffer.append(' ');
        }
        interpEnviron.thread().outStream().putLine(stringBuffer.toString());
        return LogoVoid.obj;
    }

    public final LogoObject pSHOW1(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < logoObjectArray.length; ++i) {
            stringBuffer.append(logoObjectArray[i].toString());
        }
        interpEnviron.thread().outStream().put(stringBuffer.toString());
        return LogoVoid.obj;
    }

    public final LogoObject pSIN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.sin(logoObjectArray[0].toNumber() * (Math.PI / 180)));
    }

    public final LogoObject pSQRT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        double d = logoObjectArray[0].toNumber();
        if (d < 0.0) {
            throw new LanguageException("Value must be nonnegative");
        }
        return new LogoWord(Math.sqrt(d));
    }

    public final LogoObject pSTOP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 0);
        throw new ThrowException("STOP");
    }

    public final LogoObject pSTREAMRANDOMP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (logoObjectArray[0] instanceof LogoList && logoObjectArray[0].length() == 0) {
            return new LogoWord(false);
        }
        if (logoObjectArray[0] instanceof LogoWord) {
            IOBase iOBase = interpEnviron.mach().getIO(logoObjectArray[0].toCaselessString());
            if (iOBase == null) {
                throw new LanguageException("Stream " + logoObjectArray[0].toString() + " is closed");
            }
            return new LogoWord(iOBase instanceof IORandom);
        }
        throw new LanguageException("Stream id expected");
    }

    public final LogoObject pSTREAMKIND(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (logoObjectArray[0] instanceof LogoList) {
            if (logoObjectArray[0].length() == 0) {
                return new LogoWord("CONSOLE");
            }
        } else if (logoObjectArray[0] instanceof LogoWord) {
            if (logoObjectArray[0].toCaselessString().equals(".CONSOLE")) {
                return new LogoWord("CONSOLE");
            }
            IOBase iOBase = interpEnviron.mach().getIO(logoObjectArray[0].toCaselessString());
            if (iOBase == null) {
                return new LogoWord("CLOSED");
            }
            if (!iOBase.isOpen()) {
                return new LogoWord("CLOSED");
            }
            return iOBase.kind();
        }
        throw new LanguageException("Stream id expected");
    }

    public final LogoObject pSTREAMLENGTH(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (logoObjectArray[0] instanceof LogoList && logoObjectArray[0].length() == 0) {
            throw new LanguageException("Stream .CONSOLE is not random access");
        }
        if (logoObjectArray[0] instanceof LogoWord) {
            IOBase iOBase = interpEnviron.mach().getIO(logoObjectArray[0].toCaselessString());
            if (iOBase == null) {
                throw new LanguageException("Stream " + logoObjectArray[0].toString() + " is closed");
            }
            if (!(iOBase instanceof IORandom)) {
                throw new LanguageException("Stream " + logoObjectArray[0].toString() + " is not random access");
            }
            return new LogoWord(((IORandom)iOBase).length());
        }
        throw new LanguageException("Stream id expected");
    }

    public final LogoObject pSTREAMNAME(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (logoObjectArray[0] instanceof LogoList) {
            if (logoObjectArray[0].length() == 0) {
                return new LogoWord(interpEnviron.mach().console().getClass().getName());
            }
        } else if (logoObjectArray[0] instanceof LogoWord) {
            if (logoObjectArray[0].toCaselessString().equals(".CONSOLE")) {
                return new LogoWord(interpEnviron.mach().console().getClass().getName());
            }
            IOBase iOBase = interpEnviron.mach().getIO(logoObjectArray[0].toCaselessString());
            if (iOBase == null) {
                throw new LanguageException("Stream is closed");
            }
            return iOBase.name();
        }
        throw new LanguageException("Stream id expected");
    }

    public final LogoObject pSTREAMPOS(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (logoObjectArray[0] instanceof LogoList && logoObjectArray[0].length() == 0) {
            throw new LanguageException("Stream .CONSOLE is not random access");
        }
        if (logoObjectArray[0] instanceof LogoWord) {
            IOBase iOBase = interpEnviron.mach().getIO(logoObjectArray[0].toCaselessString());
            if (iOBase == null) {
                throw new LanguageException("Stream " + logoObjectArray[0].toString() + " is closed");
            }
            if (!(iOBase instanceof IORandom)) {
                throw new LanguageException("Stream " + logoObjectArray[0].toString() + " is not random access");
            }
            return new LogoWord(((IORandom)iOBase).tell());
        }
        throw new LanguageException("Stream id expected");
    }

    public final LogoObject pSUM(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        double d = 0.0;
        for (int i = 0; i < logoObjectArray.length; ++i) {
            d += logoObjectArray[i].toNumber();
        }
        return new LogoWord(d);
    }

    public final LogoObject pTAN(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(Math.tan(logoObjectArray[0].toNumber() * (Math.PI / 180)));
    }

    public final LogoObject pTEST(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        interpEnviron.setTestResult(logoObjectArray[0].toBoolean());
        return LogoVoid.obj;
    }

    public final LogoObject pTEXT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Procedure name expected");
        }
        CaselessString caselessString = logoObjectArray[0].toCaselessString();
        Procedure procedure = interpEnviron.mach().resolveProc(caselessString);
        if (procedure == null) {
            throw new LanguageException("I don't know how to " + caselessString);
        }
        LogoObject[] logoObjectArray2 = new LogoObject[]{procedure.getParams(), procedure.getCode()};
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pTHING(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Name expected");
        }
        CaselessString caselessString = logoObjectArray[0].toCaselessString();
        LogoObject logoObject = interpEnviron.thread().resolveName(caselessString);
        if (logoObject == null) {
            throw new LanguageException(caselessString.str + " has no value");
        }
        return logoObject;
    }

    public final LogoObject pTHROW(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 1, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Tag expected");
        }
        LogoObject logoObject = LogoVoid.obj;
        if (logoObjectArray.length == 2) {
            logoObject = logoObjectArray[1];
        }
        if (logoObjectArray[0].toCaselessString().equals("ERROR")) {
            if (logoObject instanceof LogoList) {
                throw new LanguageException(((LogoList)logoObject).toStringOpen());
            }
            if (logoObject instanceof LogoWord) {
                throw new LanguageException(logoObject.toString());
            }
            throw new LanguageException("User error");
        }
        throw new ThrowException(logoObjectArray[0].toString(), logoObject);
    }

    public final LogoObject pTOPLEVEL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 0);
        throw new ThrowException("TOPLEVEL");
    }

    public final LogoObject pTRUE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord(true);
    }

    public final LogoObject pTRY(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testMinParams(logoObjectArray, 1);
        if (logoObjectArray.length % 2 == 0) {
            throw new LanguageException("Even number of arguments");
        }
        LogoObject logoObject = LogoVoid.obj;
        try {
            logoObject = logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron);
        }
        catch (ThrowException throwException) {
            logoObject = this.parseCatches(interpEnviron, logoObjectArray, throwException, null);
        }
        catch (LanguageException languageException) {
            logoObject = this.parseCatches(interpEnviron, logoObjectArray, null, languageException);
        }
        return logoObject;
    }

    public final LogoObject pUPPERCASE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Word expected");
        }
        return new LogoWord(logoObjectArray[0].toString().toUpperCase());
    }

    public final LogoObject pWAIT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        int n = logoObjectArray[0].toInteger();
        if (n < 0) {
            throw new LanguageException("Time interval is negative");
        }
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return LogoVoid.obj;
    }

    public final LogoObject pWORD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < logoObjectArray.length; ++i) {
            if (!(logoObjectArray[i] instanceof LogoWord)) {
                throw new LanguageException("Word expected");
            }
            stringBuffer.append(logoObjectArray[i].toString());
        }
        return new LogoWord(stringBuffer.toString());
    }

    public final LogoObject pWORDP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        return new LogoWord(logoObjectArray[0] instanceof LogoWord);
    }

    public final LogoObject pWRITER(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        CaselessString caselessString = interpEnviron.thread().outStreamID();
        if (caselessString == null) {
            return new LogoWord(".CONSOLE");
        }
        return new LogoWord(caselessString);
    }

    private final void eraseNames(InterpEnviron interpEnviron, LogoObject logoObject) throws LanguageException {
        if (logoObject instanceof LogoWord) {
            interpEnviron.thread().eraseName(logoObject.toCaselessString());
        } else {
            for (int i = 0; i < logoObject.length(); ++i) {
                LogoObject logoObject2 = ((LogoList)logoObject).pickInPlace(i);
                if (!(logoObject2 instanceof LogoWord)) {
                    throw new LanguageException("Name expected");
                }
                interpEnviron.thread().eraseName(logoObject2.toCaselessString());
            }
        }
    }

    private final void eraseProcs(InterpEnviron interpEnviron, LogoObject logoObject) throws LanguageException {
        if (logoObject instanceof LogoWord) {
            interpEnviron.mach().eraseProc(logoObject.toCaselessString());
        } else {
            for (int i = 0; i < logoObject.length(); ++i) {
                LogoObject logoObject2 = ((LogoList)logoObject).pickInPlace(i);
                if (!(logoObject2 instanceof LogoWord)) {
                    throw new LanguageException("Procedure title expected");
                }
                interpEnviron.mach().eraseProc(logoObject2.toCaselessString());
            }
        }
    }

    private final void erasePList(InterpEnviron interpEnviron, CaselessString caselessString) throws LanguageException {
        LogoList logoList = interpEnviron.mach().getPropsInList(caselessString);
        for (int i = 0; i < logoList.length(); ++i) {
            interpEnviron.mach().remProp(caselessString, logoList.pickInPlace(i).toCaselessString());
        }
    }

    private final void erasePLists(InterpEnviron interpEnviron, LogoObject logoObject) throws LanguageException {
        if (logoObject instanceof LogoWord) {
            this.erasePList(interpEnviron, logoObject.toCaselessString());
        } else {
            for (int i = 0; i < logoObject.length(); ++i) {
                LogoObject logoObject2 = ((LogoList)logoObject).pickInPlace(i);
                if (!(logoObject2 instanceof LogoWord)) {
                    throw new LanguageException("Property list name expected");
                }
                this.erasePList(interpEnviron, logoObject2.toCaselessString());
            }
        }
    }

    private final LogoObject parseCatches(InterpEnviron interpEnviron, LogoObject[] logoObjectArray, ThrowException throwException, LanguageException languageException) throws LanguageException, ThrowException {
        Tokenizer tokenizer = new Tokenizer(0);
        boolean bl = false;
        LogoObject logoObject = LogoVoid.obj;
        LogoVoid logoVoid = LogoVoid.obj;
        LogoVoid logoVoid2 = LogoVoid.obj;
        for (int i = 1; i < logoObjectArray.length && !bl; i += 2) {
            LogoWord logoWord = throwException != null ? new LogoWord(throwException.getTag()) : new LogoWord("ERROR");
            if (!(logoObjectArray[i] instanceof LogoWord) ? logoObjectArray[i].length() != 0 && !((LogoList)logoObjectArray[i]).isMember(logoWord) : !logoObjectArray[i].equals(logoWord)) continue;
            if (logoObjectArray[i + 1] instanceof LogoList && (logoObjectArray[i + 1].length() == 0 || !(((LogoList)logoObjectArray[i + 1]).pickInPlace(0) instanceof LogoList))) {
                logoObject = logoObjectArray[i + 1].getRunnable(interpEnviron.mach()).execute(interpEnviron);
            } else {
                LogoObject[] logoObjectArray2 = new LogoObject[]{logoWord, throwException != null ? throwException.getObj() : tokenizer.tokenize(languageException.getMessage())};
                logoObject = logoObjectArray[i + 1] instanceof LogoWord ? StandardPrimitives.applyProc(interpEnviron, logoObjectArray[i + 1].toCaselessString(), new LogoList(logoObjectArray2)) : StandardPrimitives.applyAnonymous(interpEnviron, (LogoList)logoObjectArray[i + 1], new LogoList(logoObjectArray2), false);
            }
            bl = true;
        }
        if (!bl) {
            if (throwException != null) {
                throw throwException;
            }
            if (languageException != null) {
                throw languageException;
            }
        }
        return logoObject;
    }
}

