/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOStream;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ThrowException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Tokenizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public final class ShellPrimitives
extends PrimitiveGroup {
    private static final int READ_BUFFER_SIZE = 256;

    @Override
    protected void setup(Machine machine, Console console) throws SetupException {
        this.registerPrimitive("EXEC", "pEXEC", 1);
        this.registerPrimitive("EXECASYNC", "pEXECASYNC", 1);
        this.registerPrimitive("SHELL", "pSHELL", 1);
        console.putStatusMessage("Turtle Tracks shell primitives v1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pEXEC(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1, 2);
        String[] stringArray = null;
        String string = null;
        if (logoObjectArray.length == 2) {
            if (!(logoObjectArray[1] instanceof LogoWord)) {
                throw new LanguageException("Environment property list expected");
            }
            stringArray = interpEnviron.mach().getPropsForExec(logoObjectArray[1].toCaselessString());
        }
        string = logoObjectArray[0] instanceof LogoList ? ((LogoList)logoObjectArray[0]).toStringOpen() : logoObjectArray[0].toString();
        try {
            Process process = Runtime.getRuntime().exec(string, stringArray);
            try {
                int n = 0;
                OutputStream outputStream = process.getOutputStream();
                InputStream inputStream = process.getInputStream();
                InputStream inputStream2 = process.getErrorStream();
                if (outputStream == null || inputStream == null || inputStream2 == null) {
                    try {
                        n = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    IOStream iOStream = new IOStream(new BufferedWriter(new OutputStreamWriter(outputStream)));
                    IOStream iOStream2 = new IOStream(new BufferedReader(new InputStreamReader(inputStream)));
                    IOStream iOStream3 = new IOStream(new BufferedReader(new InputStreamReader(inputStream2)));
                    try {
                        int n2;
                        boolean bl = false;
                        char[] cArray = new char[256];
                        while (!bl) {
                            n2 = iOStream3.getAvailable(cArray);
                            while (n2 > 0) {
                                interpEnviron.thread().outStream().put(cArray, n2);
                                Thread.yield();
                                n2 = iOStream3.getAvailable(cArray);
                            }
                            n2 = iOStream2.getAvailable(cArray);
                            while (n2 > 0) {
                                interpEnviron.thread().outStream().put(cArray, n2);
                                Thread.yield();
                                n2 = iOStream2.getAvailable(cArray);
                            }
                            n2 = interpEnviron.thread().inStream().getAvailable(cArray);
                            while (n2 > 0) {
                                iOStream.put(cArray, n2);
                                Thread.yield();
                                n2 = interpEnviron.thread().inStream().getAvailable(cArray);
                            }
                            try {
                                n = process.exitValue();
                                bl = true;
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                // empty catch block
                            }
                            Thread.yield();
                        }
                        while (!iOStream3.eof()) {
                            n2 = iOStream3.getAvailable(cArray);
                            if (n2 <= 0) continue;
                            interpEnviron.thread().outStream().put(cArray, n2);
                        }
                        while (!iOStream2.eof()) {
                            n2 = iOStream2.getAvailable(cArray);
                            if (n2 <= 0) continue;
                            interpEnviron.thread().outStream().put(cArray, n2);
                        }
                    }
                    finally {
                        iOStream.close();
                        iOStream2.close();
                        iOStream3.close();
                    }
                }
                return new LogoWord(n);
            }
            catch (Exception exception) {
                process.destroy();
                throw new LanguageException("Error while running: " + exception.toString());
            }
        }
        catch (IOException iOException) {
            throw new LanguageException("I/O Error while launching process");
        }
        catch (SecurityException securityException) {
            throw new LanguageException("Security prevented launching process");
        }
    }

    public final LogoObject pEXECASYNC(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1, 2);
        String[] stringArray = null;
        String string = null;
        if (logoObjectArray.length == 2) {
            if (!(logoObjectArray[1] instanceof LogoWord)) {
                throw new LanguageException("Environment property list expected");
            }
            stringArray = interpEnviron.mach().getPropsForExec(logoObjectArray[1].toCaselessString());
        }
        string = logoObjectArray[0] instanceof LogoList ? ((LogoList)logoObjectArray[0]).toStringOpen() : logoObjectArray[0].toString();
        try {
            Process process = Runtime.getRuntime().exec(string, stringArray);
            return LogoVoid.obj;
        }
        catch (IOException iOException) {
            throw new LanguageException("I/O Error while launching process");
        }
        catch (SecurityException securityException) {
            throw new LanguageException("Security prevented launching process");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSHELL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 1, 2);
        String[] stringArray = null;
        String string = null;
        if (logoObjectArray.length == 2) {
            if (!(logoObjectArray[1] instanceof LogoWord)) {
                throw new LanguageException("Environment property list expected");
            }
            stringArray = interpEnviron.mach().getPropsForExec(logoObjectArray[1].toCaselessString());
        }
        string = logoObjectArray[0] instanceof LogoList ? ((LogoList)logoObjectArray[0]).toStringOpen() : logoObjectArray[0].toString();
        try {
            Process process = Runtime.getRuntime().exec(string, stringArray);
            try {
                InputStream inputStream = process.getInputStream();
                InputStream inputStream2 = process.getErrorStream();
                if (inputStream == null || inputStream2 == null) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return new LogoList();
                }
                IOStream iOStream = new IOStream(new BufferedReader(new InputStreamReader(inputStream)));
                IOStream iOStream2 = new IOStream(new BufferedReader(new InputStreamReader(inputStream2)));
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    int n;
                    boolean bl = false;
                    char[] cArray = new char[256];
                    while (!bl) {
                        n = iOStream2.getAvailable(cArray);
                        while (n > 0) {
                            interpEnviron.thread().outStream().put(cArray, n);
                            Thread.yield();
                            n = iOStream2.getAvailable(cArray);
                        }
                        n = iOStream.getAvailable(cArray);
                        while (n > 0) {
                            stringBuffer.append(cArray, 0, n);
                            Thread.yield();
                            n = iOStream.getAvailable(cArray);
                        }
                        try {
                            process.exitValue();
                            bl = true;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            // empty catch block
                        }
                        Thread.yield();
                    }
                    while (!iOStream2.eof()) {
                        n = iOStream2.getAvailable(cArray);
                        if (n <= 0) continue;
                        interpEnviron.thread().outStream().put(cArray, n);
                    }
                    while (!iOStream.eof()) {
                        n = iOStream.getAvailable(cArray);
                        if (n <= 0) continue;
                        stringBuffer.append(cArray, 0, n);
                    }
                }
                finally {
                    iOStream.close();
                    iOStream2.close();
                }
                return new Tokenizer(0).tokenize(new String(stringBuffer));
            }
            catch (Exception exception) {
                process.destroy();
                throw new LanguageException("Error while running: " + exception.toString());
            }
        }
        catch (IOException iOException) {
            throw new LanguageException("I/O Error while launching process");
        }
        catch (SecurityException securityException) {
            throw new LanguageException("Security prevented launching process");
        }
    }
}

