/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOSocket;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOURL;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ThrowException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;

public final class NetworkPrimitives
extends PrimitiveGroup {
    @Override
    protected void setup(Machine machine, Console console) throws SetupException {
        this.registerPrimitive("LOADURL", "pLOADURL", 1);
        this.registerPrimitive("OPENSOCKET", "pOPENSOCKET", 2);
        this.registerPrimitive("OPENURL", "pOPENURL", 1);
        this.registerPrimitive("SERVERSOCKET", "pSERVERSOCKET", 4);
        console.putStatusMessage("Turtle Tracks networking primitives v1.0");
    }

    public final LogoObject pLOADURL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("URL expected");
        }
        if (interpEnviron.thread().isLoading()) {
            throw new LanguageException("Attempt to load from within a load");
        }
        interpEnviron.mach().executeStream(new IOURL(logoObjectArray[0].toString()), interpEnviron.thread());
        return LogoVoid.obj;
    }

    public final LogoObject pOPENSOCKET(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        CaselessString caselessString;
        this.testNumParams(logoObjectArray, 2, 3);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Hostname expected");
        }
        if (logoObjectArray.length == 3) {
            if (!(logoObjectArray[2] instanceof LogoWord)) {
                throw new LanguageException("Stream id expected");
            }
            caselessString = logoObjectArray[2].toCaselessString();
        } else {
            caselessString = new CaselessString("__f" + interpEnviron.mach().getUniqueNum());
        }
        interpEnviron.mach().registerIO(caselessString, new IOSocket(logoObjectArray[0].toString(), logoObjectArray[1].toInteger()));
        if (logoObjectArray.length == 3) {
            return LogoVoid.obj;
        }
        return new LogoWord(caselessString);
    }

    public final LogoObject pOPENURL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        CaselessString caselessString;
        this.testNumParams(logoObjectArray, 1, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("URL expected");
        }
        if (logoObjectArray.length == 2) {
            if (!(logoObjectArray[1] instanceof LogoWord)) {
                throw new LanguageException("Stream id expected");
            }
            caselessString = logoObjectArray[1].toCaselessString();
        } else {
            caselessString = new CaselessString("__f" + interpEnviron.mach().getUniqueNum());
        }
        interpEnviron.mach().registerIO(caselessString, new IOURL(logoObjectArray[0].toString()));
        if (logoObjectArray.length == 2) {
            return LogoVoid.obj;
        }
        return new LogoWord(caselessString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pSERVERSOCKET(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 4);
        try {
            ServerSocket serverSocket = new ServerSocket(logoObjectArray[0].toInteger());
            try {
                serverSocket.setSoTimeout(logoObjectArray[2].toInteger());
                boolean bl = true;
                while (bl) {
                    LogoObject logoObject = LogoVoid.obj;
                    try {
                        IOSocket iOSocket = new IOSocket(serverSocket.accept());
                        CaselessString caselessString = new CaselessString("__f" + interpEnviron.mach().getUniqueNum());
                        interpEnviron.mach().registerIO(caselessString, iOSocket);
                        LogoObject[] logoObjectArray2 = new LogoObject[]{new LogoWord(caselessString)};
                        if (logoObjectArray[1] instanceof LogoList) {
                            logoObject = NetworkPrimitives.applyAnonymous(interpEnviron, (LogoList)logoObjectArray[1], new LogoList(logoObjectArray2), false);
                        } else if (logoObjectArray[1] instanceof LogoWord) {
                            logoObject = NetworkPrimitives.applyProc(interpEnviron, logoObjectArray[1].toCaselessString(), new LogoList(logoObjectArray2));
                        } else {
                            throw new LanguageException("Lambda expected");
                        }
                        if (!interpEnviron.mach().isAutoIgnore() && logoObject != LogoVoid.obj) {
                            throw new LanguageException("You don't say what to do with " + logoObject.toString());
                        }
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (IOException iOException) {
                        throw new LanguageException("Can't accept socket: " + iOException.getMessage());
                    }
                    if (logoObjectArray[3] instanceof LogoList) {
                        logoObject = NetworkPrimitives.applyAnonymous(interpEnviron, (LogoList)logoObjectArray[3], new LogoList(), false);
                    } else if (logoObjectArray[3] instanceof LogoWord) {
                        logoObject = NetworkPrimitives.applyProc(interpEnviron, logoObjectArray[3].toCaselessString(), new LogoList());
                    } else {
                        throw new LanguageException("Lambda expected");
                    }
                    bl = logoObject.toBoolean();
                }
            }
            finally {
                serverSocket.close();
            }
        }
        catch (IOException iOException) {
            throw new LanguageException("Can't open server socket: " + iOException.getMessage());
        }
        return LogoVoid.obj;
    }
}

