/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParsePrimitive;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseProcedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseTree;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveSpec;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Procedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SymbolTable;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ThrowException;
import java.util.Random;

public final class LibraryPrimitives
extends PrimitiveGroup {
    private int _gensymNum;
    private static Random _rand = new Random();

    @Override
    protected void setup(Machine machine, Console console) throws SetupException {
        this.registerPrimitive("CLOSEALL", "pCLOSEALL", 0);
        this.registerPrimitive("DO.UNTIL", "pDOUNTIL", 2);
        this.registerPrimitive("DO.WHILE", "pDOWHILE", 2);
        this.registerPrimitive("ERALL", "pERALL", 0);
        this.registerPrimitive("FOR", "pFOR", 2);
        this.registerPrimitive("FOREACH", "pFOREACH", 2);
        this.registerPrimitive("GENSYM", "pGENSYM", 0);
        this.registerPrimitive("LOCALMAKE", "pLOCALMAKE", 2);
        this.registerPrimitive("MAP", "pMAP", 2);
        this.registerPrimitive("NAME", "pNAME", 2);
        this.registerPrimitive("PICK", "pPICK", 1);
        this.registerPrimitive("POALL", "pPOALL", 0);
        this.registerPrimitive("QSORT", "pQSORT", 2);
        this.registerPrimitive("UNTIL", "pUNTIL", 2);
        this.registerPrimitive("WHILE", "pWHILE", 2);
        this._gensymNum = 0;
        console.putStatusMessage("Turtle Tracks library primitives v1.0");
    }

    public final LogoObject pCLOSEALL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        interpEnviron.mach().closeAllIO();
        return LogoVoid.obj;
    }

    public final LogoObject pDOUNTIL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        do {
            LogoObject logoObject = logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron);
            if (interpEnviron.mach().isAutoIgnore() || logoObject == LogoVoid.obj) continue;
            throw new LanguageException("You don't say what to do with " + logoObject.toString());
        } while (!logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron).toBoolean());
        return LogoVoid.obj;
    }

    public final LogoObject pDOWHILE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        do {
            LogoObject logoObject = logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron);
            if (interpEnviron.mach().isAutoIgnore() || logoObject == LogoVoid.obj) continue;
            throw new LanguageException("You don't say what to do with " + logoObject.toString());
        } while (logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron).toBoolean());
        return LogoVoid.obj;
    }

    public final LogoObject pERALL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        interpEnviron.mach().eraseAll();
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pFOR(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoList) || logoObjectArray[0].length() < 3 || logoObjectArray[0].length() > 4) {
            throw new LanguageException("Control list expected");
        }
        LogoList logoList = (LogoList)logoObjectArray[0];
        if (!(logoList.pickInPlace(0) instanceof LogoWord)) {
            throw new LanguageException("Step=0 in control list");
        }
        int n = logoList.pickInPlace(1).toInteger();
        int n2 = logoList.pickInPlace(2).toInteger();
        int n3 = 1;
        if (logoList.length() == 4 && (n3 = logoList.pickInPlace(3).toInteger()) == 0) {
            throw new LanguageException("Step=0 in control list");
        }
        SymbolTable symbolTable = new SymbolTable();
        CaselessString caselessString = logoList.pickInPlace(0).toCaselessString();
        symbolTable.makeForced(caselessString, new LogoWord(n));
        interpEnviron.thread().enterProcedure(symbolTable);
        try {
            int n4 = n;
            while (!(n3 <= 0 && n4 < n2 || n3 >= 0 && n4 > n2)) {
                LogoObject logoObject = logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron);
                if (!interpEnviron.mach().isAutoIgnore() && logoObject != LogoVoid.obj) {
                    throw new LanguageException("You don't say what to do with " + logoObject.toString());
                }
                LogoObject logoObject2 = symbolTable.resolve(caselessString);
                if (logoObject2 == null) {
                    throw new LanguageException("Loop control variable erased.");
                }
                n4 = logoObject2.toInteger() + n3;
                symbolTable.makeForced(caselessString, new LogoWord(n4));
            }
        }
        finally {
            interpEnviron.thread().exitProcedure();
        }
        return LogoVoid.obj;
    }

    public final LogoObject pFOREACH(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testMinParams(logoObjectArray, 2);
        LogoList[] logoListArray = new LogoList[logoObjectArray.length - 1];
        for (int i = 0; i < logoObjectArray.length - 1; ++i) {
            if (!(logoObjectArray[i] instanceof LogoList)) {
                throw new LanguageException("Mapping list expected");
            }
            logoListArray[i] = (LogoList)logoObjectArray[i];
        }
        LibraryPrimitives.mapHelper(interpEnviron, logoObjectArray[logoObjectArray.length - 1], logoListArray, null);
        return LogoVoid.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoObject pGENSYM(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        LibraryPrimitives libraryPrimitives = this;
        synchronized (libraryPrimitives) {
            ++this._gensymNum;
            return new LogoWord("." + String.valueOf(this._gensymNum));
        }
    }

    public final LogoObject pLOCALMAKE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Name expected");
        }
        interpEnviron.thread().localName(logoObjectArray[0].toCaselessString());
        interpEnviron.thread().makeName(logoObjectArray[0].toCaselessString(), logoObjectArray[1]);
        return LogoVoid.obj;
    }

    public final LogoObject pMAP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testMinParams(logoObjectArray, 2);
        LogoList[] logoListArray = new LogoList[logoObjectArray.length - 1];
        for (int i = 1; i < logoObjectArray.length; ++i) {
            if (!(logoObjectArray[i] instanceof LogoList)) {
                throw new LanguageException("Mapping list expected");
            }
            logoListArray[i - 1] = (LogoList)logoObjectArray[i];
        }
        LogoObject[] logoObjectArray2 = new LogoObject[logoObjectArray[1].length()];
        int n = LibraryPrimitives.mapHelper(interpEnviron, logoObjectArray[0], logoListArray, logoObjectArray2);
        LogoObject[] logoObjectArray3 = new LogoObject[n];
        System.arraycopy(logoObjectArray2, 0, logoObjectArray3, 0, n);
        return new LogoList(logoObjectArray3);
    }

    public final LogoObject pNAME(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[1] instanceof LogoWord)) {
            throw new LanguageException("Name expected");
        }
        interpEnviron.thread().makeName(logoObjectArray[1].toCaselessString(), logoObjectArray[0]);
        return LogoVoid.obj;
    }

    public final LogoObject pPICK(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        int n = logoObjectArray[0].length();
        if (n == 0) {
            throw new LanguageException("List or word is empty");
        }
        int n2 = interpEnviron.mach().random().nextInt();
        if (n2 < 0) {
            n2 &= Integer.MAX_VALUE;
        }
        return logoObjectArray[0].pick(n2 % n + 1);
    }

    public final LogoObject pPOALL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        interpEnviron.mach().printout(interpEnviron.thread().outStream(), null, null, null);
        return LogoVoid.obj;
    }

    public final LogoObject pQSORT(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        if (!(logoObjectArray[0] instanceof LogoList)) {
            throw new LanguageException("List expected");
        }
        LogoList logoList = (LogoList)logoObjectArray[0];
        LogoObject[] logoObjectArray2 = new LogoObject[logoList.length()];
        for (int i = 0; i < logoList.length(); ++i) {
            logoObjectArray2[i] = logoList.pickInPlace(i);
        }
        if (logoObjectArray[1] instanceof LogoList) {
            LibraryPrimitives.qsortHelper(interpEnviron, logoObjectArray2, 0, logoList.length(), (LogoList)logoObjectArray[1], null, null, null);
        } else {
            CaselessString caselessString = logoObjectArray[1].toCaselessString();
            Procedure procedure = interpEnviron.mach().resolveProc(caselessString);
            if (procedure != null) {
                LibraryPrimitives.qsortHelper(interpEnviron, logoObjectArray2, 0, logoList.length(), null, procedure, null, null);
            } else {
                PrimitiveSpec primitiveSpec = interpEnviron.mach().findPrimitive(caselessString);
                if (primitiveSpec != null) {
                    LibraryPrimitives.qsortHelper(interpEnviron, logoObjectArray2, 0, logoList.length(), null, null, primitiveSpec, caselessString.str);
                } else {
                    throw new LanguageException("I don't know how to " + caselessString);
                }
            }
        }
        return new LogoList(logoObjectArray2);
    }

    public final LogoObject pUNTIL(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        while (!logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron).toBoolean()) {
            LogoObject logoObject = logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron);
            if (interpEnviron.mach().isAutoIgnore() || logoObject == LogoVoid.obj) continue;
            throw new LanguageException("You don't say what to do with " + logoObject.toString());
        }
        return LogoVoid.obj;
    }

    public final LogoObject pWHILE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        this.testNumParams(logoObjectArray, 2);
        while (logoObjectArray[0].getRunnable(interpEnviron.mach()).execute(interpEnviron).toBoolean()) {
            LogoObject logoObject = logoObjectArray[1].getRunnable(interpEnviron.mach()).execute(interpEnviron);
            if (interpEnviron.mach().isAutoIgnore() || logoObject == LogoVoid.obj) continue;
            throw new LanguageException("You don't say what to do with " + logoObject.toString());
        }
        return LogoVoid.obj;
    }

    private static final int mapHelper(InterpEnviron interpEnviron, LogoObject logoObject, LogoList[] logoListArray, LogoObject[] logoObjectArray) throws LanguageException, ThrowException {
        LogoList logoList = null;
        Procedure procedure = null;
        PrimitiveSpec primitiveSpec = null;
        String string = null;
        if (logoObject instanceof LogoList) {
            logoList = (LogoList)logoObject;
        } else {
            CaselessString caselessString = logoObject.toCaselessString();
            procedure = interpEnviron.mach().resolveProc(caselessString);
            if (procedure == null) {
                primitiveSpec = interpEnviron.mach().findPrimitive(caselessString);
                if (primitiveSpec != null) {
                    string = caselessString.str;
                } else {
                    throw new LanguageException("I don't know how to " + caselessString);
                }
            }
        }
        int n = 0;
        for (int i = 0; i < logoListArray.length; ++i) {
            if (i == 0) {
                n = logoListArray[i].length();
                continue;
            }
            if (logoListArray[i].length() == n) continue;
            throw new LanguageException("Map lists do not have the same length");
        }
        ParseObject[] parseObjectArray = new LogoObject[logoListArray.length];
        ParseObject[] parseObjectArray2 = new ParseObject[1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            LogoObject logoObject2 = LogoVoid.obj;
            for (int j = 0; j < logoListArray.length; ++j) {
                parseObjectArray[j] = logoListArray[j].pickInPlace(i);
            }
            if (logoList != null) {
                logoObject2 = LibraryPrimitives.applyAnonymous(interpEnviron, logoList, new LogoList((LogoObject[])parseObjectArray), true);
            } else {
                parseObjectArray2[0] = procedure != null ? new ParseProcedure(procedure, parseObjectArray) : new ParsePrimitive(primitiveSpec, string, parseObjectArray);
                logoObject2 = new ParseTree(0, parseObjectArray2).execute(interpEnviron);
            }
            if (logoObjectArray != null) {
                if (logoObject2 == LogoVoid.obj) continue;
                logoObjectArray[n2] = logoObject2;
                ++n2;
                continue;
            }
            if (interpEnviron.mach().isAutoIgnore() || logoObject2 == LogoVoid.obj) continue;
            throw new LanguageException("You don't say what to do with " + logoObject2.toString());
        }
        return n2;
    }

    private static final void qsortHelper(InterpEnviron interpEnviron, LogoObject[] logoObjectArray, int n, int n2, LogoList logoList, Procedure procedure, PrimitiveSpec primitiveSpec, String string) throws LanguageException, ThrowException {
        if (n > n2 - 2) {
            return;
        }
        int n3 = _rand.nextInt();
        if (n3 < 0) {
            n3 = -n3;
        }
        n3 = n + n3 % (n2 - n);
        LogoObject logoObject = logoObjectArray[n3];
        logoObjectArray[n3] = logoObjectArray[n];
        logoObjectArray[n] = logoObject;
        ParseObject[] parseObjectArray = new LogoObject[2];
        ParseObject[] parseObjectArray2 = new ParseObject[1];
        int n4 = n + 1;
        int n5 = n2 - 1;
        while (true) {
            block15: {
                block17: {
                    block18: {
                        block16: {
                            if (n4 > n5) break block15;
                            parseObjectArray[0] = logoObjectArray[n];
                            parseObjectArray[1] = logoObjectArray[n4];
                            if (logoList == null) break block16;
                            if (!LibraryPrimitives.applyAnonymous(interpEnviron, logoList, new LogoList((LogoObject[])parseObjectArray), true).toBoolean()) break block17;
                            break block15;
                        }
                        if (procedure == null) break block18;
                        parseObjectArray2[0] = new ParseProcedure(procedure, parseObjectArray);
                        if (!new ParseTree(0, parseObjectArray2).execute(interpEnviron).toBoolean()) break block17;
                        break block15;
                    }
                    parseObjectArray2[0] = new ParsePrimitive(primitiveSpec, string, parseObjectArray);
                    if (new ParseTree(0, parseObjectArray2).execute(interpEnviron).toBoolean()) break block15;
                }
                ++n4;
                continue;
            }
            while (n4 <= n5) {
                if (n4 != n5) {
                    parseObjectArray[0] = logoObjectArray[n5];
                    parseObjectArray[1] = logoObjectArray[n];
                    if (logoList != null) {
                        if (LibraryPrimitives.applyAnonymous(interpEnviron, logoList, new LogoList((LogoObject[])parseObjectArray), true).toBoolean()) {
                            break;
                        }
                    } else if (procedure != null) {
                        parseObjectArray2[0] = new ParseProcedure(procedure, parseObjectArray);
                        if (new ParseTree(0, parseObjectArray2).execute(interpEnviron).toBoolean()) {
                            break;
                        }
                    } else {
                        parseObjectArray2[0] = new ParsePrimitive(primitiveSpec, string, parseObjectArray);
                        if (new ParseTree(0, parseObjectArray2).execute(interpEnviron).toBoolean()) break;
                    }
                }
                --n5;
            }
            if (n4 >= n5) break;
            logoObject = logoObjectArray[n4];
            logoObjectArray[n4] = logoObjectArray[n5];
            logoObjectArray[n5] = logoObject;
        }
        logoObject = logoObjectArray[n5];
        logoObjectArray[n5] = logoObjectArray[n];
        logoObjectArray[n] = logoObject;
        LibraryPrimitives.qsortHelper(interpEnviron, logoObjectArray, n, n5, logoList, procedure, primitiveSpec, string);
        LibraryPrimitives.qsortHelper(interpEnviron, logoObjectArray, n5 + 1, n2, logoList, procedure, primitiveSpec, string);
    }
}

