/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IORandomFile;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOReadFile;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOWriteFile;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import java.io.File;
import java.io.IOException;

public final class FilePrimitives
extends PrimitiveGroup {
    public static String WDDATAID = "virtuoso.logo.wd";

    @Override
    protected void setup(Machine machine, Console console) throws SetupException {
        this.registerPrimitive("CD", "pCD", 1);
        this.registerPrimitive("CDUP", "pCDUP", 0);
        this.registerPrimitive("LOAD", "pLOAD", 1);
        this.registerPrimitive("OPENREAD", "pOPENREAD", 1);
        this.registerPrimitive("OPENWRITE", "pOPENWRITE", 1);
        this.registerPrimitive("OPENUPDATE", "pOPENUPDATE", 1);
        this.registerPrimitive("PWD", "pPWD", 0);
        this.registerPrimitive("SAVE", "pSAVE", 1);
        machine.setData(WDDATAID, System.getProperty("user.dir"));
        console.putStatusMessage("Turtle Tracks file system primitives v1.0");
    }

    public final synchronized LogoObject pCD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Path expected");
        }
        File file = FilePrimitives.absolutePath(interpEnviron.mach(), logoObjectArray[0].toString());
        if (!file.exists()) {
            throw new LanguageException("Directory not found");
        }
        if (!file.isDirectory()) {
            throw new LanguageException(logoObjectArray[0] + " isn't a directory");
        }
        try {
            interpEnviron.mach().setData(WDDATAID, file.getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new LanguageException("Unable to change directory");
        }
        return LogoVoid.obj;
    }

    public final synchronized LogoObject pCDUP(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        String string = new File((String)interpEnviron.mach().getData(WDDATAID)).getParent();
        if (string == null) {
            throw new LanguageException("Already at top of directory structure");
        }
        interpEnviron.mach().setData(WDDATAID, string);
        return LogoVoid.obj;
    }

    public final LogoObject pLOAD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Filename or path expected");
        }
        if (interpEnviron.thread().isLoading()) {
            throw new LanguageException("Attempt to load from within a load");
        }
        interpEnviron.mach().executeStream(new IOReadFile(FilePrimitives.absolutePath(interpEnviron.mach(), logoObjectArray[0])), interpEnviron.thread());
        return LogoVoid.obj;
    }

    public final LogoObject pOPENREAD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        CaselessString caselessString;
        this.testNumParams(logoObjectArray, 1, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Filename or path expected");
        }
        if (logoObjectArray.length == 2) {
            if (!(logoObjectArray[1] instanceof LogoWord)) {
                throw new LanguageException("Stream id expected");
            }
            caselessString = logoObjectArray[1].toCaselessString();
        } else {
            caselessString = new CaselessString("__f" + interpEnviron.mach().getUniqueNum());
        }
        interpEnviron.mach().registerIO(caselessString, new IOReadFile(FilePrimitives.absolutePath(interpEnviron.mach(), logoObjectArray[0])));
        if (logoObjectArray.length == 2) {
            return LogoVoid.obj;
        }
        return new LogoWord(caselessString);
    }

    public final LogoObject pOPENWRITE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        CaselessString caselessString;
        this.testNumParams(logoObjectArray, 1, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Filename or path expected");
        }
        if (logoObjectArray.length == 2) {
            if (!(logoObjectArray[1] instanceof LogoWord)) {
                throw new LanguageException("Stream id expected");
            }
            caselessString = logoObjectArray[1].toCaselessString();
        } else {
            caselessString = new CaselessString("__f" + interpEnviron.mach().getUniqueNum());
        }
        interpEnviron.mach().registerIO(caselessString, new IOWriteFile(FilePrimitives.absolutePath(interpEnviron.mach(), logoObjectArray[0])));
        if (logoObjectArray.length == 2) {
            return LogoVoid.obj;
        }
        return new LogoWord(caselessString);
    }

    public final LogoObject pOPENUPDATE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        CaselessString caselessString;
        this.testNumParams(logoObjectArray, 1, 2);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Filename or path expected");
        }
        if (logoObjectArray.length == 2) {
            if (!(logoObjectArray[1] instanceof LogoWord)) {
                throw new LanguageException("Stream id expected");
            }
            caselessString = logoObjectArray[1].toCaselessString();
        } else {
            caselessString = new CaselessString("__f" + interpEnviron.mach().getUniqueNum());
        }
        interpEnviron.mach().registerIO(caselessString, new IORandomFile(FilePrimitives.absolutePath(interpEnviron.mach(), logoObjectArray[0])));
        if (logoObjectArray.length == 2) {
            return LogoVoid.obj;
        }
        return new LogoWord(caselessString);
    }

    public final LogoObject pPWD(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 0);
        return new LogoWord((String)interpEnviron.mach().getData(WDDATAID));
    }

    public final LogoObject pSAVE(InterpEnviron interpEnviron, LogoObject[] logoObjectArray) throws LanguageException {
        this.testNumParams(logoObjectArray, 1);
        if (!(logoObjectArray[0] instanceof LogoWord)) {
            throw new LanguageException("Filename or path expected");
        }
        IOWriteFile iOWriteFile = new IOWriteFile(FilePrimitives.absolutePath(interpEnviron.mach(), logoObjectArray[0]));
        interpEnviron.mach().printout(iOWriteFile, null, null, null);
        iOWriteFile.close();
        return LogoVoid.obj;
    }

    public static final File absolutePath(Machine machine, String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        return new File((String)machine.getData(WDDATAID), string);
    }

    public static final File absolutePath(Machine machine, LogoObject logoObject) throws LanguageException {
        if (!(logoObject instanceof LogoWord)) {
            throw new LanguageException("Filename or path expected");
        }
        String string = logoObject.toString();
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        return new File((String)machine.getData(WDDATAID), string);
    }
}

