/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.app;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Tokenizer;

public abstract class InteractiveConsole
extends Console {
    private boolean _goodbye;
    protected int _priority;

    @Override
    public void goodbye() {
        this._goodbye = true;
    }

    @Override
    public void run() {
        Tokenizer tokenizer = new Tokenizer(this._mach.getTokenizerCommentFlags());
        this._priority = Thread.currentThread().getPriority();
        this._goodbye = false;
        this.putStatusMessage("");
        this.putStatusMessage("Turtle Tracks Interactive Interpreter");
        this.putStatusMessage("version 1.0  (13 November 1999)");
        this.putStatusMessage("Copyright (C) 1997-1999  Daniel Azuma  (dazuma@kagi.com)");
        this.putStatusMessage("Turtle Tracks comes with absolutely no warranty.");
        this.putStatusMessage("This is free software, and you are welcome to redistribute it under");
        this.putStatusMessage("certain conditions. For details, see the GNU General Public License.");
        this.putStatusMessage("");
        this.putStatusMessage("Welcome to Logo!");
        this.putStatusMessage("");
        while (!this._goodbye) {
            try {
                if (this.eof()) break;
                LogoList logoList = null;
                LanguageException languageException = null;
                StringBuffer stringBuffer = new StringBuffer();
                int n = 63;
                while (logoList == null && !this.eof()) {
                    String string = this.promptGetLine((char)n);
                    if (string == null) {
                        this._goodbye = true;
                        if (languageException == null) continue;
                        throw languageException;
                    }
                    try {
                        stringBuffer.append(string);
                        if (stringBuffer.length() == 0) {
                            logoList = new LogoList();
                            continue;
                        }
                        if (stringBuffer.charAt(stringBuffer.length() - 1) == '~') {
                            stringBuffer.setCharAt(stringBuffer.length() - 1, ' ');
                            n = 126;
                            continue;
                        }
                        logoList = tokenizer.tokenize(stringBuffer.toString());
                    }
                    catch (LanguageException languageException2) {
                        languageException = languageException2;
                        n = languageException2.getContChar();
                        if (n == 124 || n == 92 || n == 126) {
                            stringBuffer.append(Machine.LINE_SEPARATOR);
                            continue;
                        }
                        throw languageException2;
                    }
                }
                if (logoList == null || logoList.length() <= 0) continue;
                this._mach.spawnMainThread(logoList);
                this._mach.waitForAllTerminated();
            }
            catch (LanguageException languageException) {
                this.putLine(languageException.generateMessage());
            }
            catch (Exception exception) {
                System.err.println("Machine exception: " + exception.toString());
                exception.printStackTrace();
            }
        }
        this.putStatusMessage("");
        this.putStatusMessage("Exiting Turtle Tracks.");
    }
}

