/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Procedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Tokenizer;
import java.util.Vector;

class ParseSpecial
extends ParseObject {
    static final int TO = 0;
    static final int TOMACRO = 1;
    static final String strEND = "END";
    static final String strTO = "TO";
    static final String strTOMACRO = "TOMACRO";
    private static final LogoWord _objEND = new LogoWord("END");
    private int _code;
    private LogoList _args;

    ParseSpecial(int n, LogoList logoList) {
        this._code = n;
        this._args = logoList;
    }

    @Override
    public Object clone() {
        return new ParseSpecial(this._code, this._args);
    }

    @Override
    public boolean equals(Object object) {
        return false;
    }

    @Override
    LogoObject evaluate(InterpEnviron interpEnviron) throws LanguageException {
        if (this._code == 0) {
            this.pTO(interpEnviron, false);
        } else if (this._code == 1) {
            this.pTO(interpEnviron, true);
        } else {
            throw new LanguageException("Internal error: unrecognized special form " + String.valueOf(this._code));
        }
        return LogoVoid.obj;
    }

    private void pTO(InterpEnviron interpEnviron, boolean bl) throws LanguageException {
        Cloneable cloneable;
        Thread.yield();
        LogoObject logoObject = this._args.pickInPlace(0);
        if (!(logoObject instanceof LogoWord)) {
            throw new LanguageException("Procedure name expected");
        }
        LogoWord logoWord = (LogoWord)logoObject;
        if (logoWord.getType() == 2 || logoWord.getType() == 3 || logoWord.getType() == 4) {
            throw new LanguageException("Procedure name expected");
        }
        String string = logoWord.unparse();
        if (string.length() > 0) {
            if (string.charAt(0) == '\"') {
                throw new LanguageException("Procedure name should not be quoted");
            }
            if (string.charAt(0) == ':') {
                throw new LanguageException("Procedure name should not be preceded by a colon");
            }
        }
        CaselessString caselessString = logoWord.toCaselessString();
        Procedure.checkName(caselessString.str);
        if (!interpEnviron.mach().isOverridePrimitives() && interpEnviron.mach().isReserved(caselessString)) {
            throw new LanguageException("The name " + caselessString.str + " is a primitive.");
        }
        if (!interpEnviron.thread().isLoading() && interpEnviron.mach().resolveProc(caselessString) != null) {
            throw new LanguageException("The procedure " + caselessString.str + " is already defined.");
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 1; i < this._args.length(); ++i) {
            logoObject = this._args.pickInPlace(i);
            if (!(logoObject instanceof LogoWord)) {
                throw new LanguageException("Parameter name expected but list found.");
            }
            string = logoObject.toString();
            if (string.length() == 0) {
                throw new LanguageException("Parameter name must be preceded by a colon.");
            }
            if (string.charAt(0) != ':') {
                throw new LanguageException("Parameter name must be preceded by a colon");
            }
            vector.addElement(new LogoWord(string.substring(1)));
        }
        LogoList logoList = new LogoList(vector);
        Procedure.checkParamNames(logoList);
        Tokenizer tokenizer = new Tokenizer(interpEnviron.mach().getTokenizerCommentFlags());
        vector = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 62;
        while (!interpEnviron.thread().inStream().eof()) {
            String string2 = interpEnviron.thread().isLoading() ? interpEnviron.thread().inStream().getLine() : interpEnviron.mach().console().promptGetLine('>');
            stringBuffer.append(string2);
            if (stringBuffer.length() > 0) {
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '~') {
                    stringBuffer.setCharAt(stringBuffer.length() - 1, ' ');
                    n = 126;
                } else {
                    try {
                        cloneable = tokenizer.tokenize(stringBuffer.toString());
                        if (((LogoList)cloneable).length() == 1 && CaselessString.staticEquals(((LogoList)cloneable).pickInPlace(0).toString(), strEND)) break;
                        stringBuffer = new StringBuffer();
                        n = 62;
                    }
                    catch (LanguageException languageException) {
                        n = languageException.getContChar();
                        if (n == 124 || n == 92 || n == 126) {
                            stringBuffer.append(Machine.LINE_SEPARATOR);
                        }
                        throw languageException;
                    }
                }
            }
            vector.addElement(string2);
        }
        cloneable = new Procedure(interpEnviron.mach(), caselessString, logoList, vector, bl);
        interpEnviron.mach().defineProc((Procedure)cloneable);
        interpEnviron.mach().console().putStatusMessage(caselessString.str + " defined.");
    }
}

