/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOBase;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpreterThread;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseTree;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveSpec;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Procedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SymbolTable;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ThrowException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Tokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public final class Machine {
    public static final String CONSOLE_STREAM_NAME = ".CONSOLE";
    public static final String MAIN_THREAD_NAME = ".MAIN";
    public static final String PRIVATE_NAME = ".PRIVATE";
    public static final String LOGO_PROPERTYLIST_NAME = ".SYSTEM";
    public static final String TURTLETRACKS_VERSION = "1.0";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Vector _primitiveGroups;
    private SymbolTable _syms = new SymbolTable();
    private Hashtable _procs = new Hashtable();
    private Hashtable _fileids = new Hashtable();
    private Hashtable _proplists = new Hashtable();
    private Hashtable _data = new Hashtable();
    private Hashtable _threads = new Hashtable();
    private int _suspended = 0;
    private Object _suspendedLock = new Object();
    private Random _random;
    private int _uniqueNum = 0;
    private Object _uniqueNumLock = new Object();
    private int _clock;
    private IOBase _instream;
    private CaselessString _instreamID;
    private IOBase _outstream;
    private CaselessString _outstreamID;
    private Console _console;
    private boolean _hashComments;
    private boolean _overridePrimitive;
    private boolean _autoIgnore;

    public Machine(Console console, PrimitiveGroup[] primitiveGroupArray) {
        this._random = new Random(0L);
        this._console = console;
        this._primitiveGroups = new Vector(primitiveGroupArray.length);
        for (int i = 0; i < primitiveGroupArray.length; ++i) {
            this._primitiveGroups.addElement(primitiveGroupArray[i]);
        }
        this._instream = this._console;
        this._outstream = this._console;
        this._instreamID = null;
        this._outstreamID = null;
        this._clock = 0;
        this._hashComments = false;
        this._overridePrimitive = false;
        this._autoIgnore = false;
    }

    public final void setup() throws SetupException {
        this._console.setMachine(this);
        this._console.setup();
        this._console.putStatusMessage("Turtle Tracks runtime system v1.0");
        for (int i = 0; i < this._primitiveGroups.size(); ++i) {
            ((PrimitiveGroup)this._primitiveGroups.elementAt(i)).setup(this, this._console);
        }
    }

    public final void cleanup() {
        for (int i = 0; i < this._primitiveGroups.size(); ++i) {
            ((PrimitiveGroup)this._primitiveGroups.elementAt(i)).exiting();
        }
        this._console.exiting();
    }

    public final Console console() {
        return this._console;
    }

    public final synchronized void loadPrimitives(String string) throws LanguageException {
        try {
            for (int i = 0; i < this._primitiveGroups.size(); ++i) {
                if (!this._primitiveGroups.elementAt(i).getClass().getName().equals(string)) continue;
                return;
            }
            Class<?> clazz = Class.forName(string);
            PrimitiveGroup primitiveGroup = (PrimitiveGroup)clazz.newInstance();
            try {
                primitiveGroup.setup(this, this._console);
            }
            catch (SetupException setupException) {
                throw new LanguageException("Primitive group " + string + " refused to load.");
            }
            this._primitiveGroups.addElement(primitiveGroup);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LanguageException("Class " + string + " not found.");
        }
        catch (ClassCastException classCastException) {
            throw new LanguageException("Class " + string + " isn't a PrimitiveGroup.");
        }
        catch (InstantiationException instantiationException) {
            throw new LanguageException("Class " + string + " couldn't be instantiated.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LanguageException("Class " + string + " not accessible.");
        }
        ++this._clock;
    }

    public final synchronized void loadPrimitives(PrimitiveGroup primitiveGroup) throws LanguageException {
        String string = primitiveGroup.getClass().getName();
        for (int i = 0; i < this._primitiveGroups.size(); ++i) {
            if (!this._primitiveGroups.elementAt(i).getClass().getName().equals(string)) continue;
            return;
        }
        try {
            primitiveGroup.setup(this, this._console);
        }
        catch (SetupException setupException) {
            throw new LanguageException("Primitive group " + string + " refused to load.");
        }
        this._primitiveGroups.addElement(primitiveGroup);
        ++this._clock;
    }

    public final synchronized void unloadPrimitives(String string) {
        for (int i = 0; i < this._primitiveGroups.size(); ++i) {
            if (!this._primitiveGroups.elementAt(i).getClass().getName().equals(string)) continue;
            ((PrimitiveGroup)this._primitiveGroups.elementAt(i)).exiting();
            this._primitiveGroups.removeElementAt(i);
            ++this._clock;
            return;
        }
    }

    public final synchronized void unloadPrimitives(PrimitiveGroup primitiveGroup) {
        for (int i = 0; i < this._primitiveGroups.size(); ++i) {
            if (this._primitiveGroups.elementAt(i) != primitiveGroup) continue;
            primitiveGroup.exiting();
            this._primitiveGroups.removeElementAt(i);
            ++this._clock;
            return;
        }
    }

    public final synchronized PrimitiveGroup getPrimitiveGroup(String string) {
        for (int i = 0; i < this._primitiveGroups.size(); ++i) {
            if (!this._primitiveGroups.elementAt(i).getClass().getName().equals(string)) continue;
            return (PrimitiveGroup)this._primitiveGroups.elementAt(i);
        }
        return null;
    }

    public final synchronized PrimitiveSpec findPrimitive(CaselessString caselessString) {
        for (int i = this._primitiveGroups.size() - 1; i >= 0; --i) {
            PrimitiveSpec primitiveSpec = ((PrimitiveGroup)this._primitiveGroups.elementAt(i)).getPrimitiveMethod(caselessString);
            if (primitiveSpec == null) continue;
            return primitiveSpec;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnThread(CaselessString caselessString, LogoList logoList, CaselessString caselessString2, IOBase iOBase, CaselessString caselessString3, IOBase iOBase2, SymbolTable symbolTable) throws LanguageException {
        Hashtable hashtable = this._threads;
        synchronized (hashtable) {
            Thread thread = Thread.currentThread();
            if (thread instanceof InterpreterThread && ((InterpreterThread)thread).stopping()) {
                return;
            }
            if (this._threads.get(caselessString) != null) {
                throw new LanguageException("Duplicate thread ID");
            }
            InterpreterThread interpreterThread = new InterpreterThread(caselessString, logoList, caselessString2, iOBase, caselessString3, iOBase2, symbolTable, this);
            this._threads.put(caselessString, interpreterThread);
            interpreterThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnThread(CaselessString caselessString, ParseTree parseTree, CaselessString caselessString2, IOBase iOBase, CaselessString caselessString3, IOBase iOBase2, SymbolTable symbolTable) throws LanguageException {
        Hashtable hashtable = this._threads;
        synchronized (hashtable) {
            Thread thread = Thread.currentThread();
            if (thread instanceof InterpreterThread && ((InterpreterThread)thread).stopping()) {
                return;
            }
            if (this._threads.get(caselessString) != null) {
                throw new LanguageException("Duplicate thread ID");
            }
            InterpreterThread interpreterThread = new InterpreterThread(caselessString, parseTree, caselessString2, iOBase, caselessString3, iOBase2, symbolTable, this);
            this._threads.put(caselessString, interpreterThread);
            interpreterThread.start();
        }
    }

    public final void spawnMainThread(LogoList logoList) throws LanguageException {
        this.spawnThread(new CaselessString(MAIN_THREAD_NAME), logoList, this._instreamID, this._instream, this._outstreamID, this._outstream, new SymbolTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void threadEnding(CaselessString caselessString) {
        Hashtable hashtable = this._threads;
        synchronized (hashtable) {
            this._threads.remove(caselessString);
            this._threads.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminateOneThread(CaselessString caselessString) throws LanguageException {
        Hashtable hashtable = this._threads;
        synchronized (hashtable) {
            InterpreterThread interpreterThread = (InterpreterThread)this._threads.get(caselessString);
            if (interpreterThread == null) {
                throw new LanguageException("No such thread \"" + caselessString + "\"");
            }
            interpreterThread.signalStop();
            interpreterThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminateAllThreads() {
        Hashtable hashtable = this._threads;
        synchronized (hashtable) {
            Enumeration enumeration = this._threads.elements();
            while (enumeration.hasMoreElements()) {
                InterpreterThread interpreterThread = (InterpreterThread)enumeration.nextElement();
                interpreterThread.signalStop();
                interpreterThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForAllTerminated() {
        Hashtable hashtable = this._threads;
        synchronized (hashtable) {
            while (this._threads.size() != 0) {
                try {
                    this._threads.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        Object object = this._suspendedLock;
        synchronized (object) {
            ++this._suspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsuspend() {
        Object object = this._suspendedLock;
        synchronized (object) {
            --this._suspended;
            if (this._suspended == 0) {
                this._suspendedLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkSuspend() {
        Object object = this._suspendedLock;
        synchronized (object) {
            if (this._suspended > 0) {
                try {
                    this._suspendedLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    final synchronized int getClock() {
        return this._clock;
    }

    public final Random random() {
        return this._random;
    }

    public final void randomize(long l) {
        this._random.setSeed(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setData(String string, Object object) {
        Hashtable hashtable = this._data;
        synchronized (hashtable) {
            this._data.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getData(String string) {
        Hashtable hashtable = this._data;
        synchronized (hashtable) {
            return this._data.get(string);
        }
    }

    public final void setInStream(CaselessString caselessString, IOBase iOBase) {
        this._instreamID = caselessString;
        this._instream = iOBase;
    }

    public final void setOutStream(CaselessString caselessString, IOBase iOBase) {
        this._outstreamID = caselessString;
        this._outstream = iOBase;
    }

    public final void setHashComments(boolean bl) {
        this._hashComments = bl;
    }

    public final int getTokenizerCommentFlags() {
        if (this._hashComments) {
            return 3;
        }
        return 1;
    }

    public final synchronized boolean isOverridePrimitives() {
        return this._overridePrimitive;
    }

    public final synchronized boolean isAutoIgnore() {
        return this._autoIgnore;
    }

    public final synchronized boolean isReserved(CaselessString caselessString) {
        for (int i = 0; i < this._primitiveGroups.size(); ++i) {
            if (!((PrimitiveGroup)this._primitiveGroups.elementAt(i)).isPrimitive(caselessString)) continue;
            return true;
        }
        if (caselessString.equals("TO")) {
            return true;
        }
        if (caselessString.equals("TOMACRO")) {
            return true;
        }
        return caselessString.equals("END");
    }

    public final synchronized void defineProc(Procedure procedure) {
        ++this._clock;
        this._procs.remove(procedure.getName());
        this._procs.put(procedure.getName(), procedure);
    }

    public final synchronized Procedure resolveProc(CaselessString caselessString) {
        return (Procedure)this._procs.get(caselessString);
    }

    public final synchronized boolean eraseProc(CaselessString caselessString) {
        return this._procs.remove(caselessString) != null;
    }

    public final synchronized LogoList getProcList() {
        Vector<LogoWord> vector = new Vector<LogoWord>();
        Enumeration enumeration = this._procs.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new LogoWord((CaselessString)enumeration.nextElement()));
        }
        return new LogoList(vector);
    }

    public final synchronized void makeName(CaselessString caselessString, LogoObject logoObject) {
        this._syms.makeForced(caselessString, logoObject);
    }

    public final synchronized LogoObject resolveName(CaselessString caselessString) {
        return this._syms.resolve(caselessString);
    }

    public final synchronized void eraseName(CaselessString caselessString) {
        this._syms.erase(caselessString);
    }

    public final synchronized LogoObject getNameList() {
        return this._syms.getNames();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void putProp(CaselessString caselessString, CaselessString caselessString2, LogoObject logoObject) throws LanguageException {
        if (caselessString.equals(LOGO_PROPERTYLIST_NAME)) {
            if (caselessString2.equals("LOGO.CASESENSITIVE")) {
                CaselessString.setSensitivity(logoObject.toBoolean());
                return;
            } else if (caselessString2.equals("LOGO.OVERRIDEPRIMITIVES")) {
                this._overridePrimitive = logoObject.toBoolean();
                return;
            } else {
                if (!caselessString2.equals("LOGO.AUTOIGNORE")) throw new LanguageException("Can't write to property " + caselessString2.toString() + " in system property list.");
                this._autoIgnore = logoObject.toBoolean();
            }
            return;
        } else {
            Hashtable<CaselessString, LogoObject> hashtable = (Hashtable<CaselessString, LogoObject>)this._proplists.get(caselessString);
            if (hashtable == null) {
                hashtable = new Hashtable<CaselessString, LogoObject>();
                this._proplists.put(caselessString, hashtable);
            }
            hashtable.remove(caselessString2);
            hashtable.put(caselessString2, logoObject);
        }
    }

    public final synchronized LogoObject getProp(CaselessString caselessString, CaselessString caselessString2) throws LanguageException {
        LogoObject logoObject;
        if (caselessString.equals(LOGO_PROPERTYLIST_NAME)) {
            if (caselessString2.equals("LOGO.CASESENSITIVE")) {
                return new LogoWord(CaselessString.getSensitivity());
            }
            if (caselessString2.equals("LOGO.OVERRIDEPRIMITIVES")) {
                return new LogoWord(this._overridePrimitive);
            }
            if (caselessString2.equals("LOGO.AUTOIGNORE")) {
                return new LogoWord(this._autoIgnore);
            }
            if (caselessString2.equals("LOGO.VERSION")) {
                return new LogoWord(TURTLETRACKS_VERSION);
            }
            if (caselessString2.equals("JAVA.VERSION")) {
                return new LogoWord(System.getProperty("java.version"));
            }
            if (caselessString2.equals("OS.NAME")) {
                return new LogoWord(System.getProperty("os.name"));
            }
            if (caselessString2.equals("OS.ARCH")) {
                return new LogoWord(System.getProperty("os.arch"));
            }
            throw new LanguageException("Can't read property " + caselessString2.toString() + " in system property list.");
        }
        Hashtable hashtable = (Hashtable)this._proplists.get(caselessString);
        if (hashtable != null && (logoObject = (LogoObject)hashtable.get(caselessString2)) != null) {
            return logoObject;
        }
        return new LogoList();
    }

    public final synchronized void remProp(CaselessString caselessString, CaselessString caselessString2) throws LanguageException {
        if (caselessString.equals(LOGO_PROPERTYLIST_NAME)) {
            throw new LanguageException("Can't remove properties from system property list.");
        }
        Hashtable hashtable = (Hashtable)this._proplists.get(caselessString);
        if (hashtable != null) {
            hashtable.remove(caselessString2);
            if (hashtable.isEmpty()) {
                this._proplists.remove(caselessString);
            }
        }
    }

    public final synchronized LogoList getPLists() {
        Vector<LogoWord> vector = new Vector<LogoWord>();
        Enumeration enumeration = this._proplists.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new LogoWord((CaselessString)enumeration.nextElement()));
        }
        return new LogoList(vector);
    }

    public final synchronized LogoList getPropsInList(CaselessString caselessString) {
        Hashtable hashtable = (Hashtable)this._proplists.get(caselessString);
        if (hashtable == null) {
            return new LogoList();
        }
        Vector<LogoWord> vector = new Vector<LogoWord>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new LogoWord((CaselessString)enumeration.nextElement()));
        }
        return new LogoList(vector);
    }

    public final synchronized String[] getPropsForExec(CaselessString caselessString) {
        Hashtable hashtable = (Hashtable)this._proplists.get(caselessString);
        if (hashtable == null) {
            return null;
        }
        String[] stringArray = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            CaselessString caselessString2 = (CaselessString)enumeration.nextElement();
            LogoObject logoObject = (LogoObject)hashtable.get(caselessString2);
            stringArray[n] = logoObject instanceof LogoList ? caselessString2.str + '=' + ((LogoList)logoObject).toStringOpen() : caselessString2.str + '=' + ((LogoList)logoObject).toString();
            ++n;
        }
        return stringArray;
    }

    public final synchronized void eraseAll() {
        this._syms.eraseAll();
        this._procs.clear();
        this._proplists.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerIO(CaselessString caselessString, IOBase iOBase) throws LanguageException {
        Hashtable hashtable = this._fileids;
        synchronized (hashtable) {
            if (this._fileids.containsKey(caselessString)) {
                throw new LanguageException("Duplicate fileid");
            }
            this._fileids.put(caselessString, iOBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IOBase getIO(CaselessString caselessString) {
        Hashtable hashtable = this._fileids;
        synchronized (hashtable) {
            return (IOBase)this._fileids.get(caselessString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeIO(CaselessString caselessString) throws LanguageException {
        Hashtable hashtable = this._fileids;
        synchronized (hashtable) {
            IOBase iOBase = (IOBase)this._fileids.remove(caselessString);
            if (iOBase == null) {
                throw new LanguageException("Stream is closed");
            }
            iOBase.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeAllIO() {
        Hashtable hashtable = this._fileids;
        synchronized (hashtable) {
            Enumeration enumeration = this._fileids.keys();
            try {
                while (enumeration.hasMoreElements()) {
                    this.closeIO((CaselessString)enumeration.nextElement());
                }
            }
            catch (LanguageException languageException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LogoList getFileidList() {
        Vector<LogoWord> vector = new Vector<LogoWord>();
        Hashtable hashtable = this._fileids;
        synchronized (hashtable) {
            Enumeration enumeration = this._fileids.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement(new LogoWord((CaselessString)enumeration.nextElement()));
            }
        }
        return new LogoList(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getUniqueNum() {
        Object object = this._uniqueNumLock;
        synchronized (object) {
            ++this._uniqueNum;
            return this._uniqueNum;
        }
    }

    public final synchronized void executeStream(IOBase iOBase, InterpreterThread interpreterThread) throws LanguageException {
        try {
            Tokenizer tokenizer = new Tokenizer(this.getTokenizerCommentFlags());
            interpreterThread.startLoading(iOBase);
            while (!iOBase.eof()) {
                StringBuffer stringBuffer = new StringBuffer();
                LogoList logoList = null;
                while (!iOBase.eof()) {
                    try {
                        stringBuffer.append(interpreterThread.inStream().getLine());
                        if (stringBuffer.length() <= 0) continue;
                        if (stringBuffer.charAt(stringBuffer.length() - 1) == '~') {
                            stringBuffer.setCharAt(stringBuffer.length() - 1, ' ');
                            continue;
                        }
                        logoList = tokenizer.tokenize(stringBuffer.toString());
                        break;
                    }
                    catch (LanguageException languageException) {
                        char c = languageException.getContChar();
                        if (c == '|' || c == '\\' || c == '~') {
                            stringBuffer.append(LINE_SEPARATOR);
                            continue;
                        }
                        throw languageException;
                    }
                }
                if (logoList == null) continue;
                logoList.getRunnable(interpreterThread.mach()).execute(new InterpEnviron(interpreterThread));
            }
        }
        catch (LanguageException languageException) {
            throw new LanguageException("Error while running: " + languageException.generateMessage());
        }
        catch (ThrowException throwException) {
            throw new LanguageException("Error while running: " + throwException.toString());
        }
        finally {
            iOBase.close();
            interpreterThread.endLoading();
        }
    }

    public final synchronized void printout(IOBase iOBase, LogoObject logoObject, LogoObject logoObject2, LogoObject logoObject3) throws LanguageException {
        Object object;
        Object object2;
        Object object3;
        CaselessString caselessString;
        Enumeration<Object> enumeration = logoObject2 != null ? logoObject2.enumerateCaselessStrings() : this._syms.getEnumeratedNames();
        while (enumeration.hasMoreElements()) {
            caselessString = (CaselessString)enumeration.nextElement();
            object3 = this._syms.resolve(caselessString);
            if (object3 == null) {
                throw new LanguageException(caselessString + " has no value.");
            }
            object2 = caselessString.unparse();
            object = ((LogoObject)object3).unparse();
            if (object3 instanceof LogoList) {
                iOBase.putLine("MAKE \"" + (String)object2 + ' ' + (String)object);
                continue;
            }
            if (!(object3 instanceof LogoWord)) continue;
            iOBase.putLine("MAKE \"" + (String)object2 + " \"" + (String)object);
        }
        enumeration = logoObject3 != null ? logoObject3.enumerateCaselessStrings() : this._proplists.keys();
        while (enumeration.hasMoreElements()) {
            caselessString = (CaselessString)enumeration.nextElement();
            object3 = caselessString.unparse();
            object2 = (Hashtable)this._proplists.get(caselessString);
            if (object2 == null) continue;
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                CaselessString caselessString2 = (CaselessString)object.nextElement();
                LogoObject logoObject4 = (LogoObject)((Hashtable)object2).get(caselessString2);
                String string = caselessString2.unparse();
                String string2 = logoObject4.unparse();
                if (logoObject4 instanceof LogoList) {
                    iOBase.putLine("PPROP \"" + (String)object3 + " \"" + string + ' ' + string2);
                    continue;
                }
                if (!(logoObject4 instanceof LogoWord)) continue;
                iOBase.putLine("PPROP \"" + (String)object3 + " \"" + string + " \"" + string2);
            }
        }
        enumeration = logoObject != null ? logoObject.enumerateCaselessStrings() : this._procs.keys();
        while (enumeration.hasMoreElements()) {
            caselessString = (CaselessString)enumeration.nextElement();
            object3 = (Procedure)this._procs.get(caselessString);
            if (object3 == null) {
                throw new LanguageException("I don't know how to " + caselessString);
            }
            iOBase.putLine("");
            ((Procedure)object3).writeToIO(iOBase);
        }
    }
}

