/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.app.CliNoPromptConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class StringReaderConsole
extends CliNoPromptConsole {
    private BufferedReader bufferedReader;
    private StringReader stringReader;
    private boolean endOfString = true;

    @Override
    protected void setup() {
    }

    public void setup(String string) {
        this.stringReader = new StringReader(string);
        this.bufferedReader = new BufferedReader(this.stringReader, string.length());
        this.endOfString = false;
    }

    @Override
    public synchronized boolean eof() {
        return this.endOfString;
    }

    @Override
    public synchronized String getLine() {
        try {
            String string = this.bufferedReader.readLine();
            if (string == null) {
                this.endOfString = true;
            }
            return string;
        }
        catch (IOException iOException) {
            this.putLine("I/O error reading from console!");
            return "";
        }
    }

    @Override
    public synchronized String promptGetLine(char c) {
        return this.getLine();
    }

    @Override
    public synchronized int getAvailable(char[] cArray) throws LanguageException {
        try {
            int n;
            for (n = 0; this.bufferedReader.ready() && n < cArray.length; ++n) {
                cArray[n] = (char)this.bufferedReader.read();
            }
            return n;
        }
        catch (IOException iOException) {
            throw new LanguageException(iOException.toString());
        }
    }

    @Override
    public synchronized void put(char c) {
        System.out.print(c);
        System.out.flush();
    }

    @Override
    public synchronized void put(String string) {
        System.out.print(string);
        System.out.flush();
    }

    @Override
    public synchronized void put(char[] cArray, int n) {
        System.out.print(new String(cArray, 0, n));
        System.out.flush();
    }

    @Override
    public synchronized void putLine(String string) {
        System.out.println(string);
    }

    @Override
    public synchronized char getChar() {
        try {
            return (char)this.bufferedReader.read();
        }
        catch (IOException iOException) {
            this.putLine("I/O error reading from console!");
            return '\u0000';
        }
    }

    @Override
    public synchronized boolean charAvail() {
        try {
            return this.bufferedReader.ready();
        }
        catch (IOException iOException) {
            this.putLine("I/O error reading from console!");
            return false;
        }
    }

    @Override
    public synchronized void createEditor(String string) throws LanguageException {
        throw new LanguageException("Editor not available");
    }
}

